/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.handler;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.handler.OpenFileEntityHandler;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.composer.testsuite.collection.constant.ImageConstants;
import com.kms.katalon.composer.testsuite.collection.part.TestSuiteCollectionPart;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.tracking.service.Trackings;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.framework.FrameworkUtil;

public class OpenTestSuiteCollectionHandler
extends OpenFileEntityHandler<TestSuiteCollectionEntity> {
    private static final String TEST_SUITE_COLLECTION_BUNDLE_URI = "bundleclass://" + FrameworkUtil.getBundle(OpenTestSuiteCollectionHandler.class).getSymbolicName() + "/";
    private static final String TEST_SUITE_COLLECTION_PART_URI = String.valueOf(TEST_SUITE_COLLECTION_BUNDLE_URI) + TestSuiteCollectionPart.class.getName();

    @PostConstruct
    protected void initialize() {
        super.initialize();
    }

    public String getContributionURI() {
        return TEST_SUITE_COLLECTION_PART_URI;
    }

    public String getIconURI() {
        return ImageConstants.URL_16_TEST_SUITE_COLLECTION;
    }

    public String getPartId(TestSuiteCollectionEntity fileEntity) {
        return EntityPartUtil.getTestSuiteCollectionPartId((String)fileEntity.getId());
    }

    protected Class<? extends TestSuiteCollectionEntity> getEntityType() {
        return TestSuiteCollectionEntity.class;
    }

    protected void execute(TestSuiteCollectionEntity testSuiteCollectionEntity) {
        String partId = this.getPartId(testSuiteCollectionEntity);
        MPart mPart = (MPart)this.getModelService().find(partId, (MUIElement)this.getApplication());
        boolean alreadyOpened = mPart != null;
        super.execute((FileEntity)testSuiteCollectionEntity);
        if (!alreadyOpened) {
            Trackings.trackOpenObject((String)"testSuiteCollection");
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="TEST_SUITE_COLLECTION/OPEN") Object eventData) {
        if (ProjectController.getInstance().getCurrentProject() == null) {
            return;
        }
        if (!(eventData instanceof String)) {
            return;
        }
        try {
            this.execute(TestSuiteCollectionController.getInstance().getTestRunByDisplayId((String)eventData));
        }
        catch (DALException dALException) {
            MessageDialog.openError(null, (String)StringConstants.WARN, (String)ComposerTestsuiteCollectionMessageConstants.HAND_UNDABLE_TO_OPEN_TEST_SUITE_COLLECTION);
        }
    }
}

