/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.collection.constant.StringConstants;
import com.kms.katalon.composer.testsuite.collection.dialog.NewTestSuiteCollectionDialog;
import com.kms.katalon.composer.testsuite.collection.handler.TestSuiteTreeRootCatcher;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.tracking.service.Trackings;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewTestSuiteCollectionHandler
extends TestSuiteTreeRootCatcher {
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IEventBroker eventBroker;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        FolderTreeEntity parentTreeFolder = this.getParentTestRunTreeFolder(this.selectionService, true);
        if (parentTreeFolder == null) {
            return;
        }
        try {
            FolderEntity parentFolder = parentTreeFolder.getObject();
            String suggestedName = EntityNameController.getInstance().getAvailableName(StringConstants.HDL_NEW_TEST_SUITE_COLLECTION_NAME, parentFolder, false);
            NewTestSuiteCollectionDialog dialog = new NewTestSuiteCollectionDialog(parentShell, parentFolder, suggestedName);
            if (dialog.open() != 0) {
                return;
            }
            TestSuiteCollectionEntity testRunEntity = (TestSuiteCollectionEntity)dialog.getEntity();
            if (testRunEntity == null) {
                return;
            }
            TestSuiteCollectionTreeEntity newTreeEntity = new TestSuiteCollectionTreeEntity(testRunEntity, parentTreeFolder);
            Trackings.trackCreatingObject((String)"testSuiteCollection");
            this.eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentTreeFolder);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)newTreeEntity);
            this.eventBroker.post("TEST_SUITE_COLLECTION/OPEN", (Object)testRunEntity.getIdForDisplay());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HDL_MSG_UNABLE_TO_CREATE_TEST_SUITE_COLLECTION, (String)e.getMessage());
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="TEST_SUITE_COLLECTION/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }
}

