/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.handler;

import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;

public class DeleteTestSuiteCollectionHandler
implements IDeleteEntityHandler {
    @Inject
    private IEventBroker eventBroker;

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (!(treeEntity instanceof TestSuiteCollectionTreeEntity)) {
                return false;
            }
            String taskName = "Deleting " + treeEntity.getTypeName() + " '" + treeEntity.getText() + "'...";
            monitor.beginTask(taskName, 1);
            TestSuiteCollectionEntity testSuiteCollection = (TestSuiteCollectionEntity)treeEntity.getObject();
            UISynchronizeService.syncExec(() -> EntityPartUtil.closePart((IEntity)testSuiteCollection));
            TestSuiteCollectionController.getInstance().deleteTestSuiteCollection(testSuiteCollection);
            this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)testSuiteCollection.getIdForDisplay());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    public Class<? extends ITreeEntity> entityType() {
        return TestSuiteCollectionTreeEntity.class;
    }
}

