/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.websocket;

import com.google.gson.JsonSyntaxException;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionMapping;
import com.kms.katalon.composer.webui.recorder.util.HTMLActionJsonParser;
import com.kms.katalon.objectspy.util.HTMLElementUtil;
import com.kms.katalon.objectspy.websocket.AddonCommand;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.messages.AddonMessage;
import java.io.UnsupportedEncodingException;
import javax.websocket.ClientEndpoint;
import javax.websocket.server.ServerEndpoint;

@ClientEndpoint
@ServerEndpoint(value="/")
public class RecorderAddonSocket
extends AddonSocket {
    protected void handleOldElementMessage(String message) {
        try {
            String key;
            switch (key = HTMLElementUtil.decodeURIComponent((String)message.substring(0, message.indexOf("=")))) {
                case "elementAction": {
                    this.addNewAction(message.substring(message.indexOf("=") + 1, message.length()));
                    break;
                }
                default: {
                    super.handleOldElementMessage(message);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void seleniumSocketResponder() {
        this.sendMessage(new AddonMessage(AddonCommand.START_RECORD));
        System.out.println("WS: Start recording");
    }

    private void addNewAction(String value) {
        try {
            HTMLActionMapping actionMapping = HTMLActionJsonParser.parseJsonIntoHTMLActionMapping(value);
            EventBrokerSingleton.getInstance().getEventBroker().post("RECORDER/HTML_ACTION_CAPTURED", (Object)actionMapping);
        }
        catch (JsonSyntaxException | UnsupportedEncodingException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void sendMessage(AddonMessage message) {
        if (message.getCommand().equals((Object)AddonCommand.HIGHLIGHT_OBJECT)) {
            super.sendMessage(new AddonMessage(AddonCommand.START_INSPECT, null));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            super.sendMessage(message);
            super.sendMessage(new AddonMessage(AddonCommand.START_RECORD, null));
        } else {
            super.sendMessage(message);
        }
    }

    public void onWebSocketError(Throwable cause) {
        super.onWebSocketError(cause);
    }
}

