/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.preferences;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.composer.webui.recorder.constants.StringConstants;
import com.kms.katalon.composer.webui.recorder.preferences.RecorderPreferenceDefaultValueInitializer;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RecorderPreferencePage
extends PreferencePageWithHelp {
    private Combo cbbDefaultBrowser;
    private Composite mainComposite;
    private Button chckPinRecorder;

    public RecorderPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.recorder"));
    }

    protected Control createContents(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)new GridData(768));
        this.chckPinRecorder = new Button(this.mainComposite, 32);
        this.chckPinRecorder.setText(ComposerWebuiRecorderMessageConstants.PREF_LBL_PIN_RECORDER_WINDOW);
        GridData ldPinRecorder = new GridData(16384, 0x1000000, true, false);
        ldPinRecorder.horizontalSpan = 2;
        this.chckPinRecorder.setLayoutData((Object)ldPinRecorder);
        Label lblDefaultBrowser = new Label(this.mainComposite, 0);
        lblDefaultBrowser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblDefaultBrowser.setText(ComposerWebuiRecorderMessageConstants.PREF_LBL_DEFAULT_BROWSER);
        this.cbbDefaultBrowser = new Combo(this.mainComposite, 12);
        this.cbbDefaultBrowser.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbbDefaultBrowser.setText(StringConstants.PREF_LBL_DEFAULT_BROWSER);
        this.setInput();
        return this.mainComposite;
    }

    private void setInput() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        List<String> browsers = this.getDefaultBrowserOptions();
        String selectedBrowser = preferenceStore.getString("recorder.defaultBrowser");
        int index = browsers.indexOf(selectedBrowser);
        this.cbbDefaultBrowser.setItems(browsers.toArray(new String[browsers.size()]));
        this.cbbDefaultBrowser.select(Math.max(0, index));
        this.chckPinRecorder.setSelection(preferenceStore.getBoolean("recorder.pinWindow"));
    }

    private List<String> getDefaultBrowserOptions() {
        ArrayList<String> browsers = new ArrayList<String>(Arrays.asList(RecorderPreferenceDefaultValueInitializer.SUPPORTED_BROWSERS));
        if (!"win32".equals(Platform.getOS())) {
            browsers.remove(WebUIDriverType.IE_DRIVER.toString());
        }
        return browsers;
    }

    public boolean performOk() {
        if (this.mainComposite == null || this.mainComposite.isDisposed()) {
            return true;
        }
        ScopedPreferenceStore store = (ScopedPreferenceStore)this.getPreferenceStore();
        store.setValue("recorder.defaultBrowser", this.cbbDefaultBrowser.getText());
        store.setValue("recorder.pinWindow", this.chckPinRecorder.getSelection());
        try {
            store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return super.performOk();
    }
}

