/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.handler;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.handlers.NewTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionMapping;
import com.kms.katalon.composer.webui.recorder.constants.StringConstants;
import com.kms.katalon.composer.webui.recorder.dialog.RecorderDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.objectspy.dialog.SaveToObjectRepositoryDialog;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.Keys;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RecordHandler {
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private UISynchronize sync;
    private RecorderDialog recordDialog;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("KATALON/RECORD", new EventHandler(){

            public void handleEvent(Event event) {
                if (!RecordHandler.this.canExecute()) {
                    return;
                }
                RecordHandler.this.execute();
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute() {
        Shell shell = null;
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell == null) {
            return;
        }
        try {
            TestCaseCompositePart testCaseCompositePart = this.getSelectedTestCasePart();
            if (testCaseCompositePart != null && !this.verifyTestCase(testCaseCompositePart)) {
                return;
            }
            List wrapper = new ArrayList();
            List<Object> variables = new ArrayList<VariableEntity>();
            TestCaseEntity testCaseEntity = null;
            if (testCaseCompositePart != null) {
                String scriptContent = StringUtils.defaultString((String)testCaseCompositePart.getScriptContent());
                wrapper = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)scriptContent).getRunMethod().getBlock().getAstChildren();
                testCaseEntity = testCaseCompositePart.getTestCase();
                variables = testCaseCompositePart.getTestCase().clone().getVariables();
            }
            if (this.recordDialog != null && !this.recordDialog.isDisposed()) {
                this.recordDialog.getShell().forceActive();
                return;
            }
            shell = this.getShell(activeShell);
            this.recordDialog = new RecorderDialog(shell, testCaseEntity, wrapper, variables);
            int responseCode = this.recordDialog.open();
            if (responseCode != 0) {
                return;
            }
            try {
                SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult = this.recordDialog.getTargetFolderTreeEntity();
                List<HTMLActionMapping> recordedActions = this.recordDialog.getActions();
                List<WebPage> recordedElements = this.recordDialog.getElements();
                boolean shouldOverride = true;
                if (testCaseCompositePart == null || testCaseCompositePart.isDisposed()) {
                    testCaseCompositePart = this.createNewTestCase();
                    shouldOverride = false;
                }
                this.doGenerateTestScripts(testCaseCompositePart, folderSelectionResult, recordedActions, recordedElements, this.recordDialog.getScriptWrapper(), this.recordDialog.getVariables(), shouldOverride);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_CANNOT_GEN_TEST_STEPS);
                LoggerSingleton.logError((Throwable)e);
            }
        }
        finally {
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
        }
    }

    private Shell getShell(Shell activeShell) {
        String os = Platform.getOS();
        if ("win32".equals(os) || "linux".equals(os)) {
            return null;
        }
        Shell shell = new Shell();
        Rectangle activeShellSize = activeShell.getBounds();
        shell.setLocation((activeShellSize.width - shell.getBounds().width) / 2, (activeShellSize.height - shell.getBounds().height) / 2);
        return shell;
    }

    private TestCaseCompositePart createNewTestCase() throws Exception {
        TestCaseEntity testCase = NewTestCaseHandler.doCreateNewTestCase((ITreeEntity)new FolderTreeEntity(FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject()), null), (IEventBroker)EventBrokerSingleton.getInstance().getEventBroker());
        if (testCase == null) {
            return null;
        }
        return this.getTestCasePartByTestCase(testCase);
    }

    private void doGenerateTestScripts(final TestCaseCompositePart testCaseCompositePart, final SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult, final List<HTMLActionMapping> recordedActions, final List<WebPage> recordedElements, final ScriptNodeWrapper wrapper, final VariableEntity[] variables, final boolean shouldOverride) {
        if (testCaseCompositePart == null) {
            return;
        }
        final TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        if (testCasePart.getTreeTableInput() == null) {
            testCaseCompositePart.loadTreeTableInput();
        }
        Job job = new Job(StringConstants.JOB_GENERATE_SCRIPT_MESSAGE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(StringConstants.JOB_GENERATE_SCRIPT_MESSAGE, recordedActions.size() + recordedElements.size());
                    RecordHandler.this.addRecordedElements(recordedElements, folderSelectionResult, monitor);
                    RecordHandler.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                List children = wrapper.getBlock().getAstChildren();
                                if (children.isEmpty()) {
                                    return;
                                }
                                if (!shouldOverride) {
                                    testCasePart.addDefaultImports();
                                    testCasePart.getTreeTableInput().getMainClassNode().addImport(Keys.class);
                                    testCasePart.addStatements(children, TestCaseTreeTableInput.NodeAddType.Add, true);
                                    testCasePart.addVariables(variables);
                                } else {
                                    testCasePart.clearStatements();
                                    testCasePart.addStatements(children, TestCaseTreeTableInput.NodeAddType.Add, true);
                                    testCasePart.deleteVariables(Arrays.asList(testCasePart.getVariables()));
                                    testCasePart.addVariables(variables);
                                }
                                testCaseCompositePart.refreshScript();
                                testCaseCompositePart.save();
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        }
                    });
                    if (folderSelectionResult != null) {
                        FolderTreeEntity targetFolderTreeEntity = folderSelectionResult.getSelectedParentFolder();
                        RecordHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetFolderTreeEntity.getParent());
                        RecordHandler.this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)targetFolderTreeEntity);
                        RecordHandler.this.eventBroker.send("EXPLORER/EXPAND_TREE_ENTITY", (Object)targetFolderTreeEntity);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    RecordHandler.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_CANNOT_GEN_TEST_STEPS);
                            LoggerSingleton.logError((Throwable)e);
                        }
                    });
                    LoggerSingleton.logError((Throwable)e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private TestCaseCompositePart getSelectedTestCasePart() throws Exception {
        MPartStack composerStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        MPart selectedPart = (MPart)composerStack.getSelectedElement();
        if (selectedPart == null || !selectedPart.getElementId().startsWith("com.kms.katalon.composer.content.testcase") || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        return (TestCaseCompositePart)selectedPart.getObject();
    }

    private TestCaseCompositePart getTestCasePartByTestCase(TestCaseEntity testCase) throws Exception {
        MPart selectedPart = (MPart)this.modelService.find(EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId()), (MUIElement)this.application);
        if (selectedPart == null || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        return (TestCaseCompositePart)selectedPart.getObject();
    }

    private boolean verifyTestCase(TestCaseCompositePart testCaseCompositePart) throws Exception {
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (testCaseCompositePart.getDirty().isDirty()) {
            if (!MessageDialog.openConfirm((Shell)activeShell, (String)StringConstants.WARN, (String)StringConstants.HAND_ERROR_MSG_PLS_SAVE_TEST_CASE)) {
                return false;
            }
            testCaseCompositePart.save();
        }
        try {
            testCaseCompositePart.getAstNodesFromScript();
        }
        catch (CompilationFailedException compilationFailedException) {
            MessageDialog.openWarning((Shell)activeShell, (String)StringConstants.WARN, (String)StringConstants.HAND_ERROR_MSG_PLS_FIX_TEST_CASE);
            return false;
        }
        return true;
    }

    private void addRecordedElements(List<WebPage> recordedElements, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult, IProgressMonitor monitor) throws Exception {
        for (WebPage pageElement : recordedElements) {
            FolderEntity importedFolder = (FolderEntity)folderSelectionResult.getEntitySavedMap().get(pageElement);
            pageElement.setFolderAlias(importedFolder);
            for (WebElement childElement : pageElement.getChildren()) {
                this.addRecordedElement(childElement, importedFolder, folderSelectionResult);
            }
            monitor.worked(1);
        }
    }

    private void addRecordedElement(WebElement element, FolderEntity parentFolder, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult) throws Exception {
        FileEntity entity = folderSelectionResult.getEntitySavedMap().entrySet().stream().filter(e -> {
            WebElement savedElement = (WebElement)e.getKey();
            WebPage savedRoot = savedElement.getRoot();
            if (savedRoot == null) {
                return false;
            }
            WebPage root = element.getRoot();
            return savedElement.getName().equals(element.getName()) && root != null && savedRoot.getName().equals(root.getName());
        }).map(e -> (FileEntity)e.getValue()).findFirst().orElse(null);
        if (entity != null) {
            element.setName(entity.getName());
        }
        if (element instanceof WebFrame) {
            for (WebElement childElement : ((WebFrame)element).getChildren()) {
                this.addRecordedElement(childElement, parentFolder, folderSelectionResult);
            }
        }
    }
}

