/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.dialog.provider;

import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.testcase.model.InputValueEditorProvider;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionParamMapping;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionParamValueType;
import com.kms.katalon.composer.webui.recorder.type.HTMLActionPropertyValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;

public class HTMLActionValueTypeColumnSupport
extends EditingSupport {
    private List<InputValueEditorProvider> availableEditorProviders;
    private HTMLActionPropertyValueType additionalEditorProvider;
    private InputValueEditorProvider assignableType;

    public HTMLActionValueTypeColumnSupport(ColumnViewer viewer, HTMLActionPropertyValueType additionalValueType) {
        super(viewer);
        this.additionalEditorProvider = additionalValueType;
    }

    private HTMLActionParamMapping getParamMapping(Object element) {
        return (HTMLActionParamMapping)element;
    }

    private HTMLActionParamValueType getParamValue(Object element) {
        return this.getParamMapping(element).getActionData();
    }

    protected void setValue(Object element, Object value) {
        InputValueEditorProvider newEditorProvider = this.newEditorProviderFromValueAsIndex(value);
        if (newEditorProvider == null) {
            return;
        }
        HTMLActionParamValueType paramValue = this.getParamValue(element);
        InputValueEditorProvider oldEditorProvider = paramValue.getEditorProvider();
        if (oldEditorProvider != null && newEditorProvider.equals(oldEditorProvider)) {
            return;
        }
        paramValue.setEditorProvider(newEditorProvider);
        paramValue.setValue(newEditorProvider.newValue());
        this.getViewer().refresh();
    }

    private InputValueEditorProvider newEditorProviderFromValueAsIndex(Object value) {
        if (!(value instanceof Integer)) {
            return null;
        }
        int selectionIndex = (Integer)value;
        if (selectionIndex < 0 || selectionIndex > this.availableEditorProviders.size()) {
            return null;
        }
        return this.availableEditorProviders.get(selectionIndex);
    }

    protected CellEditor getCellEditor(Object element) {
        this.collectAvaiableEditorProviders();
        return new ComboBoxCellEditor((Composite)this.getViewer().getControl(), this.getValueTypeNames());
    }

    private void collectAvaiableEditorProviders() {
        this.availableEditorProviders = new ArrayList<InputValueEditorProvider>();
        this.availableEditorProviders.addAll(Arrays.asList(AstInputValueTypeOptionsProvider.getInputValueTypeOptions((String)this.assignableType.getName())));
        this.availableEditorProviders.add((InputValueEditorProvider)InputValueType.Keys);
        if (this.additionalEditorProvider != null) {
            this.availableEditorProviders.add(this.additionalEditorProvider);
        }
    }

    private String[] getValueTypeNames() {
        String[] readableValueTypeNames = new String[this.availableEditorProviders.size()];
        int i = 0;
        while (i < this.availableEditorProviders.size()) {
            readableValueTypeNames[i] = TreeEntityUtil.getReadableKeywordName((String)this.availableEditorProviders.get(i).getName());
            ++i;
        }
        return readableValueTypeNames;
    }

    protected Object getValue(Object element) {
        InputValueEditorProvider paramValueType = this.getParamValue(element).getEditorProvider();
        if (paramValueType == null) {
            return 0;
        }
        int index = 0;
        while (index < this.availableEditorProviders.size()) {
            if (paramValueType.equals(this.availableEditorProviders.get(index))) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    protected boolean canEdit(Object element) {
        if (!(element instanceof HTMLActionParamMapping)) {
            this.assignableType = null;
            return false;
        }
        this.assignableType = AstInputValueTypeOptionsProvider.getAssignableValueType(this.getParamMapping(element).getActionParam().getClazz());
        return this.assignableType != null;
    }
}

