/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.dialog;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.control.Dropdown;
import com.kms.katalon.composer.components.impl.control.DropdownGroup;
import com.kms.katalon.composer.components.impl.control.DropdownItemSelectionListener;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.handler.WorkbenchUtilizer;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.KeyEventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.constants.TreeTableMenuItemConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.decoration.DecoratedKeyword;
import com.kms.katalon.composer.testcase.parts.decoration.KeywordDecorationService;
import com.kms.katalon.composer.testcase.preferences.StoredKeyword;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.TestCaseMenuUtil;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionMapping;
import com.kms.katalon.composer.webui.recorder.ast.RecordedElementMethodCallWrapper;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.composer.webui.recorder.constants.ImageConstants;
import com.kms.katalon.composer.webui.recorder.constants.StringConstants;
import com.kms.katalon.composer.webui.recorder.core.HTMLElementRecorderServer;
import com.kms.katalon.composer.webui.recorder.core.RecordSession;
import com.kms.katalon.composer.webui.recorder.dialog.RecordedLogView;
import com.kms.katalon.composer.webui.recorder.dialog.RecordedStepsView;
import com.kms.katalon.composer.webui.recorder.util.HTMLActionUtil;
import com.kms.katalon.composer.webui.recorder.websocket.RecorderAddonSocket;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.CustomRunConfigurationContributor;
import com.kms.katalon.execution.webservice.RecordingScriptGenerator;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.execution.webui.util.WebUIExecutionUtil;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.dialog.CapturedObjectsView;
import com.kms.katalon.objectspy.dialog.GoToAddonStoreMessageDialog;
import com.kms.katalon.objectspy.dialog.ObjectPropertiesView;
import com.kms.katalon.objectspy.dialog.ObjectRepositoryService;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.dialog.ObjectSpySelectorEditor;
import com.kms.katalon.objectspy.dialog.ObjectVerifyAndHighlightView;
import com.kms.katalon.objectspy.dialog.SaveToObjectRepositoryDialog;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebFrame;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.exception.IEAddonNotInstalledException;
import com.kms.katalon.objectspy.util.BrowserUtil;
import com.kms.katalon.objectspy.util.UtilitiesAddonUtil;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.objectspy.util.Win32Helper;
import com.kms.katalon.objectspy.util.WinRegistry;
import com.kms.katalon.objectspy.websocket.AddonCommand;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.AddonSocketServer;
import com.kms.katalon.objectspy.websocket.messages.AddonMessage;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RecorderDialog
extends AbstractDialog
implements EventHandler,
EventManager<ObjectSpyEvent> {
    private static final String IE_WINDOW_CLASS = "IEFrame";
    private static final String RELATIVE_PATH_TO_IE_ADDON_SETUP = String.valueOf(File.separator) + "extensions" + File.separator + "IE" + File.separator + "Recorder" + File.separator + "setup.exe";
    private static final String RESOURCES_FOLDER_NAME = "resources";
    private static final String IE_ADDON_BHO_KEY = "{FEA8CA38-7979-4F6A-83E4-2949EDEA96EF}";
    public static final String DIA_INSTANT_BROWSER_CHROME_RECORDER_EXTENSION_PATH = "<Katalon build path>/Resources/extensions/Chrome/Recorder Packed";
    public static final String RECORDER_FIREFOX_ADDON_URL = "https://addons.mozilla.org/en-US/firefox/addon/katalon-automation-record/";
    private static final int ANY_PORT_NUMBER = 0;
    private static final int HORIZONTAL_SASH_FORM_WIDTH = 2;
    private static final String RECORD_SESSION_ID;
    private static final String RECORD_TOOL_ITEM_LABEL;
    private static Point MIN_DIALOG_SIZE;
    private HTMLElementRecorderServer server;
    private List<WebPage> elements;
    private List<HTMLActionMapping> recordedActions;
    private boolean isPauseRecording;
    private ToolBar toolBar;
    private ToolItem toolItemBrowserDropdown;
    private ToolItem tltmPauseAndResume;
    private ToolItem tltmStop;
    private RecordSession session;
    private SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult targetFolderSelectionResult;
    private IDriverConnector selectedBrowser;
    private Text txtStartUrl;
    private AddonSocket currentInstantSocket;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private ScopedPreferenceStore store;
    private SashForm hSashForm;
    private boolean disposed;
    private RecordedStepsView recordStepsView;
    private ObjectPropertiesView objectPropertiesView;
    private CapturedObjectsView capturedObjectComposite;
    private CTabFolder bottomTabFolder;
    private int logTabItemIdex;
    private List<? extends ASTNodeWrapper> nodeWrappers;
    private List<VariableEntity> variables;
    private TestCaseEntity testCaseEntity;
    private boolean isOkPressed = false;
    private boolean isUsingIE = false;
    private ToolItem tltmAddStep;
    private ToolItem tltmRemoveStep;
    private ToolItem tltmUp;
    private ToolItem tltmDown;
    private ToolItem tltmRecent;
    private ToolItem tltmPlay;
    private boolean playingState;
    private RecordingScriptGenerator generator;
    private boolean shouldResumeRecordingAfterRunning = false;
    private Menu recentMenu;
    private Map<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>> eventListeners = new HashMap<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>>();

    static {
        RECORD_TOOL_ITEM_LABEL = StringConstants.DIA_TOOLITEM_RECORD;
        MIN_DIALOG_SIZE = new Point(600, 800);
        RECORD_SESSION_ID = UUID.randomUUID().toString();
    }

    public RecorderDialog(Shell parentShell, TestCaseEntity testCaseEntity, List<? extends ASTNodeWrapper> nodeWrappers, List<VariableEntity> variables) {
        super(parentShell);
        this.nodeWrappers = nodeWrappers;
        this.variables = variables;
        this.testCaseEntity = testCaseEntity;
        this.store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.recorder");
        this.elements = new ArrayList<WebPage>();
        this.recordedActions = new ArrayList<HTMLActionMapping>();
        this.isPauseRecording = false;
        this.disposed = false;
        this.setDialogTitle(GlobalMessageConstants.WEB_RECORDER);
        this.registerEventListener();
        this.startSocketServer();
    }

    private void registerEventListener() {
        this.eventBroker.subscribe("RECORDER/HTML_ACTION_CAPTURED", (EventHandler)this);
        this.eventBroker.subscribe("RECORDER/ACTION_OBJECT_REORDERED", (EventHandler)this);
        this.eventBroker.subscribe("WORKSPACE/CLOSE", (EventHandler)this);
        this.eventBroker.subscribe("WEBUI_VERIFICATION/EXECUTION_FINISHED", (EventHandler)this);
        this.eventBroker.subscribe("WEBUI_VERIFICATION/RUN_ALL_STEPS_CMD", (EventHandler)this);
        this.eventBroker.subscribe("WEBUI_VERIFICATION/RUN_SELECTED_STEPS_CMD", (EventHandler)this);
        this.eventBroker.subscribe("WEBUI_VERIFICATION/RUN_FROM_STEP_CMD", (EventHandler)this);
    }

    protected int getShellStyle() {
        boolean onTop = this.store.getBoolean("recorder.pinWindow");
        if (onTop && !"linux".equals(Platform.getOS())) {
            return 16794864;
        }
        return 16778480;
    }

    private void startSocketServer() {
        try {
            new ProgressMonitorDialog(this.getParentShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(ComposerWebuiRecorderMessageConstants.MSG_DLG_INIT_RECORDER, 1);
                    AddonSocketServer.getInstance().start(RecorderAddonSocket.class, UtilitiesAddonUtil.getInstantBrowsersPort());
                }
            });
        }
        catch (InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void startBrowser() {
        this.startBrowser(false);
    }

    private void startBrowser(boolean isInstant) {
        if (!BrowserUtil.isBrowserInstalled((WebUIDriverType)this.getSelectedBrowserType())) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)ComposerWebuiRecorderMessageConstants.DIA_MSG_CANNOT_START_BROWSER);
            return;
        }
        try {
            if (this.getSelectedBrowserType() == WebUIDriverType.IE_DRIVER) {
                this.isUsingIE = true;
                this.checkIEAddon();
            } else {
                this.isUsingIE = false;
            }
            if (isInstant) {
                this.startInstantSession();
                this.invoke(ObjectSpyEvent.ADDON_SESSION_STARTED, this.currentInstantSocket);
            } else {
                this.startServer();
                this.startRecordSession();
                this.invoke(ObjectSpyEvent.SELENIUM_SESSION_STARTED, (Object)this.session);
            }
            if (!this.isPauseRecording) {
                this.recordStepsView.addSimpleKeyword("openBrowser", true);
            }
            this.tltmPauseAndResume.setEnabled(true);
            this.tltmStop.setEnabled(true);
            this.resume();
            this.resetInput();
            Trackings.trackWebRecord((WebUIDriverType)this.getSelectedBrowserType(), (boolean)isInstant, (SelectorMethod)this.getWebLocatorConfig());
        }
        catch (IEAddonNotInstalledException iEAddonNotInstalledException) {
            this.stop();
            this.showMessageForMissingIEAddon();
            try {
                this.getShell().setMinimized(true);
                this.runIEAddonInstaller();
            }
            catch (IOException iOException) {
                LoggerSingleton.logError((Throwable)iOException);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getParentShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
    }

    private void startInstantSession() throws Exception {
        if (this.getSelectedBrowserType() == WebUIDriverType.IE_DRIVER) {
            this.runInstantIE();
        }
        this.currentInstantSocket = AddonSocketServer.getInstance().getAddonSocketByBrowserName(this.getSelectedBrowserType().toString());
        if (this.currentInstantSocket == null) {
            return;
        }
        Win32Helper.switchFocusToBrowser((WebUIDriverType)this.getSelectedBrowserType());
        this.currentInstantSocket.sendMessage(new AddonMessage(AddonCommand.START_RECORD));
    }

    private void closeInstantSession() {
        if (this.currentInstantSocket != null && this.currentInstantSocket.isConnected()) {
            this.currentInstantSocket.close();
        }
    }

    protected void runInstantIE() throws Exception {
        this.session = new RecordSession(this.server, this.selectedBrowser);
        this.session.setupIE();
        WinDef.HWND hwnd = User32.INSTANCE.FindWindow(IE_WINDOW_CLASS, null);
        if (hwnd == null) {
            return;
        }
        this.shiftFocusToWindow(hwnd);
    }

    private void shiftFocusToWindow(WinDef.HWND hwnd) {
        User32.INSTANCE.ShowWindow(hwnd, 9);
        User32.INSTANCE.SetForegroundWindow(hwnd);
    }

    private void checkIEAddon() throws IllegalAccessException, InvocationTargetException, IEAddonNotInstalledException {
        if (this.checkRegistryKey("SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\explorer\\Browser Helper Objects") || this.checkRegistryKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\explorer\\Browser Helper Objects")) {
            return;
        }
        throw new IEAddonNotInstalledException("Recorder");
    }

    private boolean checkRegistryKey(String parentKey) throws IllegalAccessException, InvocationTargetException {
        List bhos = WinRegistry.readStringSubKeys((int)-2147483646, (String)parentKey);
        if (bhos == null || bhos.isEmpty()) {
            return false;
        }
        for (String bho : bhos) {
            if (!bho.toLowerCase().equals(IE_ADDON_BHO_KEY.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void showMessageForMissingIEAddon() {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)RecorderDialog.this.getShell(), (String)StringConstants.INFO, (String)StringConstants.DIALOG_CANNOT_START_IE_MESSAGE);
            }
        });
    }

    private File getResourcesDirectory() throws IOException {
        Bundle bundleExec = Platform.getBundle((String)"com.kms.katalon.composer.webui.recorder");
        File bundleFile = FileLocator.getBundleFile((Bundle)bundleExec);
        if (bundleFile.isDirectory()) {
            return new File(bundleFile + File.separator + RESOURCES_FOLDER_NAME);
        }
        return new File(ClassPathResolver.getConfigurationFolder() + File.separator + RESOURCES_FOLDER_NAME);
    }

    private void runIEAddonInstaller() throws IOException {
        String ieAddonSetupPath = String.valueOf(this.getResourcesDirectory().getAbsolutePath()) + RELATIVE_PATH_TO_IE_ADDON_SETUP;
        Desktop desktop = Desktop.getDesktop();
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        desktop.open(new File(ieAddonSetupPath));
    }

    private void resetInput() {
        this.recordedActions.clear();
    }

    private void startRecordSession() throws Exception {
        this.stopRecordSession();
        this.session = new RecordSession(this.server, this.selectedBrowser, this.txtStartUrl.getText());
        this.session.addBrowserStoppedListener(new RecordSession.BrowserStoppedListener(){

            @Override
            public void onBrowserStopped() {
                UISynchronizeService.syncExec(() -> {
                    if (RecorderDialog.this.getShell() != null && !RecorderDialog.this.getShell().isDisposed() && RecorderDialog.this.session.isRunning()) {
                        RecorderDialog.this.stop();
                    }
                });
            }
        });
        new Thread((Runnable)((Object)this.session)).start();
    }

    private IDriverConnector getDefaultBrowser() {
        try {
            WebUIDriverType browserType = WebUIDriverType.fromStringValue((String)this.getPreferenceStore().getString("recorder.defaultBrowser"));
            return WebUIExecutionUtil.getBrowserDriverConnector((WebUIDriverType)browserType, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getParentShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
            return null;
        }
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.recorder");
    }

    private void startServer(int port) throws Exception {
        this.closeInstantSession();
        if (this.server != null && this.server.isStarted() && this.isCurrentServerPortUsable(port)) {
            return;
        }
        this.stopServer();
        try {
            this.server = new HTMLElementRecorderServer(port, this, RecorderAddonSocket.class);
            this.server.start();
        }
        catch (BindException bindException) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(ComposerWebuiRecorderMessageConstants.ERR_DLG_PORT_FOR_RECORD_IN_USE, port));
            this.server = null;
        }
    }

    private void stopServer() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.server.stop();
        }
    }

    public boolean isCurrentServerPortUsable(int port) {
        return port == 0 || port == this.server.getServerPort();
    }

    private void startServer() throws Exception {
        this.startServer(0);
    }

    private void pause() {
        this.isPauseRecording = true;
        this.tltmPauseAndResume.setToolTipText(ComposerWebuiRecorderMessageConstants.DIA_TOOLTIP_RESUME_RECORDING);
        this.tltmPauseAndResume.setImage(ImageConstants.IMG_24_RESUME_RECORDING);
        this.toolBar.getParent().layout();
    }

    private void resume() {
        this.isPauseRecording = false;
        this.tltmPauseAndResume.setToolTipText(ComposerWebuiRecorderMessageConstants.DIA_TOOLTIP_PAUSE_RECORDING);
        this.tltmPauseAndResume.setImage(ImageConstants.IMG_24_PAUSE_RECORDING);
        this.toolBar.getParent().layout();
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glMain = new GridLayout();
        glMain.marginHeight = 0;
        glMain.marginWidth = 0;
        container.setLayout((Layout)glMain);
        this.createToolbar(container);
        Composite bodyComposite = new Composite(container, 0);
        bodyComposite.setLayout((Layout)new FillLayout(512));
        bodyComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.hSashForm = new SashForm(bodyComposite, 0);
        this.hSashForm.setSashWidth(0);
        Composite leftPanelComposite = new Composite((Composite)this.hSashForm, 0);
        GridLayout glHtmlDomComposite = new GridLayout();
        glHtmlDomComposite.marginBottom = 5;
        glHtmlDomComposite.marginRight = 0;
        glHtmlDomComposite.marginWidth = 0;
        glHtmlDomComposite.marginHeight = 0;
        glHtmlDomComposite.horizontalSpacing = 0;
        leftPanelComposite.setLayout((Layout)glHtmlDomComposite);
        this.createStepsPanel(leftPanelComposite);
        Composite rightPanelComposite = new Composite((Composite)this.hSashForm, 0);
        GridLayout glObjectComposite = new GridLayout();
        glObjectComposite.marginLeft = 5;
        glObjectComposite.marginWidth = 0;
        glObjectComposite.marginBottom = 0;
        glObjectComposite.marginHeight = 0;
        glObjectComposite.verticalSpacing = 0;
        glObjectComposite.horizontalSpacing = 0;
        rightPanelComposite.setLayout((Layout)glObjectComposite);
        this.createObjectsPanel(rightPanelComposite);
        int[] nArray = new int[2];
        nArray[0] = 10;
        this.hSashForm.setWeights(nArray);
        this.txtStartUrl.setFocus();
        this.initializeInput();
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private void initializeInput() {
        this.txtStartUrl.setText(this.store.getString("recorder.defaultURL"));
        this.txtStartUrl.selectAll();
        this.getTreeTableInput().refresh();
    }

    private void createObjectsPanel(Composite parent) {
        this.capturedObjectComposite = new CapturedObjectsView(parent, 0, this.eventBroker);
        Sash sash = new Sash(parent, 256);
        GridData layoutData = new GridData(4, 128, true, false);
        sash.setLayoutData((Object)layoutData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int CAPTURED_OBJECT_VIEW_MIN_SIZE = 100;

            public void widgetSelected(SelectionEvent e) {
                GridLayout parentLayout = (GridLayout)RecorderDialog.this.capturedObjectComposite.getParent().getLayout();
                int newHeight = e.y - ((RecorderDialog)RecorderDialog.this).capturedObjectComposite.getBounds().y - parentLayout.verticalSpacing;
                if (newHeight < this.CAPTURED_OBJECT_VIEW_MIN_SIZE) {
                    e.doit = false;
                    return;
                }
                GridData gridData = (GridData)RecorderDialog.this.capturedObjectComposite.getLayoutData();
                gridData.heightHint = newHeight;
                RecorderDialog.this.capturedObjectComposite.getParent().layout();
            }
        });
        this.objectPropertiesView = new ObjectPropertiesView(parent, 0);
        this.objectPropertiesView.setRefreshCapturedObjectsTree(() -> this.capturedObjectComposite.refreshTree(null));
        ObjectSpySelectorEditor selectorEditor = new ObjectSpySelectorEditor();
        selectorEditor.createObjectSelectorEditor(parent);
        ObjectVerifyAndHighlightView verifyView = new ObjectVerifyAndHighlightView();
        verifyView.createVerifyAndHighlightView(parent, 768);
        this.capturedObjectComposite.addListener((EventListener)this.objectPropertiesView, Arrays.asList(ObjectSpyEvent.SELECTED_ELEMENT_CHANGED));
        selectorEditor.addListener((EventListener)verifyView, Arrays.asList(ObjectSpyEvent.SELECTOR_HAS_CHANGED));
        this.objectPropertiesView.addListener((EventListener)selectorEditor, Arrays.asList(ObjectSpyEvent.ELEMENT_PROPERTIES_CHANGED));
        this.objectPropertiesView.addListener((EventListener)verifyView, Arrays.asList(ObjectSpyEvent.ELEMENT_PROPERTIES_CHANGED));
        this.addListener((EventListener<ObjectSpyEvent>)verifyView, Arrays.asList(ObjectSpyEvent.ADDON_SESSION_STARTED, ObjectSpyEvent.SELENIUM_SESSION_STARTED));
        this.addListener(this.recordStepsView, Arrays.asList(ObjectSpyEvent.ADDON_SESSION_STARTED, ObjectSpyEvent.SELENIUM_SESSION_STARTED));
        this.objectPropertiesView.addListener((EventListener)this.recordStepsView, Arrays.asList(ObjectSpyEvent.ELEMENT_NAME_CHANGED));
        this.recordStepsView.setCapturedObjectsView(this.capturedObjectComposite);
    }

    private void createActionToolbar(Composite parent) {
        ToolBar rightToolBar = new ToolBar(parent, 0x820000);
        rightToolBar.setLayoutData((Object)new GridData(131072, 128, true, false, 1, 1));
        final ToolItem tltmCapturedObjects = new ToolItem(rightToolBar, 8);
        tltmCapturedObjects.setText(String.valueOf(StringConstants.DIA_TITLE_SHOW) + StringConstants.DIA_TITLE_CAPTURED_OBJECTS + " >>");
        tltmCapturedObjects.setToolTipText(StringConstants.DIA_TOOLTIP_SHOW_HIDE_CAPTURED_OBJECTS);
        tltmCapturedObjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int sashWidth;
                int[] sashFormWeights;
                int widthDiff;
                String showOrHide = String.valueOf(StringConstants.DIA_TITLE_SHOW) + StringConstants.DIA_TITLE_CAPTURED_OBJECTS + " >>";
                Point currentSize = RecorderDialog.this.hSashForm.getSize();
                Point shellSize = RecorderDialog.this.getShell().getSize();
                if (tltmCapturedObjects.getText().contains(StringConstants.DIA_TITLE_SHOW)) {
                    widthDiff = currentSize.x * 100 / 60 + 2 - currentSize.x;
                    sashFormWeights = new int[]{60, 40};
                    showOrHide = "<< " + StringConstants.DIA_TITLE_HIDE + StringConstants.DIA_TITLE_CAPTURED_OBJECTS;
                    sashWidth = 2;
                } else {
                    widthDiff = (currentSize.x - 2) * 60 / 100 - currentSize.x;
                    int[] nArray = new int[2];
                    nArray[0] = 10;
                    sashFormWeights = nArray;
                    sashWidth = 0;
                }
                tltmCapturedObjects.setText(showOrHide);
                RecorderDialog.this.hSashForm.setWeights(sashFormWeights);
                RecorderDialog.this.hSashForm.setSashWidth(sashWidth);
                RecorderDialog.this.getShell().setSize(shellSize.x + widthDiff, shellSize.y);
                tltmCapturedObjects.getParent().layout(true);
            }
        });
    }

    private void createStepsPanel(Composite parent) {
        Composite labelComposite = new Composite(parent, 0);
        GridLayout glLabelComposite = new GridLayout(2, false);
        glLabelComposite.marginWidth = 0;
        glLabelComposite.marginHeight = 0;
        labelComposite.setLayout((Layout)glLabelComposite);
        Label lblRecordedActions = new Label(labelComposite, 0);
        lblRecordedActions.setFont(this.getFontBold(lblRecordedActions));
        lblRecordedActions.setText(StringConstants.DIA_LBL_RECORED_ACTIONS);
        labelComposite.setLayoutData((Object)new GridData(768));
        this.createActionToolbar(labelComposite);
        SashForm compositeSteps = new SashForm(parent, 512);
        compositeSteps.setLayoutData((Object)new GridData(1808));
        Composite compositeStepsTab = new Composite((Composite)compositeSteps, 0);
        compositeStepsTab.setLayoutData((Object)new GridData(1808));
        GridLayout glStepsTab = new GridLayout(1, false);
        glStepsTab.marginWidth = 0;
        glStepsTab.marginHeight = 0;
        glStepsTab.marginBottom = 0;
        compositeStepsTab.setLayout((Layout)glStepsTab);
        this.createStepButtons(compositeStepsTab);
        Composite tableComposite = new Composite(compositeStepsTab, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.recordStepsView = new RecordedStepsView();
        this.recordStepsView.createContent(tableComposite);
        this.bottomTabFolder = new CTabFolder((Composite)compositeSteps, 0);
        CTabItem variablesTabItem = new CTabItem(this.bottomTabFolder, 0);
        variablesTabItem.setText("Variables");
        Composite variablesViewComposite = this.recordStepsView.createVariableTab((Composite)this.bottomTabFolder);
        variablesViewComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        variablesTabItem.setControl((Control)variablesViewComposite);
        CTabItem logTabItem = new CTabItem(this.bottomTabFolder, 0);
        logTabItem.setText("Logs");
        RecordedLogView logsView = new RecordedLogView();
        Composite logsViewComposite = logsView.createLogsView((Composite)this.bottomTabFolder);
        logTabItem.setControl((Control)logsViewComposite);
        this.bottomTabFolder.setSelection(variablesTabItem);
        this.logTabItemIdex = this.bottomTabFolder.indexOf(logTabItem);
        compositeSteps.setWeights(new int[]{60, 40});
        IStylingEngine styleEngine = (IStylingEngine)WorkbenchUtilizer.getService(IStylingEngine.class);
        styleEngine.setId((Object)compositeSteps, "DefaultCTabFolder");
    }

    private void createStepButtons(Composite compositeSteps) {
        Composite compositeToolbars = new Composite(compositeSteps, 0);
        compositeToolbars.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        compositeToolbars.setLayout((Layout)layout);
        ToolBar toolbar = new ToolBar(compositeToolbars, 0x820000);
        toolbar.setLayoutData((Object)new GridData(768));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object item = e.getSource();
                if (item instanceof ToolItem) {
                    RecorderDialog.this.performToolItemSelected((ToolItem)e.getSource(), e);
                    return;
                }
                if (item instanceof MenuItem) {
                    RecorderDialog.this.performMenuItemSelected((MenuItem)e.getSource());
                }
            }
        };
        this.tltmAddStep = new ToolItem(toolbar, 4);
        this.tltmAddStep.setText(StringConstants.ADD);
        this.tltmAddStep.setImage(ImageConstants.IMG_16_ADD);
        this.tltmAddStep.addSelectionListener((SelectionListener)selectionListener);
        Menu addMenu = new Menu((Control)this.tltmAddStep.getParent().getShell());
        this.tltmAddStep.setData((Object)addMenu);
        TestCaseMenuUtil.fillActionMenu((TreeTableMenuItemConstants.AddAction)TreeTableMenuItemConstants.AddAction.Add, (SelectionListener)selectionListener, (Menu)addMenu, (int[])new int[]{72, TreeTableMenuItemConstants.getBuildInKeywordID((String)"Mobile"), TreeTableMenuItemConstants.getBuildInKeywordID((String)"WS")});
        this.tltmRecent = new ToolItem(toolbar, 4);
        this.tltmRecent.setText(ComposerTestcaseMessageConstants.PA_BTN_TIP_RECENT);
        this.tltmRecent.setImage(ImageConstants.IMG_16_RECENT);
        this.tltmRecent.addSelectionListener((SelectionListener)selectionListener);
        this.setRecentKeywordItemState();
        this.tltmRemoveStep = new ToolItem(toolbar, 0);
        this.tltmRemoveStep.setText(StringConstants.REMOVE);
        this.tltmRemoveStep.setImage(ImageConstants.IMG_16_DELETE);
        this.tltmRemoveStep.addSelectionListener((SelectionListener)selectionListener);
        this.tltmUp = new ToolItem(toolbar, 0);
        this.tltmUp.setText(StringConstants.DIA_ITEM_MOVE_UP);
        this.tltmUp.setImage(ImageConstants.IMG_16_MOVE_UP);
        this.tltmUp.addSelectionListener((SelectionListener)selectionListener);
        this.tltmDown = new ToolItem(toolbar, 0);
        this.tltmDown.setText(StringConstants.DIA_ITEM_MOVE_DOWN);
        this.tltmDown.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        this.tltmDown.addSelectionListener((SelectionListener)selectionListener);
        new HelpCompositeForDialog(compositeToolbars, DocumentationMessageConstants.RECORDER_RUN_STEPS){

            protected GridData createGridData() {
                GridData gridData = new GridData(131072, 0x1000000, true, true);
                gridData.widthHint = 32;
                return gridData;
            }

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginBottom = 0;
                layout.marginWidth = 0;
                return layout;
            }
        };
        ToolBar playToolbar = new ToolBar(compositeToolbars, 0x820000);
        GridLayout glPlayToolbar = new GridLayout(1, false);
        glPlayToolbar.marginWidth = 0;
        playToolbar.setLayout((Layout)glPlayToolbar);
        playToolbar.setLayoutData((Object)new GridData(128));
        this.tltmPlay = new ToolItem(playToolbar, 4);
        this.tltmPlay.setImage(ImageConstants.IMG_24_PLAY);
        this.tltmPlay.addSelectionListener((SelectionListener)selectionListener);
        this.tltmPlay.setToolTipText(ComposerWebuiRecorderMessageConstants.DIA_ITEM_RUN_ALL_STEPS);
        this.setPlayButtonState(false);
    }

    private void createRunScripContextMenu() {
        if (this.tltmPlay.getData() instanceof Menu) {
            ((Menu)this.tltmPlay.getData()).dispose();
        }
        Rectangle rect = this.tltmPlay.getBounds();
        ToolBar playToolbar = this.tltmPlay.getParent();
        Point pt = playToolbar.toDisplay(new Point(rect.x + rect.width, rect.y));
        Menu playMenu = new Menu((Control)playToolbar);
        playMenu.setLocation(pt.x, pt.y + rect.height);
        playMenu.setVisible(true);
        playToolbar.setMenu(playMenu);
        this.tltmPlay.setData((Object)playMenu);
        MenuItem runAllStepsItem = new MenuItem(playMenu, 32);
        runAllStepsItem.setText(ControlUtils.createMenuItemText((String)ComposerWebuiRecorderMessageConstants.DIA_ITEM_RUN_ALL_STEPS, (String)KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "E"})));
        runAllStepsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecorderDialog.this.runAllSteps();
            }
        });
        runAllStepsItem.setSelection(true);
        MenuItem runSelectedSteps = new MenuItem(playMenu, 8);
        runSelectedSteps.setText(ControlUtils.createMenuItemText((String)ComposerWebuiRecorderMessageConstants.DIA_ITEM_RUN_SELECTED_STEPS, (String)KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "ALT", "E"})));
        runSelectedSteps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecorderDialog.this.runSelectedSteps();
            }
        });
        if (this.recordStepsView.getTreeTable().getStructuredSelection().isEmpty()) {
            runSelectedSteps.setEnabled(false);
        }
        MenuItem runFromSelectedStep = new MenuItem(playMenu, 8);
        runFromSelectedStep.setText(ControlUtils.createMenuItemText((String)ComposerWebuiRecorderMessageConstants.DIA_ITEM_RUN_FROM_SELECTED_STEP, (String)KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "SHIFT", "E"})));
        runFromSelectedStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecorderDialog.this.runFromStep();
            }
        });
        if (this.recordStepsView.getTreeTable().getStructuredSelection().isEmpty()) {
            runFromSelectedStep.setEnabled(false);
        }
    }

    private void runFromStep() {
        ScriptNodeWrapper cloneScript = this.recordStepsView.getWrapper().clone();
        cloneScript.setMainBlock(cloneScript.getBlock().clone());
        BlockStatementWrapper block = cloneScript.getBlock();
        block.clearStaments();
        for (ASTNodeWrapper node : this.recordStepsView.getTreeTableInput().getNodeWrappersFromFirstSelected()) {
            block.addChild(node.clone());
        }
        Trackings.trackRecordRunSteps((String)"from");
        this.executeSelectedSteps(cloneScript);
    }

    private void runAllSteps() {
        Trackings.trackRecordRunSteps((String)"all");
        this.executeSelectedSteps(this.recordStepsView.getWrapper());
    }

    private void runSelectedSteps() {
        ScriptNodeWrapper cloneScript = this.recordStepsView.getWrapper().clone();
        cloneScript.setMainBlock(cloneScript.getBlock().clone());
        BlockStatementWrapper block = cloneScript.getBlock();
        block.clearStaments();
        for (ASTNodeWrapper node : this.recordStepsView.getTreeTableInput().getSelectedNodeWrappers()) {
            block.addChild(node.clone());
        }
        Trackings.trackRecordRunSteps((String)"selected");
        this.executeSelectedSteps(cloneScript);
    }

    public void setPlayButtonState(boolean sendingState) {
        this.playingState = sendingState;
        if (this.playingState) {
            this.tltmPlay.setText(StringConstants.STOP);
            this.tltmPlay.setImage(ImageConstants.IMG_24_STOP);
        } else {
            this.tltmPlay.setImage(ImageConstants.IMG_24_PLAY);
            this.tltmPlay.setText(StringConstants.RUN);
        }
        this.tltmPlay.getParent().getParent().layout(true, true);
    }

    public boolean getSendingState() {
        return this.playingState;
    }

    private void setRecentKeywordItemState() {
        this.tltmRecent.setEnabled(!TestCasePreferenceDefaultValueInitializer.getRecentKeywords().isEmpty());
    }

    public void performToolItemSelected(ToolItem toolItem, SelectionEvent selectionEvent) {
        this.getTreeTable().applyEditorValue();
        if (toolItem.equals(this.tltmAddStep)) {
            this.openToolItemForAddMenu(toolItem, selectionEvent);
            return;
        }
        if (toolItem.equals(this.tltmRemoveStep)) {
            this.getTreeTableInput().removeSelectedRows();
            return;
        }
        if (toolItem.equals(this.tltmUp)) {
            this.getTreeTableInput().moveUp();
            return;
        }
        if (toolItem.equals(this.tltmDown)) {
            this.getTreeTableInput().moveDown();
            return;
        }
        if (toolItem.equals(this.tltmRecent)) {
            this.openRecentKeywordItems();
            return;
        }
        if (toolItem.equals(this.tltmPlay)) {
            this.openToolItemForRunMenu(toolItem, selectionEvent);
            return;
        }
    }

    private void executeSelectedSteps(final ScriptNodeWrapper nodeWrapper) {
        if (this.playingState) {
            if (this.generator != null) {
                this.generator.stopLauncher();
            }
            this.setPlayButtonState(false);
            if (this.shouldResumeRecordingAfterRunning) {
                this.resume();
                this.shouldResumeRecordingAfterRunning = false;
            }
            return;
        }
        this.shouldResumeRecordingAfterRunning = !this.isPauseRecording;
        this.pause();
        this.setPlayButtonState(true);
        if (this.session == null || this.session.getWebDriver() == null || !this.session.isRunning()) {
            this.startBrowser();
        }
        Job job = new Job(ComposerWebuiRecorderMessageConstants.JOB_RUNNING_RECORDED_STEPS){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    while (RecorderDialog.this.session == null || RecorderDialog.this.session.getWebDriver() == null || !RecorderDialog.this.session.isRunning()) {
                        Thread.sleep(200L);
                    }
                    UISynchronizeService.syncExec(() -> {
                        RecorderDialog.this.pause();
                        RecorderDialog.this.bottomTabFolder.setSelection(RecorderDialog.this.logTabItemIdex);
                    });
                    File recordSessionFolder = new File(ProjectController.getInstance().getTempDir(), "record/" + RECORD_SESSION_ID);
                    recordSessionFolder.mkdirs();
                    File capturedObjectsFile = new File(recordSessionFolder, "captured_objects.json");
                    HashMap<String, TestObject> capturedObjectsCache = new HashMap<String, TestObject>();
                    for (WebElement we : RecorderDialog.this.capturedObjectComposite.flattenWebElements()) {
                        capturedObjectsCache.put(we.getScriptId(), WebElementUtils.buildTestObject((WebElement)we));
                    }
                    FileUtils.write((File)capturedObjectsFile, (CharSequence)JsonUtil.toJson(capturedObjectsCache));
                    RecorderDialog.this.generator = new RecordingScriptGenerator(capturedObjectsFile.getAbsolutePath());
                    StringBuilder stringBuilder = new StringBuilder();
                    new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(nodeWrapper);
                    RecorderDialog.this.generator.execute(stringBuilder.toString(), Arrays.asList(RecorderDialog.this.recordStepsView.getVariables()), RecorderDialog.this.session.getWebDriver(), RecorderDialog.this.session.getWebUiDriverType(), ProjectController.getInstance().getCurrentProject());
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    UISynchronizeService.syncExec(() -> RecorderDialog.this.setPlayButtonState(false));
                    if (RecorderDialog.this.shouldResumeRecordingAfterRunning) {
                        RecorderDialog.this.resume();
                        RecorderDialog.this.shouldResumeRecordingAfterRunning = false;
                    }
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }

    private void openRecentKeywordItems() {
        List recentKeywords = TestCasePreferenceDefaultValueInitializer.getRecentKeywords();
        if (recentKeywords.isEmpty()) {
            return;
        }
        if (this.recentMenu != null && !this.recentMenu.isDisposed()) {
            this.recentMenu.dispose();
        }
        this.recentMenu = new Menu((Control)this.tltmRecent.getParent());
        recentKeywords.forEach(keyword -> this.addRecentMenuItem((StoredKeyword)keyword));
        Rectangle rect = this.tltmRecent.getBounds();
        Point pt = this.tltmRecent.getParent().toDisplay(new Point(rect.x, rect.y));
        this.recentMenu.setLocation(pt.x, pt.y + rect.height);
        this.recentMenu.setVisible(true);
    }

    private void addRecentMenuItem(StoredKeyword keyword) {
        MenuItem recentMenuItem = new MenuItem(this.recentMenu, 8);
        final DecoratedKeyword decoratedKeyword = KeywordDecorationService.getDecoratedKeyword((StoredKeyword)keyword);
        recentMenuItem.setText(decoratedKeyword.getLabel());
        recentMenuItem.setToolTipText(decoratedKeyword.getTooltip());
        recentMenuItem.setImage(decoratedKeyword.getImage());
        recentMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseTreeTableInput treeTableInput = RecorderDialog.this.recordStepsView.getTreeTableInput();
                AstTreeTableNode destination = treeTableInput.getSelectedNode();
                treeTableInput.addNewAstObject((ASTNodeWrapper)decoratedKeyword.newStep(treeTableInput.getParentNodeForNewMethodCall(destination)), destination, TestCaseTreeTableInput.NodeAddType.Add);
            }
        });
    }

    public void performMenuItemSelected(MenuItem menuItem) {
        this.getTreeTable().applyEditorValue();
        TestCaseTreeTableInput.NodeAddType addType = TestCaseTreeTableInput.NodeAddType.Add;
        Object value = menuItem.getData("ACTION");
        if (value instanceof TreeTableMenuItemConstants.AddAction) {
            switch ((TreeTableMenuItemConstants.AddAction)value) {
                case Add: {
                    addType = TestCaseTreeTableInput.NodeAddType.Add;
                    break;
                }
                case InsertAfter: {
                    addType = TestCaseTreeTableInput.NodeAddType.InserAfter;
                    break;
                }
                case InsertBefore: {
                    addType = TestCaseTreeTableInput.NodeAddType.InserBefore;
                }
            }
        }
        switch (menuItem.getID()) {
            case 128: {
                Object failureHandlingValue = menuItem.getData("FAILURE_HANDLING_KEY");
                if (!(failureHandlingValue instanceof FailureHandling)) break;
                this.getTreeTableInput().changeFailureHandling((FailureHandling)failureHandlingValue);
                break;
            }
            case 64: {
                this.getTreeTableInput().copy(this.getTreeTableInput().getSelectedNodes());
                break;
            }
            case 65: {
                this.getTreeTableInput().cut(this.getTreeTableInput().getSelectedNodes());
                break;
            }
            case 66: {
                this.getTreeTableInput().paste(this.getTreeTableInput().getSelectedNode(), addType);
                break;
            }
            case 67: {
                this.getTreeTableInput().removeSelectedRows();
                break;
            }
            case 69: {
                this.getTreeTableInput().enable();
                break;
            }
            case 68: {
                this.getTreeTableInput().disable();
                break;
            }
            default: {
                this.getTreeTableInput().addNewAstObject(menuItem.getID(), this.getTreeTableInput().getSelectedNode(), addType);
            }
        }
    }

    private TestCaseTreeTableInput getTreeTableInput() {
        return this.recordStepsView.getTreeTableInput();
    }

    private void openToolItemForAddMenu(ToolItem toolItem, SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 4 && toolItem.getData() instanceof Menu) {
            Rectangle rect = toolItem.getBounds();
            Point pt = toolItem.getParent().toDisplay(new Point(rect.x, rect.y));
            Menu menu = (Menu)toolItem.getData();
            menu.setLocation(pt.x, pt.y + rect.height);
            menu.setVisible(true);
        } else {
            this.recordStepsView.getTreeTableInput().addNewDefaultBuiltInKeyword(TestCaseTreeTableInput.NodeAddType.Add);
        }
    }

    private void openToolItemForRunMenu(ToolItem toolItem, SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 4) {
            this.createRunScripContextMenu();
        } else {
            this.executeSelectedSteps(this.recordStepsView.getWrapper());
        }
    }

    private ColumnViewer getTreeTable() {
        return this.recordStepsView.getTreeTable();
    }

    private void createToolbar(Composite parent) {
        Composite toolbarComposite = new Composite(parent, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(3, false));
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblStartUrl = new Label(toolbarComposite, 0);
        lblStartUrl.setText(ObjectspyMessageConstants.LBL_DLG_START_URL);
        this.txtStartUrl = new Text(toolbarComposite, 2048);
        GridData gdTxtStartUrl = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtStartUrl.heightHint = 20;
        gdTxtStartUrl.widthHint = 300;
        this.txtStartUrl.setLayoutData((Object)gdTxtStartUrl);
        this.txtStartUrl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    RecorderDialog.this.startBrowser();
                }
            }
        });
        this.selectedBrowser = this.getDefaultBrowser();
        this.toolBar = new ToolBar(toolbarComposite, 0x820000);
        this.toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.toolItemBrowserDropdown = new ToolItem(this.toolBar, 4);
        this.toolItemBrowserDropdown.setToolTipText(ComposerWebuiRecorderMessageConstants.DIA_TOOLTIP_START_RECORDING);
        this.toolItemBrowserDropdown.setImage(this.getWebUIDriverToolItemImage(this.getSelectedBrowserType()));
        Dropdown dropdown = new Dropdown(this.getShell());
        this.createDropdownContent(dropdown);
        this.toolItemBrowserDropdown.addSelectionListener((SelectionListener)new DropdownItemSelectionListener(dropdown){

            public void itemSelected(SelectionEvent event) {
                ToolItem item = (ToolItem)event.widget;
                if (item.getText().equals(StringConstants.ACTIVE_BROWSER_PREFIX)) {
                    RecorderDialog.this.startBrowser(true);
                    return;
                }
                RecorderDialog.this.startBrowser();
            }
        });
        this.tltmPauseAndResume = new ToolItem(this.toolBar, 8);
        this.tltmPauseAndResume.setToolTipText(ComposerWebuiRecorderMessageConstants.DIA_TOOLTIP_PAUSE_RECORDING);
        this.tltmPauseAndResume.setImage(ImageConstants.IMG_24_PAUSE_RECORDING);
        this.tltmPauseAndResume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RecorderDialog.this.isPauseRecording) {
                    RecorderDialog.this.resume();
                } else {
                    RecorderDialog.this.pause();
                }
            }
        });
        this.tltmPauseAndResume.setEnabled(false);
        this.tltmStop = new ToolItem(this.toolBar, 8);
        this.tltmStop.setImage(ImageConstants.IMG_24_STOP_RECORDING);
        this.tltmStop.setToolTipText(ComposerWebuiRecorderMessageConstants.DIA_TOOLTIP_STOP_RECORDING);
        this.tltmStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RecorderDialog.this.stop();
            }
        });
        this.tltmStop.setEnabled(false);
    }

    private void createDropdownContent(Dropdown dropdown) {
        DropdownGroup newBrowser = dropdown.addDropdownGroupItem(StringConstants.MENU_ITEM_NEW_BROWSERS, ImageManager.getImage((String)"execution/new_browser_16.png"));
        this.addNewBrowserItem(newBrowser, WebUIDriverType.FIREFOX_DRIVER);
        this.addNewBrowserItem(newBrowser, WebUIDriverType.CHROME_DRIVER);
        DropdownGroup activeBrowser = dropdown.addDropdownGroupItem(StringConstants.MENU_ITEM_ACTIVE_BROWSERS, ImageManager.getImage((String)"execution/active_browser_16.png"));
        this.addActiveBrowserItem(activeBrowser, WebUIDriverType.CHROME_DRIVER);
        this.addActiveBrowserItem(activeBrowser, WebUIDriverType.FIREFOX_DRIVER);
        DropdownGroup customCapabilities = dropdown.addDropdownGroupItem(StringConstants.MENU_ITEM_CUSTOM_BROWSERS, null);
        this.addCustomCapabilitiesItem(customCapabilities);
        if ("win32".equals(Platform.getOS())) {
            this.addNewBrowserItem(newBrowser, WebUIDriverType.IE_DRIVER);
        }
    }

    private void addCustomCapabilitiesItem(DropdownGroup customCapabilities) {
        boolean isAdded = false;
        CustomRunConfigurationContributor[] customRunConfigurationContributorArray = RunConfigurationCollector.getInstance().getAllCustomRunConfigurationContributors();
        int n = customRunConfigurationContributorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRunConfigurationContributor customRunConfigContributor = customRunConfigurationContributorArray[n2];
            final IDriverConnector driverConnector = this.getBrowser(customRunConfigContributor);
            customCapabilities.addItem(customRunConfigContributor.getId(), null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (driverConnector != null) {
                        RecorderDialog.this.changeBrowser(driverConnector);
                        RecorderDialog.this.startBrowser();
                    }
                }
            });
            isAdded = true;
            ++n2;
        }
        if (!isAdded) {
            customCapabilities.addItem("Empty", null, (SelectionListener)new SelectionAdapter(){});
        }
    }

    private IDriverConnector getBrowser(CustomRunConfigurationContributor customRunConfigContributor) {
        AbstractRunConfiguration runConfiguration = null;
        try {
            runConfiguration = (AbstractRunConfiguration)customRunConfigContributor.getRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return Optional.ofNullable(runConfiguration).map(IRunConfiguration::getDriverConnectors).map(driverConnectors -> (IDriverConnector)driverConnectors.get("WebUI")).orElse(null);
    }

    private void addNewBrowserItem(DropdownGroup newBrowserGroup, final WebUIDriverType webUIDriverType) {
        String itemText = webUIDriverType == WebUIDriverType.CHROME_DRIVER ? String.valueOf(webUIDriverType.toString()) + StringConstants.RECOMMENDED_BROWSER_POSTFIX : webUIDriverType.toString();
        newBrowserGroup.addItem(itemText, this.getWebUIDriverDropdownImage(webUIDriverType), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecorderDialog.this.changeBrowser(webUIDriverType);
                RecorderDialog.this.startBrowser();
            }
        });
    }

    private void addActiveBrowserItem(DropdownGroup activeBrowserGroup, final WebUIDriverType webUIDriverType) {
        activeBrowserGroup.addItem(webUIDriverType.toString(), this.getWebUIDriverDropdownImage(webUIDriverType), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (webUIDriverType != WebUIDriverType.IE_DRIVER && !UtilitiesAddonUtil.isNotShowingInstantBrowserDialog() && !this.showInstantBrowserDialog()) {
                        return;
                    }
                    RecorderDialog.this.changeBrowser(webUIDriverType, true);
                    RecorderDialog.this.startBrowser(true);
                }
                catch (IOException | URISyntaxException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            protected void showMessageForStartingInstantIE() {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openInformation((Shell)RecorderDialog.this.getShell(), (String)StringConstants.HAND_ACTIVE_BROWSERS_DIA_TITLE, (String)StringConstants.DIALOG_RUNNING_INSTANT_IE_MESSAGE, (String)StringConstants.HAND_ACTIVE_BROWSERS_DIA_TOOGLE_MESSAGE, (boolean)false, null, null);
                        UtilitiesAddonUtil.setNotShowingInstantBrowserDialog((boolean)messageDialogWithToggle.getToggleState());
                    }
                });
            }

            private boolean showInstantBrowserDialog() throws IOException, URISyntaxException {
                if (webUIDriverType == WebUIDriverType.IE_DRIVER) {
                    this.showMessageForStartingInstantIE();
                    return true;
                }
                GoToAddonStoreMessageDialog messageDialogWithToggle = new GoToAddonStoreMessageDialog(RecorderDialog.this.getShell(), StringConstants.HAND_ACTIVE_BROWSERS_DIA_TITLE, MessageFormat.format(StringConstants.HAND_ACTIVE_BROWSERS_DIA_MESSAGE, webUIDriverType.toString()), StringConstants.HAND_ACTIVE_BROWSERS_DIA_TOOGLE_MESSAGE){

                    protected String getNoButtonLabel() {
                        return ComposerWebuiRecorderMessageConstants.LBL_DLG_CONTINUE_WITH_RECORDING;
                    }
                };
                int returnCode = messageDialogWithToggle.open();
                UtilitiesAddonUtil.setNotShowingInstantBrowserDialog((boolean)messageDialogWithToggle.getToggleState());
                if (returnCode == 3) {
                    return true;
                }
                if (returnCode != 2) {
                    return false;
                }
                this.openBrowserToAddonUrl();
                return true;
            }

            private void openBrowserToAddonUrl() throws IOException, URISyntaxException {
                String url = this.getAddonUrl(webUIDriverType);
                if (StringUtils.isEmpty((String)url)) {
                    return;
                }
                Program.launch((String)url);
            }

            private String getAddonUrl(WebUIDriverType webUIDriverType2) {
                if (webUIDriverType2 == WebUIDriverType.CHROME_DRIVER) {
                    return "https://chrome.google.com/webstore/detail/katalon-utilities/ljdobmomdgdljniojadhoplhkpialdid";
                }
                if (webUIDriverType2 == WebUIDriverType.FIREFOX_DRIVER) {
                    return RecorderDialog.RECORDER_FIREFOX_ADDON_URL;
                }
                return null;
            }
        });
    }

    public void stop() {
        try {
            if (!this.isPauseRecording) {
                this.recordStepsView.addSimpleKeyword("closeBrowser", false);
            }
            this.stopServer();
            this.stopRecordSession();
            this.closeInstantSession();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getParentShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        this.resume();
        this.tltmPauseAndResume.setEnabled(false);
        this.tltmStop.setEnabled(false);
    }

    private void changeBrowser(WebUIDriverType browserType) {
        this.changeBrowser(browserType, false);
    }

    private void changeBrowser(WebUIDriverType browserType, boolean isInstant) {
        try {
            IDriverConnector driverConnector = WebUIExecutionUtil.getBrowserDriverConnector((WebUIDriverType)browserType, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
            this.changeBrowser(driverConnector, isInstant);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getParentShell(), (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
    }

    private void changeBrowser(IDriverConnector driverConnector) {
        this.changeBrowser(driverConnector, false);
    }

    private void changeBrowser(IDriverConnector driverConnector, final boolean isInstant) {
        if (driverConnector == null) {
            return;
        }
        this.selectedBrowser = driverConnector;
        UISynchronizeService.getInstance().getSync().asyncExec(new Runnable(){

            @Override
            public void run() {
                String label = RECORD_TOOL_ITEM_LABEL;
                if (isInstant) {
                    label = StringConstants.ACTIVE_BROWSER_PREFIX;
                }
                RecorderDialog.this.toolItemBrowserDropdown.setText(label);
                RecorderDialog.this.toolItemBrowserDropdown.setImage(RecorderDialog.this.getWebUIDriverToolItemImage(RecorderDialog.this.getSelectedBrowserType()));
                RecorderDialog.this.toolItemBrowserDropdown.getParent().getParent().layout(true, true);
            }
        });
    }

    private Font getFontBold(Label label) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        return boldDescriptor.createFont((Device)label.getDisplay());
    }

    private Image getWebUIDriverDropdownImage(WebUIDriverType webUIDriverType) {
        switch (webUIDriverType) {
            case FIREFOX_DRIVER: {
                return ImageConstants.IMG_16_FIREFOX;
            }
            case CHROME_DRIVER: {
                return ImageConstants.IMG_16_CHROME;
            }
            case IE_DRIVER: {
                return ImageConstants.IMG_16_IE;
            }
        }
        return null;
    }

    private Image getWebUIDriverToolItemImage(WebUIDriverType webUIDriverType) {
        switch (webUIDriverType) {
            case FIREFOX_DRIVER: {
                return ImageConstants.IMG_24_FIREFOX;
            }
            case CHROME_DRIVER: {
                return ImageConstants.IMG_24_CHROME;
            }
            case IE_DRIVER: {
                return ImageConstants.IMG_24_IE;
            }
        }
        return null;
    }

    public void dispose() {
        if (this.server != null && this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        this.eventBroker.unsubscribe((EventHandler)this);
        this.stopRecordSession();
        AddonSocketServer.getInstance().stop();
    }

    private void stopRecordSession() {
        if (this.session != null && this.session.isRunning()) {
            this.session.stop();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createButtonBar(Composite parent) {
        Composite bottomComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        bottomComposite.setLayout((Layout)layout);
        bottomComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new HelpCompositeForDialog(bottomComposite, DocumentationMessageConstants.DIALOG_RECORDER_WEB_UI){

            protected GridData createGridData() {
                return new GridData(131072, 0x1000000, true, false);
            }

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginBottom = 0;
                layout.marginWidth = 0;
                return layout;
            }
        };
        super.createButtonBar(bottomComposite);
        return bottomComposite;
    }

    private List<WebPage> getCloneCapturedObjects(List<WebPage> pages) {
        return pages.stream().map(page -> page.softClone()).collect(Collectors.toList());
    }

    protected void okPressed() {
        Shell shell = this.getShell();
        int stepCount = this.countAllSteps();
        this.isOkPressed = true;
        try {
            if (!this.addElementToObjectRepository(shell)) {
                return;
            }
            super.okPressed();
            this.dispose();
            Trackings.trackCloseWebRecord((String)"ok", (int)stepCount, (SelectorMethod)this.getWebLocatorConfig());
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            MessageDialog.openError((Shell)shell, (String)StringConstants.ERROR_TITLE, (String)exception.getMessage());
        }
    }

    private int countAllSteps() {
        return this.recordStepsView.getTreeTable().getTree().getItemCount();
    }

    private boolean addElementToObjectRepository(Shell shell) throws Exception {
        TreeViewer capturedTreeViewer = this.capturedObjectComposite.getTreeViewer();
        if (capturedTreeViewer.getTree().getItemCount() == 0) {
            return true;
        }
        SaveToObjectRepositoryDialog addToObjectRepositoryDialog = new SaveToObjectRepositoryDialog(shell, true, this.getCloneCapturedObjects((List)capturedTreeViewer.getInput()), capturedTreeViewer.getExpandedElements());
        if (addToObjectRepositoryDialog.open() != 0) {
            return false;
        }
        this.targetFolderSelectionResult = addToObjectRepositoryDialog.getDialogResult();
        ObjectRepositoryService objectRepositoryService = new ObjectRepositoryService();
        this.refeshExplorer(objectRepositoryService.saveObject(this.targetFolderSelectionResult), addToObjectRepositoryDialog.getSelectedParentFolderResult());
        return true;
    }

    private void refeshExplorer(ObjectRepositoryService.SaveActionResult saveResult, FolderTreeEntity selectedParentFolder) {
        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)selectedParentFolder);
        for (Object[] testObj : saveResult.getUpdatedTestObjectIds()) {
            this.eventBroker.post("TESTOBJECT/UPDATED", (Object)testObj);
        }
        if (saveResult.getNewSelectionOnExplorer() == null) {
            return;
        }
    }

    public boolean close() {
        this.updateStore();
        this.disposed = true;
        boolean result = super.close();
        if (!this.isOkPressed) {
            try {
                Trackings.trackCloseWebRecord((String)"cancel", (int)0, (SelectorMethod)this.getWebLocatorConfig());
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return result;
    }

    private void updateStore() {
        this.store.setValue("recorder.defaultURL", this.txtStartUrl.getText());
        this.store.setValue("recorder.defaultBrowser", this.getSelectedBrowserType().toString());
        try {
            this.store.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.dispose();
    }

    protected Point getInitialSize() {
        return MIN_DIALOG_SIZE;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.dispose();
    }

    public void addNewActionMapping(final HTMLActionMapping newAction) {
        if (this.isPauseRecording || !HTMLActionUtil.verifyActionMapping(newAction, this.recordedActions)) {
            return;
        }
        final WebElement targetElement = newAction.getTargetElement();
        if (targetElement != null) {
            if (this.isUsingIE) {
                targetElement.setSelectorMethod(SelectorMethod.BASIC);
            }
            this.addNewElement(targetElement, newAction);
        }
        this.recordedActions.add(newAction);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RecorderDialog.this.recordStepsView.addNewStep(newAction);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                RecorderDialog.this.capturedObjectComposite.getTreeViewer().refresh();
                if (targetElement != null) {
                    RecorderDialog.this.capturedObjectComposite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)targetElement), true);
                }
            }
        });
    }

    private WebPage findPage(WebElement webElement) {
        if (webElement == null) {
            return null;
        }
        if (webElement instanceof WebPage) {
            return (WebPage)webElement;
        }
        WebFrame parent = webElement.getParent();
        if (parent == null) {
            return null;
        }
        return this.findPage((WebElement)parent);
    }

    private void addNewElement(WebElement newElement, HTMLActionMapping newAction) {
        WebPage parentPageElement = this.findPage(newElement);
        if (parentPageElement != null) {
            if (this.elements.contains(parentPageElement)) {
                this.addNewElement((WebFrame)this.elements.get(this.elements.indexOf(parentPageElement)), (WebElement)parentPageElement.getChildren().get(0), parentPageElement, newAction);
            } else {
                this.elements.add(parentPageElement);
            }
        }
    }

    private void addNewElement(WebFrame parentElement, WebElement newElement, WebPage pageElement, HTMLActionMapping newAction) {
        if (this.indexOf(parentElement.getChildren(), newElement) >= 0) {
            if (newElement instanceof WebFrame) {
                WebFrame frameElement = (WebFrame)newElement;
                WebFrame existingFrameElement = (WebFrame)parentElement.getChildren().get(this.indexOf(parentElement.getChildren(), newElement));
                this.addNewElement(existingFrameElement, (WebElement)frameElement.getChildren().get(0), pageElement, newAction);
            } else {
                for (WebElement element : parentElement.getChildren()) {
                    if (!this.isEquals(element, newElement)) continue;
                    newAction.setTargetElement(element);
                    break;
                }
            }
        } else {
            newElement.setName(this.getNewElementDisplayName(parentElement, newElement));
            newElement.setParent(parentElement);
            return;
        }
    }

    private String getNewElementDisplayName(WebFrame parentElement, WebElement newElement) {
        String newElementName = newElement.getName();
        List sameLevelElements = parentElement.getChildren();
        int maxPostfixNumber = 0;
        int count = 0;
        for (WebElement element : sameLevelElements) {
            String elementName = element.getName();
            if (elementName.equals(newElementName)) {
                ++count;
                continue;
            }
            if (!elementName.startsWith(newElementName)) continue;
            int expectedUnderscoreIndex = newElementName.length();
            if (elementName.length() <= expectedUnderscoreIndex + 1 || elementName.charAt(expectedUnderscoreIndex) != '_') continue;
            try {
                int postfixNumber = Integer.parseInt(elementName.substring(expectedUnderscoreIndex + 1));
                if (postfixNumber > maxPostfixNumber) {
                    maxPostfixNumber = postfixNumber;
                }
                ++count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return String.valueOf(newElementName) + (count > 0 ? "_" + ++maxPostfixNumber : "");
    }

    private int indexOf(List<WebElement> elements, WebElement frame) {
        int index = 0;
        while (index < elements.size()) {
            if (this.isEquals(frame, elements.get(index))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean isEquals(WebElement elm1, WebElement elm2) {
        return new EqualsBuilder().append((Object)elm1.getType(), (Object)elm2.getType()).append((Object)elm1.getTag(), (Object)elm2.getTag()).append(elm1.hasProperty(), elm2.hasProperty()).append((Object)elm1.getXpath(), (Object)elm2.getXpath()).append((Object)elm1.getName(), (Object)elm2.getName()).isEquals();
    }

    public List<HTMLActionMapping> getActions() {
        return this.recordedActions;
    }

    public List<WebPage> getElements() {
        return this.elements;
    }

    public SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult getTargetFolderTreeEntity() {
        return this.targetFolderSelectionResult;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public ScriptNodeWrapper getScriptWrapper() {
        return this.recordStepsView.getWrapper();
    }

    public void handleEvent(Event event) {
        Object dataObject = event.getProperty("org.eclipse.e4.data");
        switch (event.getTopic()) {
            case "RECORDER/HTML_ACTION_CAPTURED": {
                if (!(dataObject instanceof HTMLActionMapping)) {
                    return;
                }
                this.addNewActionMapping((HTMLActionMapping)dataObject);
                return;
            }
            case "RECORDER/ACTION_OBJECT_REORDERED": {
                if (!(dataObject instanceof WebElement[])) {
                    return;
                }
                WebElement[] oldNewElement = (WebElement[])dataObject;
                if (oldNewElement.length != 2) {
                    return;
                }
                this.replaceCapturedObjectInActionMapping(oldNewElement[0], oldNewElement[1]);
                return;
            }
            case "WORKSPACE/CLOSE": {
                this.cancelPressed();
                return;
            }
            case "WEBUI_VERIFICATION/EXECUTION_FINISHED": {
                this.setPlayButtonState(false);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.shouldResumeRecordingAfterRunning && this.session.isRunning() && this.session.isDriverRunning()) {
                    this.resume();
                    this.shouldResumeRecordingAfterRunning = false;
                }
                return;
            }
            case "WEBUI_VERIFICATION/RUN_ALL_STEPS_CMD": {
                this.runAllSteps();
                return;
            }
            case "WEBUI_VERIFICATION/RUN_SELECTED_STEPS_CMD": {
                this.runSelectedSteps();
                return;
            }
            case "WEBUI_VERIFICATION/RUN_FROM_STEP_CMD": {
                this.runFromStep();
                return;
            }
        }
    }

    private void replaceCapturedObjectInActionMapping(WebElement oldElement, WebElement newElement) {
        if (this.recordedActions == null || this.recordedActions.isEmpty()) {
            return;
        }
        for (HTMLActionMapping action : this.recordedActions) {
            if (!oldElement.equals((Object)action.getTargetElement())) continue;
            action.setTargetElement(newElement);
        }
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
        Boolean continueRecording = null;
        if (this.testCaseEntity != null && this.nodeWrappers.size() > 0) {
            MessageDialog dialog = new MessageDialog(this.getShell(), StringConstants.CONFIRMATION, null, MessageFormat.format(ComposerWebuiRecorderMessageConstants.DIA_CONFIRM_CONTINUE_RECORDING, this.testCaseEntity.getName()), 5, 0, new String[]{ComposerWebuiRecorderMessageConstants.DIA_CONFIRM_ACCEPT_CONTINUE_RECORDING, ComposerWebuiRecorderMessageConstants.DIA_CONFIRM_DECLINE_CONTINUE_RECORDING});
            if (dialog.open() != 0) {
                this.variables = Collections.emptyList();
                this.nodeWrappers.clear();
                continueRecording = false;
            } else {
                continueRecording = true;
            }
        }
        this.recordStepsView.addVariables(this.variables.toArray(new VariableEntity[this.variables.size()]));
        Map<String, List<RecordedElementMethodCallWrapper>> keywordNodeMaps = this.getTestObjectReferences(this.nodeWrappers);
        HashMap webElementIndex = new HashMap();
        HashMap<String, WebPage> pageIndex = new HashMap<String, WebPage>();
        List webElementEntities = keywordNodeMaps.keySet().stream().map(testObjectId -> {
            try {
                return ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(we -> we != null).collect(Collectors.toList());
        for (WebElementEntity entity : webElementEntities) {
            WebElement we2;
            FolderEntity folder = entity.getParentFolder();
            WebPage webPage = pageIndex.getOrDefault(folder.getIdForDisplay(), null);
            if (webPage == null) {
                webPage = new WebPage(folder.getName());
                pageIndex.put(folder.getIdForDisplay(), webPage);
            }
            if ((we2 = (WebElement)webElementIndex.getOrDefault(entity.getIdForDisplay(), null)) == null) {
                we2 = WebElementUtils.createWebElementFromTestObject((WebElementEntity)entity, (boolean)false, (WebPage)webPage, webElementIndex);
            }
            for (RecordedElementMethodCallWrapper refNode : keywordNodeMaps.get(entity.getIdForDisplay())) {
                refNode.setWebElement(we2);
            }
        }
        this.recordStepsView.getTreeTableInput().addNewAstObjects(this.nodeWrappers, null, TestCaseTreeTableInput.NodeAddType.Add);
        this.recordStepsView.getTreeTableInput().refresh();
        List allPages = pageIndex.entrySet().stream().map(e -> (WebPage)e.getValue()).collect(Collectors.toList());
        this.elements = new ArrayList<WebPage>();
        this.elements.addAll(allPages);
        this.capturedObjectComposite.setInput(this.elements);
        this.capturedObjectComposite.refreshTree(null);
        try {
            Trackings.trackOpenWebRecord((Boolean)continueRecording, (SelectorMethod)this.getWebLocatorConfig());
        }
        catch (IOException e2) {
            LoggerSingleton.logError((Throwable)e2);
        }
    }

    private SelectorMethod getWebLocatorConfig() throws IOException {
        WebUiExecutionSettingStore webUiSettingStore = WebUiExecutionSettingStore.getStore();
        return webUiSettingStore.getCapturedTestObjectSelectorMethod();
    }

    private Map<String, List<RecordedElementMethodCallWrapper>> getTestObjectReferences(ASTNodeWrapper wrapper) {
        if (wrapper instanceof RecordedElementMethodCallWrapper) {
            return Collections.emptyMap();
        }
        HashMap<String, List<RecordedElementMethodCallWrapper>> keywordNodeIndex = new HashMap<String, List<RecordedElementMethodCallWrapper>>();
        if (wrapper.hasAstChildren() && wrapper.getAstChildren() != null) {
            this.merge(keywordNodeIndex, this.getTestObjectReferences(wrapper.getAstChildren()));
        }
        if (wrapper.getInput() instanceof MethodCallExpressionWrapper) {
            MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)wrapper.getInput();
            if (!methodCall.isFindTestObjectMethodCall()) {
                return keywordNodeIndex;
            }
            String testObjectId = AstEntityInputUtil.getEntityRelativeIdFromMethodCall((MethodCallExpressionWrapper)methodCall);
            try {
                testObjectId = testObjectId.startsWith("Object Repository/") ? testObjectId : "Object Repository/" + testObjectId;
                WebElementEntity entity = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
                if (entity != null) {
                    ArrayList<RecordedElementMethodCallWrapper> refNodes = keywordNodeIndex.getOrDefault(entity.getIdForDisplay(), null);
                    if (refNodes == null) {
                        refNodes = new ArrayList<RecordedElementMethodCallWrapper>();
                    }
                    RecordedElementMethodCallWrapper newWrapper = new RecordedElementMethodCallWrapper(wrapper.getParent(), null);
                    wrapper.getParent().replaceChild(wrapper, (ASTNodeWrapper)newWrapper);
                    refNodes.add(newWrapper);
                    keywordNodeIndex.put(entity.getIdForDisplay(), refNodes);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else if (wrapper.getInput() instanceof ArgumentListExpressionWrapper) {
            ArgumentListExpressionWrapper argumentList = (ArgumentListExpressionWrapper)wrapper.getInput();
            this.merge(keywordNodeIndex, this.getTestObjectReferences(argumentList.getAstChildren()));
        }
        return keywordNodeIndex;
    }

    private void merge(Map<String, List<RecordedElementMethodCallWrapper>> keywordNodeIndex, Map<String, List<RecordedElementMethodCallWrapper>> childNodeMap) {
        childNodeMap.entrySet().stream().forEach(e -> {
            String objectId = (String)e.getKey();
            List newAstNodes = (List)e.getValue();
            if (keywordNodeIndex.containsKey(objectId)) {
                List currentAstNodes = (List)keywordNodeIndex.get(objectId);
                currentAstNodes.addAll(newAstNodes);
                keywordNodeIndex.put(objectId, currentAstNodes);
            } else {
                keywordNodeIndex.put(objectId, newAstNodes);
            }
        });
    }

    private Map<String, List<RecordedElementMethodCallWrapper>> getTestObjectReferences(List<? extends ASTNodeWrapper> nodes) {
        HashMap<String, List<RecordedElementMethodCallWrapper>> keywordNodeIndex = new HashMap<String, List<RecordedElementMethodCallWrapper>>();
        for (ASTNodeWrapper aSTNodeWrapper : nodes) {
            Map<String, List<RecordedElementMethodCallWrapper>> childNodeMap = this.getTestObjectReferences(aSTNodeWrapper);
            this.merge(keywordNodeIndex, childNodeMap);
        }
        return keywordNodeIndex;
    }

    public Iterable<EventListener<ObjectSpyEvent>> getListeners(ObjectSpyEvent event) {
        return this.eventListeners.get(event);
    }

    public void addListener(EventListener<ObjectSpyEvent> listener, Iterable<ObjectSpyEvent> events) {
        events.forEach(e -> {
            Set<EventListener<ObjectSpyEvent>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<ObjectSpyEvent>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((ObjectSpyEvent)e, listenerOnEvent);
        });
    }

    public VariableEntity[] getVariables() {
        return this.recordStepsView.getVariables();
    }

    private WebUIDriverType getSelectedBrowserType() {
        if (this.selectedBrowser == null || !(this.selectedBrowser.getDriverType() instanceof WebUIDriverType)) {
            return null;
        }
        return (WebUIDriverType)this.selectedBrowser.getDriverType();
    }
}

