/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.core;

import com.kms.katalon.composer.webui.recorder.core.HTMLElementRecorderServer;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.objectspy.core.HTMLElementCaptureServer;
import com.kms.katalon.objectspy.core.InspectSession;
import com.kms.katalon.objectspy.util.FileUtil;
import com.kms.katalon.objectspy.websocket.AddonCommand;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.AddonSocketServer;
import com.kms.katalon.objectspy.websocket.messages.AddonMessage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openqa.selenium.WebDriverException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class RecordSession
extends InspectSession {
    public static final String RECORDER_ADDON_NAME = "Recorder";
    private static final String CHROME_EXTENSION_RELATIVE_PATH = String.valueOf(File.separator) + "Chrome" + File.separator + "Recorder" + File.separator + "KR";
    private static final String RECORDER_APPLICATION_DATA_FOLDER = String.valueOf(System.getProperty("user.home")) + File.separator + "AppData" + File.separator + "Local" + File.separator + "KMS" + File.separator + "qAutomate" + File.separator + "Recorder";
    private Set<BrowserStoppedListener> browserStoppedListeners = new LinkedHashSet<BrowserStoppedListener>();

    public RecordSession(HTMLElementCaptureServer server, IDriverConnector driverConnector) throws Exception {
        super(server, driverConnector);
    }

    public RecordSession(HTMLElementRecorderServer server, IDriverConnector driverConnector, String startUrl) {
        super((HTMLElementCaptureServer)server, driverConnector, startUrl);
    }

    protected String getChromeExtensionPath() {
        return CHROME_EXTENSION_RELATIVE_PATH;
    }

    protected File getChromeExtensionFile() throws IOException {
        File chromeExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory((Bundle)FrameworkUtil.getBundle(RecordSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            chromeExtension = new File(String.valueOf(extensionFolder.getAbsolutePath()) + this.getChromeExtensionPath());
        }
        return chromeExtension;
    }

    protected String getAddOnName() {
        return RECORDER_ADDON_NAME;
    }

    protected String getIEApplicationDataFolder() {
        return RECORDER_APPLICATION_DATA_FOLDER;
    }

    protected void handleForFirefoxAddon() throws InterruptedException {
        AddonSocketServer socketServer = AddonSocketServer.getInstance();
        while (socketServer.getAddonSocketByBrowserName(this.webUiDriverType.toString()) == null && this.isRunFlag) {
            Thread.sleep(500L);
        }
        AddonSocket firefoxAddonSocket = socketServer.getAddonSocketByBrowserName(this.webUiDriverType.toString());
        if (firefoxAddonSocket != null) {
            firefoxAddonSocket.sendMessage(new AddonMessage(AddonCommand.START_RECORD));
        }
    }

    public void run() {
        super.run();
        this.handleBrowserStopped();
    }

    private void handleBrowserStopped() {
        this.browserStoppedListeners.parallelStream().forEach(l -> l.onBrowserStopped());
    }

    public void addBrowserStoppedListener(BrowserStoppedListener listener) {
        this.browserStoppedListeners.add(listener);
    }

    public boolean isDriverRunning() {
        try {
            this.getWebDriver().getWindowHandle();
            return true;
        }
        catch (WebDriverException webDriverException) {
            return false;
        }
    }

    public static interface BrowserStoppedListener {
        public void onBrowserStopped();
    }
}

