/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.core;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webui.recorder.dialog.RecorderDialog;
import com.kms.katalon.composer.webui.recorder.util.HTMLActionJsonParser;
import com.kms.katalon.objectspy.util.HTMLElementUtil;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTMLElementRecorderServlet
extends HttpServlet {
    private static final String ELEMENT_KEY = "element";
    private static final long serialVersionUID = 1L;
    private RecorderDialog recorderDialog;

    public HTMLElementRecorderServlet(RecorderDialog recorderDialog) {
        this.recorderDialog = recorderDialog;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        if (sb.indexOf("=") == -1) {
            return;
        }
        String key = sb.substring(0, sb.indexOf("="));
        if (!HTMLElementUtil.decodeURIComponent((String)key).equals(ELEMENT_KEY)) {
            return;
        }
        String value = sb.substring(sb.indexOf("=") + 1, sb.length());
        response.setContentType("text/html");
        response.addHeader("Access-Control-Allow-Origin", "*");
        try {
            this.recorderDialog.addNewActionMapping(HTMLActionJsonParser.parseJsonIntoHTMLActionMapping(value));
            response.setStatus(200);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            response.setStatus(500);
        }
    }
}

