/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testdata.constants.ImageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.composer.testdata.parts.InternalDataCell;
import com.kms.katalon.composer.testdata.parts.InternalDataRow;
import com.kms.katalon.composer.testdata.parts.TestDataMainPart;
import com.kms.katalon.composer.testdata.parts.provider.InternalDataAddColumnLabelProvider;
import com.kms.katalon.composer.testdata.parts.provider.InternalDataColumViewerEditor;
import com.kms.katalon.composer.testdata.parts.provider.InternalDataEditingSupport;
import com.kms.katalon.composer.testdata.parts.provider.InternalDataLabelProvider;
import com.kms.katalon.composer.testdata.views.NewTestDataColumnDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.InternalDataColumnEntity;
import com.kms.katalon.entity.testdata.InternalDataFilePropertyEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class InternalTestDataPart
extends TestDataMainPart {
    private static final int DF_UNREMOVEVABLE_COLUMN_WIDTH = 40;
    private static final int DF_REMOVEVABLE_COLUMN_WIDTH = 100;
    private static final int COLUMN_NO_IDX = 0;
    public static final int BASE_COLUMN_INDEX = 1;
    private static final int UNREMOVABLE_COLUMNS = 2;
    private static final int LEFT_CLICK = 1;
    @Inject
    private EPartService partService;
    private List<InternalDataRow> input;
    private Table table;
    private CTableViewer tableViewer;

    @Override
    protected EPartService getPartService() {
        return this.partService;
    }

    @Focus
    public void setFocus() {
        this.table.setFocus();
    }

    @Override
    protected Composite createFileInfoPart(Composite parent) {
        return null;
    }

    @Override
    @PostConstruct
    public void createControls(Composite parent, MPart mpart) {
        new HelpToolBarForMPart(mpart, DocumentationMessageConstants.TEST_DATA_INTERNAL);
        super.createControls(parent, mpart);
    }

    @Override
    public Composite createDataTablePart(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableViewerComposite = new Composite(parent, 2048);
        tableViewerComposite.setLayout((Layout)new GridLayout(1, true));
        tableViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContents(tableViewerComposite);
        return tableViewerComposite;
    }

    private void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new CTableViewer(parent, 98306);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.createColumnViewer(StringConstants.PA_COL_NO, 0x1000000, false, 40, (CellLabelProvider)new InternalDataAddColumnLabelProvider(), null);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        InternalDataColumViewerEditor.create(this.tableViewer, new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer), 178);
        this.addMouseEventListenersForTable(this.table);
        this.table.setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
    }

    private TableViewerColumn createColumnViewer(String name, int style, boolean resizable, int width, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        TableViewerColumn tableColumnViewer = new TableViewerColumn((TableViewer)this.tableViewer, style);
        InternalTestDataPart.addInfoForTableColumn(tableColumnViewer, name, resizable, width, labelProvider, editingSupport);
        return tableColumnViewer;
    }

    private static void addInfoForTableColumn(TableViewerColumn tableViewerColumn, String name, boolean resizable, int width, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText(name);
        tableColumn.setResizable(resizable);
        tableViewerColumn.setLabelProvider(labelProvider);
        if (editingSupport != null) {
            tableViewerColumn.setEditingSupport(editingSupport);
        }
    }

    private void createColumns(DataFileEntity dataFile) {
        for (InternalDataColumnEntity dataCol : dataFile.getInternalDataColumns()) {
            this.createColumnViewer(dataCol.getName(), 0, true, 100, (CellLabelProvider)new InternalDataLabelProvider(), (EditingSupport)new InternalDataEditingSupport(this, (ColumnViewer)this.tableViewer));
        }
        TableViewerColumn tableViewerColumnAdd = this.createColumnViewer("", 0x1000000, false, 40, (CellLabelProvider)new InternalDataLabelProvider(), null);
        TableColumn columnAdd = tableViewerColumnAdd.getColumn();
        columnAdd.setImage(ImageConstants.IMG_16_ADD);
        columnAdd.setToolTipText(StringConstants.PA_TOOL_TIP_ADD_COLUMN);
        columnAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InternalTestDataPart.this.openAddColumnDialog(InternalTestDataPart.this.table.getColumnCount() - 1);
            }
        });
        this.table.redraw();
    }

    private void addMouseEventListenersForTable(final Table table) {
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point cursorPt = table.getDisplay().map(null, (Control)table, new Point(event.x, event.y));
                Point plusedHorizontalPt = new Point(cursorPt.x + table.getHorizontalBar().getSelection(), cursorPt.y);
                Rectangle clientArea = table.getClientArea();
                boolean isHeader = cursorPt.y >= clientArea.y && cursorPt.y < clientArea.y + table.getHeaderHeight();
                int colIndex = -1;
                int theWidth = 0;
                int i = 0;
                while (i < table.getColumns().length) {
                    TableColumn tc = table.getColumns()[i];
                    if (theWidth < plusedHorizontalPt.x && plusedHorizontalPt.x < theWidth + tc.getWidth()) {
                        colIndex = i;
                        break;
                    }
                    theWidth += tc.getWidth();
                    ++i;
                }
                InternalTestDataPart.this.createContextMenu(colIndex, isHeader, cursorPt);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 1) {
                    InternalTestDataPart.this.handleLeftClick(new Point(event.x, event.y));
                }
            }
        });
    }

    private void handleLeftClick(Point pt) {
        ViewerCell viewerCell = this.tableViewer.getCell(pt);
        if (viewerCell == null) {
            return;
        }
        Object selectedObject = viewerCell.getElement();
        if (!(selectedObject instanceof InternalDataRow)) {
            return;
        }
        InternalDataRow element = (InternalDataRow)selectedObject;
        if (element.isLastRow()) {
            int lastCollectionIndex = this.lastCollectionIndex(this.input);
            this.insertNewRow(lastCollectionIndex);
        }
    }

    private void insertNewRow(int indexToInsert) {
        this.executeOperation((IUndoableOperation)new InsertNewRowOperation(indexToInsert));
    }

    private MenuItem createMenuItem(Menu parent, String text, int style, SelectionListener listener) {
        MenuItem menuItemInsertRow = new MenuItem(parent, style);
        menuItemInsertRow.setText(text);
        if (listener != null) {
            menuItemInsertRow.addSelectionListener(listener);
        }
        return menuItemInsertRow;
    }

    private Menu createContextMenu(final int selectedColIndex, boolean isHeader, Point point) {
        Menu menu = this.table.getMenu();
        if (menu != null && menu.isDisposed()) {
            menu.dispose();
        }
        menu = new Menu((Control)this.table);
        menu.setData((Object)point);
        this.createMenuItem(menu, StringConstants.PA_MENU_CONTEXT_INSERT_ROW, 8, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InternalTestDataPart.this.insertNewRow(InternalTestDataPart.this.getRowIndexOnMouse(event));
            }
        });
        Menu menuInsertColumn = new Menu(menu);
        MenuItem menuItemInsertColumn = this.createMenuItem(menu, StringConstants.PA_MENU_CONTEXT_INSERT_COL, 64, null);
        menuItemInsertColumn.setMenu(menuInsertColumn);
        if (selectedColIndex > 0) {
            this.createMenuItem(menuInsertColumn, StringConstants.PA_MENU_CONTEXT_INSERT_COL_TO_THE_LEFT, 8, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InternalTestDataPart.this.openAddColumnDialog(selectedColIndex);
                }
            });
        }
        if (selectedColIndex < this.lastColumnIndex()) {
            this.createMenuItem(menuInsertColumn, StringConstants.PA_MENU_CONTEXT_INSERT_COL_TO_THE_RIGHT, 8, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int newColumnIndex = selectedColIndex >= 0 ? Math.min(selectedColIndex + 1, InternalTestDataPart.this.lastColumnIndex()) : InternalTestDataPart.this.lastColumnIndex();
                    InternalTestDataPart.this.openAddColumnDialog(newColumnIndex);
                }
            });
        }
        if (this.isEditableColumn(selectedColIndex)) {
            this.createMenuItem(menu, StringConstants.PA_MENU_CONTEXT_RENAME_COL, 8, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn selectedCol = InternalTestDataPart.this.table.getColumn(selectedColIndex);
                    NewTestDataColumnDialog dialog = new NewTestDataColumnDialog(Display.getDefault().getActiveShell(), selectedCol.getText(), InternalTestDataPart.this.getCurrentColumnNames());
                    if (dialog.open() != 0) {
                        return;
                    }
                    String columnName = dialog.getName();
                    InternalTestDataPart.this.renameColumn(selectedCol, columnName);
                }
            });
        }
        Menu menuDelete = new Menu(menu);
        MenuItem menuItemDelete = this.createMenuItem(menu, StringConstants.PA_MENU_CONTEXT_DEL, 64, null);
        menuItemDelete.setMenu(menuDelete);
        if (this.isEditableColumn(selectedColIndex)) {
            this.createMenuItem(menuDelete, StringConstants.PA_MENU_CONTEXT_DEL_COL, 8, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InternalTestDataPart.this.deleteColumn(selectedColIndex);
                    InternalTestDataPart.this.dirtyable.setDirty(true);
                }
            });
        }
        if (this.isTableContainingRow()) {
            this.createMenuItem(menuDelete, StringConstants.PA_MENU_CONTEXT_DEL_ROWS, 8, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InternalTestDataPart.this.deleteSelectedRows();
                }
            });
        }
        this.table.setMenu(menu);
        return menu;
    }

    private void renameColumn(TableColumn selectedCol, String columnName) {
        this.executeOperation((IUndoableOperation)new RenameColumnOperation(selectedCol, columnName));
    }

    private void deleteSelectedRows() {
        this.executeOperation((IUndoableOperation)new DeleteRowsOperation());
    }

    private int getRowIndexOnMouse(SelectionEvent event) {
        Point pt = (Point)this.table.getMenu().getData();
        ViewerCell viewerCell = this.tableViewer.getCell(pt);
        if (viewerCell == null) {
            return this.lastCollectionIndex(this.input);
        }
        return this.input.indexOf(viewerCell.getElement());
    }

    private boolean isEditableColumn(int selectedColIndex) {
        return selectedColIndex > 0 && selectedColIndex < this.lastColumnIndex();
    }

    private boolean isTableContainingRow() {
        return this.table.getItemCount() > 1;
    }

    private void insertNewColumn(int index, String title) {
        this.executeOperation((IUndoableOperation)new InsertColumnOperation(this, index, title));
    }

    private void refresh() {
        this.tableViewer.refresh();
        this.tableViewer.getTable().setFocus();
    }

    private void deleteColumn(int index) {
        this.executeOperation((IUndoableOperation)new DeleteColumnOperation(this, index));
    }

    @Persist
    public void save() {
        this.table.forceFocus();
        try {
            this.originalDataFile = this.updateInternalDataFileProperty(this.originalDataFile.getLocation(), this.originalDataFile.getName(), this.originalDataFile.getDescription(), this.originalDataFile.getDriver(), this.originalDataFile.getDataSourceUrl(), "", this.originalDataFile.getTableDataName(), this.getCurrentDataColumnEntities(), this.tableInputToData());
            this.updateDataFile(this.originalDataFile);
            this.dirtyable.setDirty(false);
            this.refreshTreeEntity();
            this.sendTestDataUpdatedEvent(this.originalDataFile.getId());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_TEST_DATA, (String)e.getClass().getSimpleName());
        }
    }

    private DataFileEntity updateInternalDataFileProperty(String pk, String name, String description, DataFileEntity.DataFileDriverType dataFileDriver, String dataSourceURL, String sheetName, String tableName, List<Object> headerColumn, List<List<Object>> data) throws Exception {
        InternalDataFilePropertyEntity internalData = new InternalDataFilePropertyEntity();
        internalData.setPk(pk);
        internalData.setName(name);
        internalData.setDescription(description);
        internalData.setDataFileDriverName(dataFileDriver.name());
        internalData.setDataSourceURL(dataSourceURL);
        internalData.setSheetName(sheetName);
        internalData.setTableName(tableName);
        internalData.setHeaderColumn(headerColumn);
        internalData.setData(data);
        DataFileEntity dataFileEntity = TestDataController.getInstance().updateDataFile(internalData);
        return dataFileEntity;
    }

    @Override
    protected void updateChildInfo(DataFileEntity dataFile) {
        this.clearTable();
        this.createColumns(dataFile);
        this.updateTableInput(dataFile);
    }

    private void updateTableInput(DataFileEntity dataFile) {
        this.input = this.getTableInput(dataFile);
        this.tableViewer.setInput(this.input);
    }

    private void openAddColumnDialog(int selectedColIndex) {
        NewTestDataColumnDialog dialog = new NewTestDataColumnDialog(Display.getDefault().getActiveShell(), this.getCurrentColumnNames());
        if (dialog.open() == 0) {
            this.insertNewColumn(selectedColIndex, dialog.getName());
            this.dirtyable.setDirty(true);
        }
    }

    private void clearTable() {
        this.table.setRedraw(false);
        while (this.table.getColumnCount() > 1) {
            this.table.getColumns()[1].dispose();
        }
        this.table.removeAll();
        this.table.setRedraw(true);
    }

    private int lastColumnIndex() {
        return this.table.getColumnCount() - 1;
    }

    private int lastCollectionIndex(Collection<?> collection) {
        return collection.size() - 1;
    }

    private String[] getCurrentColumnNames() {
        if (this.table.getColumnCount() < 2) {
            return new String[0];
        }
        String[] columnNames = new String[this.getEditableColumnsSize()];
        int i = 1;
        while (i < this.lastColumnIndex()) {
            columnNames[i - 1] = this.table.getColumn(i).getText();
            ++i;
        }
        return columnNames;
    }

    private int getEditableColumnsSize() {
        return Math.max(0, this.table.getColumnCount() - 2);
    }

    private List<Object> getCurrentDataColumnEntities() {
        ArrayList<Object> dataColumnEntities = new ArrayList<Object>();
        String[] currentColumnNames = this.getCurrentColumnNames();
        int i = 0;
        while (i < currentColumnNames.length) {
            InternalDataColumnEntity dataColumn = new InternalDataColumnEntity();
            dataColumn.setColumnIndex(i);
            dataColumn.setName(currentColumnNames[i]);
            dataColumn.setSize(this.input.size() - 1);
            dataColumnEntities.add(dataColumn);
            ++i;
        }
        return dataColumnEntities;
    }

    private List<InternalDataRow> getTableInput(DataFileEntity dataFile) {
        ArrayList<InternalDataRow> dataRows = new ArrayList<InternalDataRow>();
        List internalDataColumns = dataFile.getInternalDataColumns();
        for (List rowData : dataFile.getData()) {
            InternalDataRow tableRow = new InternalDataRow();
            int i = 0;
            while (i < internalDataColumns.size()) {
                InternalDataCell tableCell = new InternalDataCell(Objects.toString(rowData.get(i)));
                tableRow.getCells().add(i, tableCell);
                ++i;
            }
            dataRows.add(tableRow);
        }
        dataRows.add(InternalDataRow.newLastRow());
        return dataRows;
    }

    public CTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public List<InternalDataRow> getInput() {
        return this.input;
    }

    private List<List<Object>> tableInputToData() {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (InternalDataRow tableRow : this.input) {
            if (tableRow.isLastRow()) continue;
            ArrayList<String> rowData = new ArrayList<String>();
            int i = 0;
            while (i < this.getCurrentColumnNames().length) {
                rowData.add(tableRow.getCells().get(i).getValue());
                ++i;
            }
            data.add(rowData);
        }
        return data;
    }

    private int getUpperBoundColumnIndex(InternalDataRow dataRow, int index) {
        return Math.min(this.lastCollectionIndex(dataRow.getCells()), index - 1);
    }

    private TableViewerColumn createTableColumn(InternalTestDataPart testDataPart, int index, String tableColumnHeader) {
        CTableViewer tableViewer = testDataPart.getTableViewer();
        TableViewerColumn tableColumn = new TableViewerColumn((TableViewer)tableViewer, 0, index);
        InternalTestDataPart.addInfoForTableColumn(tableColumn, tableColumnHeader, true, 100, (CellLabelProvider)new InternalDataLabelProvider(), (EditingSupport)new InternalDataEditingSupport(testDataPart, (ColumnViewer)tableViewer));
        return tableColumn;
    }

    private class DeleteColumnOperation
    extends AbstractOperation {
        private InternalTestDataPart testDataPart;
        private int index;
        private List<OperationData> deletedDatas;
        private String oldColumnTitle;
        private Table table;

        public DeleteColumnOperation(InternalTestDataPart testDataPart, int index) {
            super(DeleteColumnOperation.class.getName());
            this.deletedDatas = new ArrayList<OperationData>();
            this.testDataPart = testDataPart;
            this.table = testDataPart.getTableViewer().getTable();
            this.index = index;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (InternalDataRow dataRow : InternalTestDataPart.this.input) {
                if (dataRow.isLastRow()) continue;
                int columnIndex = this.index - 1;
                InternalDataCell dataCell = dataRow.getCells().get(columnIndex);
                this.deletedDatas.add(new OperationData(columnIndex, dataCell));
                dataRow.getCells().remove(dataCell);
            }
            TableColumn deletedTableColumn = this.table.getColumn(this.index);
            this.oldColumnTitle = deletedTableColumn.getText();
            deletedTableColumn.dispose();
            this.table.redraw();
            InternalTestDataPart.this.refresh();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            int rowIndex = 0;
            while (rowIndex < InternalTestDataPart.this.input.size()) {
                InternalDataRow dataRow = (InternalDataRow)InternalTestDataPart.this.input.get(rowIndex);
                if (!dataRow.isLastRow()) {
                    OperationData deletedData = this.deletedDatas.get(rowIndex);
                    dataRow.getCells().remove(deletedData.getColumnIndex());
                }
                ++rowIndex;
            }
            TableColumn deletedTableColumn = this.table.getColumn(this.index);
            deletedTableColumn.dispose();
            this.table.redraw();
            InternalTestDataPart.this.refresh();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            InternalTestDataPart.this.createTableColumn(this.testDataPart, this.index, this.oldColumnTitle);
            int rowIndex = 0;
            while (rowIndex < InternalTestDataPart.this.input.size()) {
                InternalDataRow dataRow = (InternalDataRow)InternalTestDataPart.this.input.get(rowIndex);
                if (!dataRow.isLastRow()) {
                    OperationData deletedData = this.deletedDatas.get(rowIndex);
                    dataRow.getCells().add(deletedData.getColumnIndex(), deletedData.getCellData());
                }
                ++rowIndex;
            }
            InternalTestDataPart.this.refresh();
            return Status.OK_STATUS;
        }
    }

    private class DeleteRowsOperation
    extends AbstractOperation {
        private LinkedHashMap<InternalDataRow, Integer> deletedDataRows;
        private List<Map.Entry<InternalDataRow, Integer>> reversedDeletedDatas;

        public DeleteRowsOperation() {
            super(DeleteRowsOperation.class.getName());
            this.deletedDataRows = new LinkedHashMap();
            this.reversedDeletedDatas = new ArrayList<Map.Entry<InternalDataRow, Integer>>();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Object[] dataArray;
            StructuredSelection selection = (StructuredSelection)InternalTestDataPart.this.tableViewer.getSelection();
            if (selection != null && selection.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            boolean changed = false;
            Object[] objectArray = dataArray = selection.toArray();
            int n = dataArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                InternalDataRow dataRow = (InternalDataRow)selected;
                if (!dataRow.isLastRow()) {
                    this.deletedDataRows.put(dataRow, InternalTestDataPart.this.input.indexOf(dataRow));
                    InternalTestDataPart.this.input.remove(dataRow);
                    changed = true;
                }
                ++n2;
            }
            if (!changed) {
                return Status.CANCEL_STATUS;
            }
            this.reversedDeletedDatas = new ArrayList<Map.Entry<InternalDataRow, Integer>>(this.deletedDataRows.entrySet());
            Collections.reverse(this.reversedDeletedDatas);
            InternalTestDataPart.this.refresh();
            InternalTestDataPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (Map.Entry<InternalDataRow, Integer> deletedRowEntry : this.deletedDataRows.entrySet()) {
                InternalTestDataPart.this.input.remove(deletedRowEntry.getKey());
            }
            InternalTestDataPart.this.refresh();
            InternalTestDataPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (Map.Entry<InternalDataRow, Integer> deletedRowEntry : this.reversedDeletedDatas) {
                InternalTestDataPart.this.input.add(deletedRowEntry.getValue(), deletedRowEntry.getKey());
            }
            InternalTestDataPart.this.refresh();
            InternalTestDataPart.this.dirtyable.setDirty(true);
            InternalTestDataPart.this.tableViewer.setSelection((ISelection)new StructuredSelection(this.deletedDataRows.keySet().toArray()));
            return Status.OK_STATUS;
        }
    }

    private class InsertColumnOperation
    extends AbstractOperation {
        private InternalTestDataPart testDataPart;
        private int index;
        private String title;
        private List<OperationData> addedDatas;

        public InsertColumnOperation(InternalTestDataPart testDataPart, int index, String title) {
            super(InsertColumnOperation.class.getName());
            this.addedDatas = new ArrayList<OperationData>();
            this.testDataPart = testDataPart;
            this.index = index;
            this.title = title;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            InternalTestDataPart.this.createTableColumn(this.testDataPart, this.index, this.title);
            for (InternalDataRow dataRow : InternalTestDataPart.this.input) {
                if (dataRow.isLastRow()) continue;
                InternalDataCell newEmptyCell = InternalDataCell.newEmptyCell();
                int columnIndex = InternalTestDataPart.this.getUpperBoundColumnIndex(dataRow, this.index);
                dataRow.getCells().add(columnIndex, newEmptyCell);
                this.addedDatas.add(new OperationData(columnIndex, newEmptyCell));
            }
            InternalTestDataPart.this.refresh();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            InternalTestDataPart.this.createTableColumn(this.testDataPart, this.index, this.title);
            int rowIndex = 0;
            while (rowIndex < InternalTestDataPart.this.input.size()) {
                InternalDataRow dataRow = (InternalDataRow)InternalTestDataPart.this.input.get(rowIndex);
                if (!dataRow.isLastRow()) {
                    OperationData insertData = this.addedDatas.get(rowIndex);
                    dataRow.getCells().add(insertData.getColumnIndex(), insertData.getCellData());
                }
                ++rowIndex;
            }
            InternalTestDataPart.this.refresh();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.testDataPart.getTableViewer().getTable().getColumn(this.index).dispose();
            int rowIndex = 0;
            while (rowIndex < InternalTestDataPart.this.input.size()) {
                InternalDataRow dataRow = (InternalDataRow)InternalTestDataPart.this.input.get(rowIndex);
                if (!dataRow.isLastRow()) {
                    dataRow.getCells().remove(this.index);
                }
                ++rowIndex;
            }
            InternalTestDataPart.this.refresh();
            return Status.OK_STATUS;
        }
    }

    private class InsertNewRowOperation
    extends AbstractOperation {
        private int insertIndex;
        private InternalDataRow newRow;

        public InsertNewRowOperation(int insertIndex) {
            super(InsertNewRowOperation.class.getName());
            this.insertIndex = insertIndex;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.newRow = new InternalDataRow();
            int editableColumnsSize = InternalTestDataPart.this.getEditableColumnsSize();
            int i = 0;
            while (i < editableColumnsSize) {
                this.newRow.getCells().add(i, InternalDataCell.newEmptyCell());
                ++i;
            }
            this.doInsert(this.newRow, this.insertIndex);
            return Status.OK_STATUS;
        }

        private void doInsert(InternalDataRow newRow, int indexToInsert) {
            InternalTestDataPart.this.input.add(indexToInsert, newRow);
            InternalTestDataPart.this.tableViewer.refresh();
            InternalTestDataPart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newRow));
            InternalTestDataPart.this.table.showItem(InternalTestDataPart.this.table.getItem(indexToInsert));
            InternalTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doInsert(this.newRow, this.insertIndex);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            InternalTestDataPart.this.input.remove(this.insertIndex);
            InternalTestDataPart.this.refresh();
            InternalTestDataPart.this.dirtyable.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class OperationData {
        private int columnIndex;
        private InternalDataCell cellData;

        public OperationData(int columnIndex, InternalDataCell cellData) {
            this.columnIndex = columnIndex;
            this.cellData = cellData;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public InternalDataCell getCellData() {
            return this.cellData;
        }
    }

    private class RenameColumnOperation
    extends AbstractOperation {
        private TableColumn selectedColumn;
        private String newName;
        private String oldName;

        public RenameColumnOperation(TableColumn selectedColumn, String newName) {
            super(RenameColumnOperation.class.getName());
            this.selectedColumn = selectedColumn;
            this.newName = newName;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldName = this.selectedColumn.getText();
            return this.redo(monitor, info);
        }

        private void doRename(String columnName) {
            InternalTestDataPart.this.table.setRedraw(false);
            this.selectedColumn.setText(columnName);
            InternalTestDataPart.this.table.setRedraw(true);
            InternalTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doRename(this.newName);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doRename(this.oldName);
            return Status.OK_STATUS;
        }
    }
}

