/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.control.ImageButton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.testdata.constants.ImageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.composer.testdata.parts.TestDataMainPart;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.core.testdata.CSVData;
import com.kms.katalon.core.testdata.reader.CSVSeparator;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.DataFilePropertyInputEntity;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CSVTestDataPart
extends TestDataMainPart {
    private static final String[] FILTER_NAMES = new String[]{"Comma Separated Values Files (*.csv)", "All Files (*.*)"};
    private static final String[] FILTER_EXTS = new String[]{"*.csv", "*.*"};
    private TableViewer tableViewer;
    private Text txtFileName;
    private Button chckIsRelativePath;
    private Button chckEnableHeader;
    private Button btnBrowse;
    private Label lblSeperator;
    private Combo cbSeperator;
    private Composite compositeFileInfo;
    private Composite compositeFileInfoDetails;
    private Composite compositeFileInfoHeader;
    private Composite compositeTable;
    private ImageButton btnExpandFileInfoComposite;
    private Label lblFileInfo;
    private boolean isFileInfoExpanded;
    private boolean enableToReload;
    private String fCurrentFilePath;
    private String fSelectedSeperator;
    @Inject
    private EPartService partService;
    @Inject
    private UISynchronize sync;
    private Listener layoutFileInfoCompositeListener = new Listener(){

        public void handleEvent(Event event) {
            CSVTestDataPart.this.layoutFileInfoComposite();
        }
    };
    private Label lblFileInfoStatus;

    @Override
    @PostConstruct
    public void createControls(Composite parent, MPart mpart) {
        this.enableToReload = true;
        this.fCurrentFilePath = "";
        this.fSelectedSeperator = CSVSeparator.COMMA.toString();
        new HelpToolBarForMPart(mpart, DocumentationMessageConstants.TEST_DATA_CSV);
        super.createControls(parent, mpart);
    }

    @Override
    protected Composite createFileInfoPart(Composite parent) {
        this.compositeFileInfo = new Composite(parent, 0);
        this.compositeFileInfo.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout glCompositeFileInfo = new GridLayout(1, true);
        glCompositeFileInfo.marginWidth = 0;
        glCompositeFileInfo.marginHeight = 0;
        this.compositeFileInfo.setLayout((Layout)glCompositeFileInfo);
        this.compositeFileInfo.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.compositeFileInfoHeader = new Composite(this.compositeFileInfo, 0);
        this.compositeFileInfoHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeFileInfoHeader = new GridLayout(3, false);
        glCompositeFileInfoHeader.marginWidth = 0;
        glCompositeFileInfoHeader.marginHeight = 0;
        this.compositeFileInfoHeader.setLayout((Layout)glCompositeFileInfoHeader);
        this.compositeFileInfoHeader.setCursor(this.compositeFileInfoHeader.getDisplay().getSystemCursor(21));
        this.btnExpandFileInfoComposite = new ImageButton(this.compositeFileInfoHeader, 0);
        this.lblFileInfo = new Label(this.compositeFileInfoHeader, 0);
        this.lblFileInfo.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblFileInfo.setText(StringConstants.PA_LBL_FILE_INFO);
        ControlUtils.setFontToBeBold((Control)this.lblFileInfo);
        this.lblFileInfoStatus = new Label(this.compositeFileInfoHeader, 0);
        GridData gd_lblFileInfoStatus = new GridData(4, 4, true, false, 1, 1);
        gd_lblFileInfoStatus.horizontalIndent = 5;
        this.lblFileInfoStatus.setLayoutData((Object)gd_lblFileInfoStatus);
        this.lblFileInfoStatus.setForeground(ColorUtil.getWarningForegroudColor());
        ControlUtils.setFontToBeBold((Control)this.lblFileInfoStatus);
        this.compositeFileInfoDetails = new Composite(this.compositeFileInfo, 0);
        this.compositeFileInfoDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glCompositeFileInfoDetails = new GridLayout(2, true);
        glCompositeFileInfoDetails.marginWidth = 0;
        glCompositeFileInfoDetails.marginHeight = 0;
        glCompositeFileInfoDetails.horizontalSpacing = 30;
        glCompositeFileInfoDetails.marginRight = 40;
        glCompositeFileInfoDetails.marginLeft = 40;
        this.compositeFileInfoDetails.setLayout((Layout)glCompositeFileInfoDetails);
        Composite compositeName = new Composite(this.compositeFileInfoDetails, 0);
        compositeName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glCompositeName = new GridLayout(3, false);
        compositeName.setLayout((Layout)glCompositeName);
        Label lblFileName = new Label(compositeName, 0);
        GridData gdLblFileName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblFileName.widthHint = 70;
        lblFileName.setLayoutData((Object)gdLblFileName);
        lblFileName.setText(StringConstants.PA_LBL_FILE_NAME);
        this.txtFileName = new Text(compositeName, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.heightHint = 18;
        this.txtFileName.setLayoutData((Object)gridData);
        this.txtFileName.setEditable(false);
        this.btnBrowse = new Button(compositeName, 0x800000);
        this.btnBrowse.setText(StringConstants.PA_BTN_BROWSE);
        Composite compositeSeperator = new Composite(this.compositeFileInfoDetails, 0);
        compositeSeperator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glCompositeSeperator = new GridLayout(2, false);
        compositeSeperator.setLayout((Layout)glCompositeSeperator);
        this.lblSeperator = new Label(compositeSeperator, 0);
        GridData gdLabelSeperator = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLabelSeperator.widthHint = 70;
        this.lblSeperator.setLayoutData((Object)gdLabelSeperator);
        this.lblSeperator.setText(StringConstants.PA_LBL_SEPARATOR);
        this.cbSeperator = new Combo(compositeSeperator, 8);
        this.cbSeperator.setItems(CSVSeparator.stringValues());
        this.cbSeperator.select(0);
        this.cbSeperator.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeCheckBoxes = new Composite(this.compositeFileInfoDetails, 0);
        compositeCheckBoxes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout glCompositeCheckBoxes = new GridLayout(2, false);
        glCompositeCheckBoxes.horizontalSpacing = 15;
        compositeCheckBoxes.setLayout((Layout)glCompositeCheckBoxes);
        this.chckEnableHeader = new Button(compositeCheckBoxes, 32);
        this.chckEnableHeader.setText(StringConstants.PA_CHKBOX_USE_FIRST_ROW_AS_HEADER);
        this.chckIsRelativePath = new Button(compositeCheckBoxes, 32);
        this.chckIsRelativePath.setText(StringConstants.PA_CHKBOX_USE_RELATIVE_PATH);
        new Label(compositeCheckBoxes, 0);
        this.isFileInfoExpanded = true;
        this.redrawBtnExpandFileInfo();
        return this.compositeFileInfo;
    }

    @Override
    protected Composite createDataTablePart(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compositeTable = new Composite(parent, 2048);
        GridLayout glTableComposite = new GridLayout(1, true);
        glTableComposite.marginWidth = 0;
        glTableComposite.marginHeight = 0;
        this.compositeTable.setLayout((Layout)glTableComposite);
        this.compositeTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(this.compositeTable, 0x10010000);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setLinesVisible(true);
        TableViewerColumn tbvclmnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tbclmnNo = tbvclmnNo.getColumn();
        tbclmnNo.setText(StringConstants.NO_);
        tbclmnNo.setWidth(40);
        tbvclmnNo.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                int order = CSVTestDataPart.this.tableViewer.getTable().indexOf((TableItem)cell.getItem()) + 1;
                cell.setText(Integer.toString(order));
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addControlModifyListeners();
        return this.compositeTable;
    }

    private void addControlModifyListeners() {
        this.btnExpandFileInfoComposite.addListener(3, this.layoutFileInfoCompositeListener);
        this.lblFileInfo.addListener(3, this.layoutFileInfoCompositeListener);
        this.lblFileInfoStatus.addListener(3, this.layoutFileInfoCompositeListener);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(CSVTestDataPart.this.btnBrowse.getShell());
                dialog.setFilterNames(FILTER_NAMES);
                dialog.setFilterExtensions(FILTER_EXTS);
                dialog.setFilterPath(CSVTestDataPart.this.getProjectFolderLocation());
                CSVTestDataPart.this.executeOperation((IUndoableOperation)new ChangeCSVFileOperation(dialog.open()));
                CSVTestDataPart.this.enableRelativePath();
            }
        });
        this.cbSeperator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVTestDataPart.this.executeOperation((IUndoableOperation)new ChangeSeparatorOperation(CSVTestDataPart.this.cbSeperator.getText()));
            }
        });
        this.chckEnableHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVTestDataPart.this.executeOperation((IUndoableOperation)new ChangeUseFirstRowAsHeaderOperation(CSVTestDataPart.this.chckEnableHeader.getSelection()));
            }
        });
        this.chckIsRelativePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVTestDataPart.this.executeOperation((IUndoableOperation)new ChangeUseRelativePathOperation(CSVTestDataPart.this.chckIsRelativePath.getSelection()));
            }
        });
    }

    private void layoutFileInfoComposite() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                CSVTestDataPart.this.isFileInfoExpanded = !CSVTestDataPart.this.isFileInfoExpanded;
                CSVTestDataPart.this.compositeFileInfoDetails.setVisible(CSVTestDataPart.this.isFileInfoExpanded);
                if (!CSVTestDataPart.this.isFileInfoExpanded) {
                    ((GridData)((CSVTestDataPart)CSVTestDataPart.this).compositeFileInfoDetails.getLayoutData()).exclude = true;
                    CSVTestDataPart.this.compositeFileInfo.setSize(((CSVTestDataPart)CSVTestDataPart.this).compositeFileInfo.getSize().x, ((CSVTestDataPart)CSVTestDataPart.this).compositeFileInfo.getSize().y - ((CSVTestDataPart)CSVTestDataPart.this).compositeTable.getSize().y);
                } else {
                    ((GridData)((CSVTestDataPart)CSVTestDataPart.this).compositeFileInfoDetails.getLayoutData()).exclude = false;
                }
                CSVTestDataPart.this.compositeFileInfo.layout(true, true);
                CSVTestDataPart.this.compositeFileInfo.getParent().layout();
                CSVTestDataPart.this.redrawBtnExpandFileInfo();
            }
        });
    }

    private void redrawBtnExpandFileInfo() {
        this.btnExpandFileInfoComposite.getParent().setRedraw(false);
        if (this.isFileInfoExpanded) {
            this.btnExpandFileInfoComposite.setImage(ImageConstants.IMG_16_ARROW_DOWN);
        } else {
            this.btnExpandFileInfoComposite.setImage(ImageConstants.IMG_16_ARROW);
        }
        this.btnExpandFileInfoComposite.getParent().setRedraw(true);
    }

    private void loadTestData(DataFileEntity dataFile) {
        if (!this.enableToReload) {
            return;
        }
        this.fCurrentFilePath = dataFile.getDataSourceUrl();
        this.txtFileName.setText(this.fCurrentFilePath);
        if (dataFile.getCsvSeperator() != null) {
            this.fSelectedSeperator = dataFile.getCsvSeperator();
            this.cbSeperator.setText(this.fSelectedSeperator);
        }
        this.chckEnableHeader.setSelection(dataFile.isContainsHeaders());
        this.chckIsRelativePath.setSelection(dataFile.getIsInternalPath());
        if (this.cbSeperator.getText() != null && !this.cbSeperator.getText().isEmpty()) {
            this.loadCSVDataToTable();
        }
    }

    private boolean validateTestDataInfo() throws Exception {
        File filePath;
        return this.cbSeperator.getText() != null && !this.cbSeperator.getText().isEmpty() && this.txtFileName.getText() != null && (filePath = new File(this.getSourceUrlAbsolutePath())).isFile();
    }

    private void clearTable() {
        Table table = this.tableViewer.getTable();
        while (table.getColumnCount() > 1) {
            table.getColumns()[1].dispose();
        }
        table.clearAll();
        this.tableViewer.setItemCount(0);
        table.setHeaderVisible(false);
    }

    private String getSourceUrlAbsolutePath() throws Exception {
        String sourceUrl = this.txtFileName.getText();
        if (this.chckIsRelativePath.getSelection()) {
            sourceUrl = PathUtil.relativeToAbsolutePath((String)sourceUrl, (String)this.getProjectFolderLocation());
        }
        return sourceUrl;
    }

    private void warnFileToLarge() {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)MessageFormat.format(StringConstants.PA_FILE_TOO_LARGE, 100));
            }
        });
    }

    private void loadCSVDataToTable() {
        try {
            try {
                this.tableViewer.getTable().setRedraw(false);
                this.clearTable();
                if (this.validateTestDataInfo()) {
                    TableViewerColumn column;
                    String fileName = this.getSourceUrlAbsolutePath();
                    CSVSeparator separator = CSVSeparator.fromValue((String)this.cbSeperator.getText());
                    CSVData csvData = new CSVData(fileName, this.chckEnableHeader.getSelection(), separator);
                    int columnNumbers = csvData.getColumnNumbers();
                    if (columnNumbers > 100) {
                        this.warnFileToLarge();
                        columnNumbers = 100;
                    }
                    int i = 0;
                    while (i < columnNumbers) {
                        final int idx = i++;
                        column = new TableViewerColumn(this.tableViewer, 0);
                        column.getColumn().setWidth(200);
                        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                            public String getText(Object element) {
                                List rowData;
                                if (element instanceof List && (rowData = (List)element).size() > idx) {
                                    return (String)rowData.get(idx);
                                }
                                return "";
                            }
                        });
                    }
                    int numEmptyHeader = 0;
                    int tableColumnIdx = 1;
                    while (tableColumnIdx < this.tableViewer.getTable().getColumnCount()) {
                        column = this.tableViewer.getTable().getColumns()[tableColumnIdx];
                        String header = csvData.getColumnNames()[tableColumnIdx - 1];
                        if (StringUtils.isBlank((String)header)) {
                            ++numEmptyHeader;
                            header = "";
                            column.setImage(ImageConstants.IMG_16_WARN_TABLE_ITEM);
                            column.setToolTipText(StringConstants.PA_TOOLTIP_WARNING_COLUMN_HEADER);
                        }
                        column.setText(header);
                        ++tableColumnIdx;
                    }
                    if (numEmptyHeader > 0 && this.chckEnableHeader.getSelection()) {
                        this.lblFileInfoStatus.setText(MessageFormat.format(StringConstants.PA_LBL_WARNING_COLUMN_HEADER, numEmptyHeader, columnNumbers));
                    }
                    this.tableViewer.setInput((Object)csvData.getData());
                }
                this.tableViewer.getTable().setHeaderVisible(this.chckEnableHeader.getSelection());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                this.tableViewer.getTable().setRedraw(true);
            }
        }
        finally {
            this.tableViewer.getTable().setRedraw(true);
        }
    }

    @Persist
    public void save() {
        try {
            try {
                this.enableToReload = false;
                this.originalDataFile = this.updateDataFileProperty(this.originalDataFile.getLocation(), this.originalDataFile.getName(), this.originalDataFile.getDescription(), DataFileEntity.DataFileDriverType.CSV, this.txtFileName.getText(), this.chckEnableHeader.getSelection(), this.cbSeperator.getText(), this.chckIsRelativePath.getSelection());
                this.updateDataFile(this.originalDataFile);
                this.dirtyable.setDirty(false);
                this.refreshTreeEntity();
                this.sendTestDataUpdatedEvent(this.originalDataFile.getId());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_TEST_DATA, (String)e.getClass().getSimpleName());
                this.enableToReload = true;
            }
        }
        finally {
            this.enableToReload = true;
        }
    }

    public DataFileEntity updateDataFileProperty(String pk, String name, String description, DataFileEntity.DataFileDriverType dataFileDriver, String dataSourceURL, boolean hasHeaders, String csvSeperator, boolean isInternalPath) throws Exception {
        DataFilePropertyInputEntity dataFileInputPro = new DataFilePropertyInputEntity();
        dataFileInputPro.setPk(pk);
        dataFileInputPro.setName(name);
        dataFileInputPro.setDescription(description);
        dataFileInputPro.setDataFileDriver(dataFileDriver.name());
        dataFileInputPro.setdataSourceURL(dataSourceURL);
        dataFileInputPro.setEnableHeader(hasHeaders);
        dataFileInputPro.setCsvSeperator(csvSeperator);
        dataFileInputPro.setIsInternalPath(isInternalPath);
        DataFileEntity dataFileEntity = TestDataController.getInstance().updateDataFile(dataFileInputPro);
        return dataFileEntity;
    }

    private String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation();
    }

    @Override
    protected void updateChildInfo(DataFileEntity dataFile) {
        this.loadTestData(dataFile);
        this.enableRelativePath();
    }

    private void enableRelativePath() {
        this.chckIsRelativePath.setEnabled(StringUtils.isNotBlank((String)this.txtFileName.getText()));
    }

    @Override
    protected EPartService getPartService() {
        return this.partService;
    }

    private class ChangeCSVFileOperation
    extends AbstractOperation {
        private String oldCSVFilePath;
        private String newCSVFilePath;

        public ChangeCSVFileOperation(String newCSVFilePath) {
            super(ChangeCSVFileOperation.class.getName());
            this.newCSVFilePath = newCSVFilePath;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.newCSVFilePath == null || this.newCSVFilePath.equals(CSVTestDataPart.this.fCurrentFilePath)) {
                return Status.CANCEL_STATUS;
            }
            this.oldCSVFilePath = CSVTestDataPart.this.fCurrentFilePath;
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doLoadExcelFile(this.newCSVFilePath);
            return Status.OK_STATUS;
        }

        private void doLoadExcelFile(String csvFileAbsolutePath) {
            CSVTestDataPart.this.lblFileInfoStatus.setText("");
            CSVTestDataPart.this.fCurrentFilePath = csvFileAbsolutePath;
            if (CSVTestDataPart.this.chckIsRelativePath.getSelection()) {
                CSVTestDataPart.this.txtFileName.setText(PathUtil.absoluteToRelativePath((String)csvFileAbsolutePath, (String)CSVTestDataPart.this.getProjectFolderLocation()));
            } else {
                CSVTestDataPart.this.txtFileName.setText(CSVTestDataPart.this.fCurrentFilePath);
            }
            CSVTestDataPart.this.loadCSVDataToTable();
            CSVTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doLoadExcelFile(this.oldCSVFilePath);
            return Status.OK_STATUS;
        }
    }

    private class ChangeSeparatorOperation
    extends AbstractOperation {
        private String oldSeparator;
        private String newSeparator;

        public ChangeSeparatorOperation(String newSeparator) {
            super(ChangeSeparatorOperation.class.getName());
            this.newSeparator = newSeparator;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.newSeparator.equals(CSVTestDataPart.this.fSelectedSeperator)) {
                return Status.CANCEL_STATUS;
            }
            this.oldSeparator = CSVTestDataPart.this.fSelectedSeperator.isEmpty() ? CSVSeparator.COMMA.toString().toUpperCase() : CSVTestDataPart.this.fSelectedSeperator;
            this.doSetSeparator(this.newSeparator);
            return Status.OK_STATUS;
        }

        private void doSetSeparator(String separator) {
            CSVTestDataPart.this.fSelectedSeperator = separator;
            CSVTestDataPart.this.cbSeperator.setText(CSVTestDataPart.this.fSelectedSeperator);
            CSVTestDataPart.this.lblFileInfoStatus.setText("");
            CSVTestDataPart.this.loadCSVDataToTable();
            CSVTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doSetSeparator(this.newSeparator);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doSetSeparator(this.oldSeparator);
            return Status.OK_STATUS;
        }
    }

    private class ChangeUseFirstRowAsHeaderOperation
    extends AbstractOperation {
        boolean oldCheckedValue;

        public ChangeUseFirstRowAsHeaderOperation(boolean oldCheckedValue) {
            super(ChangeUseFirstRowAsHeaderOperation.class.getName());
            this.oldCheckedValue = oldCheckedValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(this.oldCheckedValue);
            return Status.OK_STATUS;
        }

        private void doChangeCheckValue(boolean isSelected) {
            CSVTestDataPart.this.chckEnableHeader.setSelection(isSelected);
            CSVTestDataPart.this.loadCSVDataToTable();
            CSVTestDataPart.this.dirtyable.setDirty(true);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(!this.oldCheckedValue);
            return Status.OK_STATUS;
        }
    }

    private class ChangeUseRelativePathOperation
    extends AbstractOperation {
        boolean oldCheckedValue;

        public ChangeUseRelativePathOperation(boolean oldCheckedValue) {
            super(ChangeUseRelativePathOperation.class.getName());
            this.oldCheckedValue = oldCheckedValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(this.oldCheckedValue);
            return Status.OK_STATUS;
        }

        private void doChangeCheckValue(boolean isSelected) {
            CSVTestDataPart.this.chckIsRelativePath.setSelection(isSelected);
            CSVTestDataPart.this.dirtyable.setDirty(true);
            if (CSVTestDataPart.this.txtFileName.getText() == null) {
                return;
            }
            String sourceUrl = CSVTestDataPart.this.txtFileName.getText();
            if (isSelected) {
                CSVTestDataPart.this.txtFileName.setText(PathUtil.absoluteToRelativePath((String)sourceUrl, (String)CSVTestDataPart.this.getProjectFolderLocation()));
            } else {
                CSVTestDataPart.this.txtFileName.setText(PathUtil.relativeToAbsolutePath((String)sourceUrl, (String)CSVTestDataPart.this.getProjectFolderLocation()));
            }
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.doChangeCheckValue(!this.oldCheckedValue);
            return Status.OK_STATUS;
        }
    }
}

