/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.job;

import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.core.testdata.ExcelData;
import com.kms.katalon.core.testdata.reader.ExcelFactory;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class LoadExcelFileJob
extends Job {
    private String sourceUrl;
    private boolean hasHeaders;
    private ExcelData excelData;

    public LoadExcelFileJob(String sourceUrl, boolean hasHeaders) {
        super(StringConstants.JOB_LOAD_EXCL_TITLE);
        this.sourceUrl = sourceUrl;
        this.hasHeaders = hasHeaders;
        this.excelData = null;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(StringConstants.JOB_LOAD_EXCL_TASK_NAME, -1);
            this.excelData = ExcelFactory.getExcelData((String)this.sourceUrl, (boolean)this.hasHeaders);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (IOException iOException) {
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public ExcelData getExcelData() {
        return this.excelData;
    }
}

