/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestDataHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestDataTreeEntity) {
                    RenameTestDataHandler.this.execute((TestDataTreeEntity)object);
                }
            }
        });
    }

    private void execute(TestDataTreeEntity testDataTreeEntity) {
        block5: {
            try {
                if (!(testDataTreeEntity.getObject() instanceof DataFileEntity)) break block5;
                DataFileEntity testData = testDataTreeEntity.getObject();
                List existingNames = FolderController.getInstance().getChildrenNames(testData.getParentFolder());
                RenameWizard renameWizard = new RenameWizard((ITreeEntity)testDataTreeEntity, existingNames);
                CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
                int code = wizardDialog.open();
                if (code != 0) break block5;
                String oldName = testData.getName();
                String pk = testData.getId();
                String oldIdForDisplay = testData.getIdForDisplay();
                try {
                    if (renameWizard.getNewNameValue() != null && !renameWizard.getNewNameValue().isEmpty() && !renameWizard.getNewNameValue().equals(oldName)) {
                        testData = TestDataController.getInstance().renameDataFile(testData, renameWizard.getNewNameValue());
                        testDataTreeEntity.setObject((Object)testData);
                        String newIdForDisplay = testData.getIdForDisplay();
                        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, newIdForDisplay});
                        this.partService.saveAll(false);
                    }
                }
                catch (Exception ex) {
                    testData.setName(oldName);
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_TEST_DATA);
                    return;
                }
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testDataTreeEntity.getParent());
                Object[] objectArray = new Object[3];
                objectArray[0] = pk;
                objectArray[1] = testData;
                this.eventBroker.post("TESTDATA/UPDATE", (Object)objectArray);
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)testDataTreeEntity);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

