/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.report;

import com.katalon.platform.api.report.LogRecord;
import com.katalon.platform.api.report.LogStatus;
import com.katalon.platform.api.report.TestCaseRecord;
import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.platform.internal.report.TestStepRecordImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TestCaseRecordImpl
implements TestCaseRecord {
    private TestCaseLogRecord source;
    private List<LogRecord> childRecords;

    public TestCaseRecordImpl(TestCaseLogRecord source) {
        this.source = source;
    }

    public String getName() {
        return this.source.getName();
    }

    public String getDescription() {
        return this.source.getDescription();
    }

    public String getMessage() {
        return this.source.getMessage();
    }

    public long getStartTime() {
        return this.source.getStartTime();
    }

    public long getEndTime() {
        return this.source.getEndTime();
    }

    public LogStatus getLogStatus() {
        return LogStatus.valueOf((String)this.source.getStatus().getStatusValue().name());
    }

    public String getStackTrace() {
        TestStatus sourceStatus = this.source.getStatus();
        return sourceStatus != null ? sourceStatus.getStackTrace() : "";
    }

    public String getTestCaseId() {
        return this.source.getId();
    }

    public List<LogRecord> getChildRecords() {
        if (this.source.getChildRecords() == null) {
            return Collections.emptyList();
        }
        if (this.childRecords == null) {
            this.childRecords = Arrays.asList(this.source.getChildRecords()).stream().filter(child -> child instanceof AbstractLogRecord).map(child -> new TestStepRecordImpl((AbstractLogRecord)child)).map(record -> record).collect(Collectors.toList());
        }
        return this.childRecords;
    }

    public List<String> getAttachments() {
        return Arrays.asList(this.source.getAttachments());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestCaseRecordImpl)) {
            return false;
        }
        TestCaseRecordImpl that = (TestCaseRecordImpl)obj;
        return this.source.equals(that.source);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }
}

