/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.internal.console;

import com.katalon.platform.api.controller.TestCaseController;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.extension.LauncherOptionParserDescription;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.LauncherOptionParser;
import com.kms.katalon.execution.console.entity.TestSuiteLauncherOptionParser;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.platform.PlatformLauncherOptionParserBuilder;
import com.kms.katalon.execution.util.ConsoleAdapter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LauncherOptionParserPlatformBuilderImpl
implements PlatformLauncherOptionParserBuilder {
    public LauncherOptionParser getPluginLauncherOptionParser() {
        List<LauncherOptionParserDescription> launcherOptionParserDescriptions = ApplicationManager.getInstance().getExtensionManager().getExtensions("com.katalon.platform.api.extension.launcherOptionParserDescription").stream().filter(a -> a.getImplementationClass() instanceof LauncherOptionParserDescription).map(b -> (LauncherOptionParserDescription)b.getImplementationClass()).collect(Collectors.toList());
        if (launcherOptionParserDescriptions != null && !launcherOptionParserDescriptions.isEmpty()) {
            return new PluginTestSuiteLauncherOptionParser(launcherOptionParserDescriptions);
        }
        return new TestSuiteLauncherOptionParser();
    }

    public class PluginTestSuiteLauncherOptionParser
    extends TestSuiteLauncherOptionParser {
        private List<LauncherOptionParserDescription> pluginLauncherOptionParserDescriptions;

        public PluginTestSuiteLauncherOptionParser(List<LauncherOptionParserDescription> pluginLauncherOptionParserDescriptions) {
            this.pluginLauncherOptionParserDescriptions = pluginLauncherOptionParserDescriptions;
        }

        public List<ConsoleOption<?>> getConsoleOptionList() {
            List allOptions = super.getConsoleOptionList();
            allOptions.addAll(this.pluginLauncherOptionParserDescriptions.stream().map(a -> a.getConsoleOptionList()).map(b -> ConsoleAdapter.adapt((List)b)).flatMap(Collection::stream).collect(Collectors.toList()));
            return allOptions;
        }

        public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
            super.setArgumentValue(consoleOption, argumentValue);
            Optional<LauncherOptionParserDescription> matched = this.pluginLauncherOptionParserDescriptions.stream().filter(b -> b.getConsoleOptionList().stream().map(c -> c.getOption()).collect(Collectors.toList()).contains(consoleOption.getOption())).findFirst();
            if (matched.isPresent()) {
                consoleOption.setValue(argumentValue);
                matched.get().onConsoleOptionDetected(ConsoleAdapter.adapt(consoleOption));
            }
        }

        public IConsoleLauncher getConsoleLauncher(ProjectEntity project, LauncherManager manager) throws InvalidConsoleArgumentException, ExecutionException {
            try {
                ExecutionProfileEntity executionProfile;
                TestSuiteEntity clonedTestSuite = TestSuiteLauncherOptionParser.getTestSuite((ProjectEntity)project, (String)((String)this.testSuitePathOption.getValue())).clone();
                clonedTestSuite = this.preExecution(clonedTestSuite);
                TestSuiteExecutedEntity executedEntity = new TestSuiteExecutedEntity(clonedTestSuite);
                executedEntity.setReportLocation(this.reportableSetting.getReportLocationSetting());
                executedEntity.setEmailConfig(this.reportableSetting.getEmailConfig(project));
                executedEntity.setRerunSetting(this.rerunSetting);
                if (this.testSuiteQuery.getValue() == null) {
                    executedEntity.prepareTestCases();
                } else {
                    executedEntity.prepareTestCasesWithTestSuiteQuery((String)this.testSuiteQuery.getValue());
                }
                AbstractRunConfiguration runConfig = (AbstractRunConfiguration)this.createRunConfiguration(project, clonedTestSuite, (String)this.browserTypeOption.getValue());
                String profileName = (String)this.executionProfileOption.getValue();
                if (StringUtils.isBlank((CharSequence)profileName)) {
                    profileName = "default";
                }
                if ((executionProfile = GlobalVariableController.getInstance().getExecutionProfile(profileName, project)) == null) {
                    throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.CONSOLE_MSG_PROFILE_NOT_FOUND, profileName));
                }
                runConfig.setExecutionProfile(executionProfile);
                runConfig.setOverridingGlobalVariables(this.getOverridingGlobalVariables());
                runConfig.build((FileEntity)clonedTestSuite, (IExecutedEntity)executedEntity);
                return new ConsoleLauncher(manager, (IRunConfiguration)runConfig);
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        private TestSuiteEntity preExecution(TestSuiteEntity testSuite) {
            if (testSuite instanceof FilteringTestSuiteEntity) {
                return testSuite;
            }
            TestCaseController testCaseController = (TestCaseController)ApplicationManager.getInstance().getControllerManager().getController(TestCaseController.class);
            com.katalon.platform.api.model.ProjectEntity currentProject = ApplicationManager.getInstance().getProjectManager().getCurrentProject();
            List testCases = testSuite.getTestSuiteTestCaseLinks().stream().map(a -> a.getTestCaseId()).map(b -> {
                try {
                    return testCaseController.getTestCase(currentProject, b);
                }
                catch (ResourceException e) {
                    LoggerSingleton.logError((Throwable)e);
                    return null;
                }
            }).filter(c -> c != null).collect(Collectors.toList());
            List listOfSetsOfTestCases = this.pluginLauncherOptionParserDescriptions.stream().map(a -> a.onPreExecution(testCases)).map(b -> new HashSet(b)).collect(Collectors.toList());
            Set intersection = listOfSetsOfTestCases.stream().collect(() -> new HashSet((Collection)listOfSetsOfTestCases.get(0)), Set::retainAll, Set::retainAll).stream().map(b -> b.getId()).collect(Collectors.toSet());
            testSuite.setTestSuiteTestCaseLinks(testSuite.getTestSuiteTestCaseLinks().stream().filter(a -> intersection.contains(a.getTestCaseId())).collect(Collectors.toList()));
            return testSuite;
        }
    }
}

