/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ansiconsole.listeners;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;

public class HarLinkyConsolePatternMatchListenerDelegate
implements IPatternMatchListenerDelegate {
    private static final String HAR = "HAR: ";
    private static final String HAR_EXTENSION = ".har";
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            String harLog = this.console.getDocument().get(event.getOffset(), event.getLength());
            String harFilePath = String.valueOf(harLog.substring(HAR.length() - 1, harLog.lastIndexOf(HAR_EXTENSION))) + HAR_EXTENSION;
            harFilePath = harFilePath.trim();
            int harFilePathOffset = event.getOffset() + HAR.length();
            IHyperlink hyperlink = HarLinkyConsolePatternMatchListenerDelegate.makeHyperlink(harFilePath);
            this.console.addHyperlink(hyperlink, harFilePathOffset, harFilePath.length());
        }
        catch (BadLocationException badLocationException) {}
    }

    private static IHyperlink makeHyperlink(final String harFilePath) {
        return new IHyperlink(){

            public void linkExited() {
            }

            public void linkEntered() {
            }

            public void linkActivated() {
                Trackings.trackClickHarLink();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)EFS.getStore((URI)new File(harFilePath).toURI()));
                }
                catch (Exception exception) {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)"Unable to open HAR file", (String)exception.getClass().getSimpleName());
                }
            }
        };
    }
}

