/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.op.RenameBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BranchRenameDialog
extends TitleAreaDialog {
    private final Repository repository;
    private final Ref branchToRename;
    private Text name;
    private String newName;

    public BranchRenameDialog(Shell parentShell, Repository repository, Ref branchToRename) {
        super(parentShell);
        this.repository = repository;
        this.branchToRename = branchToRename;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(main);
        new Label(main, 0).setText(UIText.BranchRenameDialog_NewNameLabel);
        this.name = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name);
        return main;
    }

    public void create() {
        super.create();
        this.setTitle(UIText.BranchRenameDialog_Title);
        String oldName = this.branchToRename.getName();
        String prefix = oldName.startsWith("refs/heads/") ? "refs/heads/" : (oldName.startsWith("refs/remotes/") ? "refs/remotes/" : null);
        String shortName = null;
        if (prefix != null) {
            shortName = Repository.shortenRefName((String)this.branchToRename.getName());
            this.setMessage(NLS.bind((String)UIText.BranchRenameDialog_Message, (Object)shortName));
        } else {
            this.setErrorMessage(NLS.bind((String)UIText.BranchRenameDialog_WrongPrefixErrorMessage, (Object)oldName));
        }
        if (shortName != null) {
            this.name.setText(shortName);
            this.name.setSelection(0, shortName.length());
        }
        final IInputValidator inputValidator = ValidationUtils.getRefNameInputValidator(this.repository, prefix, true);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String error = inputValidator.isValid(BranchRenameDialog.this.name.getText());
                BranchRenameDialog.this.setErrorMessage(error);
                BranchRenameDialog.this.getButton(0).setEnabled(error == null);
            }
        });
        this.getButton(0).setEnabled(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.BranchRenameDialog_WindowTitle);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                this.newName = this.name.getText();
                new RenameBranchOperation(this.repository, this.branchToRename, this.newName).execute(null);
            }
            catch (CoreException e) {
                Activator.handleError(UIText.BranchRenameDialog_RenameExceptionMessage, e, true);
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public String getNewName() {
        return this.newName;
    }
}

