/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.parts;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.parts.CheckpointAbstractPart;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.providers.EntityLabelProvider;
import com.kms.katalon.composer.explorer.providers.EntityProvider;
import com.kms.katalon.composer.explorer.providers.EntityViewerFilter;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.osgi.framework.FrameworkUtil;

public class CheckpointTestDataPart
extends CheckpointAbstractPart {
    private Button btnBrowse;
    private FormText txtTestDataLink;
    private String pluginId = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();

    @Override
    protected Composite createSourceInfoPartDetails(Composite parent) {
        this.compSourceInfoDetails = new Composite(parent, 0);
        GridLayout glCompositeSrcInfoDetails = new GridLayout(4, false);
        glCompositeSrcInfoDetails.marginWidth = 0;
        glCompositeSrcInfoDetails.marginHeight = 0;
        this.compSourceInfoDetails.setLayout((Layout)glCompositeSrcInfoDetails);
        this.compSourceInfoDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSourceUrl = new Label(this.compSourceInfoDetails, 0);
        lblSourceUrl.setText(StringConstants.TEST_DATA);
        this.txtTestDataLink = new FormText(this.compSourceInfoDetails, 2048);
        this.txtTestDataLink.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnBrowse = new Button(this.compSourceInfoDetails, 0x800008);
        this.btnBrowse.setText(StringConstants.BROWSE);
        this.btnBrowse.setLayoutData((Object)new GridData(131072, 4, false, true));
        return parent;
    }

    @Override
    protected void addSourceInfoConstrolListeners() {
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointTestDataPart.this.executeOperation((IUndoableOperation)new ChangeTestDataOperation());
            }
        });
        this.txtTestDataLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    DataFileEntity testData = TestDataController.getInstance().getTestDataByDisplayId(e.getLabel());
                    CheckpointTestDataPart.this.eventBroker.post("TESTDATA/OPEN", (Object)testData);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
    }

    @Override
    protected void loadCheckpointSourceInfo(CheckpointSourceInfo sourceInfo) {
        this.setTestDataLinkText(sourceInfo.getSourceUrl());
    }

    private void setTestDataLinkText(String testDataLink) {
        if (testDataLink == null) {
            return;
        }
        this.txtTestDataLink.setText("<form><p><a>" + testDataLink + "</a></p></form>", true, false);
    }

    @Override
    protected String getDocumentationUrl() {
        return DocumentationMessageConstants.CHECKPOINT_EXISTING_DATA;
    }

    private class ChangeTestDataOperation
    extends CheckpointAbstractPart.ChangeCheckpointSourceInfoOperation {
        public ChangeTestDataOperation() {
            super(ChangeTestDataOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                CheckpointEntity checkpoint = CheckpointTestDataPart.this.getCheckpoint();
                CheckpointSourceInfo currentCheckpointSourceInfo = checkpoint.getSourceInfo();
                this.oldCheckpointSourceInfo = currentCheckpointSourceInfo.clone();
                DataFileEntity testData = this.openDialogForSelectingTestData(currentCheckpointSourceInfo);
                if (testData == null) {
                    return Status.CANCEL_STATUS;
                }
                currentCheckpointSourceInfo.setSourceUrl(testData.getIdForDisplay());
                this.newCheckpointSourceInfo = currentCheckpointSourceInfo.clone();
                CheckpointTestDataPart.this.loadCheckpointSourceInfo(currentCheckpointSourceInfo);
                CheckpointTestDataPart.this.setDirty(true);
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN, (String)StringConstants.PART_MSG_UNABLE_TO_SELECT_TEST_DATA);
                return Status.CANCEL_STATUS;
            }
        }

        private DataFileEntity openDialogForSelectingTestData(CheckpointSourceInfo currentCheckpointSourceInfo) throws Exception {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject == null) {
                return null;
            }
            FolderEntity rootFolder = FolderController.getInstance().getTestDataRoot(currentProject);
            EntityProvider entityProvider = new EntityProvider();
            TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(CheckpointTestDataPart.this.tableViewer.getTable().getShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)entityProvider, (AbstractEntityViewerFilter)new EntityViewerFilter(entityProvider));
            dialog.setAllowMultiple(false);
            dialog.setTitle(StringConstants.PART_TITLE_TEST_DATA_BROWSER);
            dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)rootFolder));
            String testDataId = currentCheckpointSourceInfo.getSourceUrl();
            if (StringUtils.isNotBlank((String)testDataId)) {
                DataFileEntity testDataEntity = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
                TestDataTreeEntity testDataTreeEntity = TreeEntityUtil.getTestDataTreeEntity((DataFileEntity)testDataEntity, (ProjectEntity)currentProject);
                dialog.setInitialSelection((Object)testDataTreeEntity);
            }
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection == null || selection.length == 0 || !(selection[0] instanceof TestDataTreeEntity)) {
                        return new Status(4, CheckpointTestDataPart.this.pluginId, 4, StringConstants.PART_MSG_PLEASE_SELECT_A_TEST_DATA, null);
                    }
                    return new Status(0, CheckpointTestDataPart.this.pluginId, 0, StringConstants.EMPTY, null);
                }
            });
            if (dialog.open() != 0) {
                return null;
            }
            Object[] selectedItems = dialog.getResult();
            if (selectedItems == null || selectedItems.length == 0 || !(selectedItems[0] instanceof TestDataTreeEntity)) {
                return null;
            }
            DataFileEntity testData = ((TestDataTreeEntity)selectedItems[0]).getObject();
            return testData;
        }
    }
}

