/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.handlers;

import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshCheckpointHandler {
    @Inject
    IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() == null) {
                    return;
                }
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof CheckpointTreeEntity)) {
                    return;
                }
                try {
                    RefreshCheckpointHandler.this.excute((CheckpointTreeEntity)object);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    private void excute(CheckpointTreeEntity checkpointTreeEntity) throws Exception {
        CheckpointEntity checkpoint = checkpointTreeEntity.getObject();
        if (checkpoint != null) {
            FolderController.getInstance().refreshFolder(checkpoint.getParentFolder());
            return;
        }
        FolderTreeEntity parentEntity = checkpointTreeEntity.getParent();
        if (parentEntity instanceof FolderTreeEntity) {
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentEntity);
            return;
        }
        FolderEntity checkpointRootFolder = FolderController.getInstance().getCheckpointRoot(ProjectController.getInstance().getCurrentProject());
        this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)new FolderTreeEntity(checkpointRootFolder, null));
    }
}

