/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.handlers;

import com.kms.katalon.composer.checkpoint.parts.CheckpointCsvPart;
import com.kms.katalon.composer.checkpoint.parts.CheckpointDatabasePart;
import com.kms.katalon.composer.checkpoint.parts.CheckpointExcelPart;
import com.kms.katalon.composer.checkpoint.parts.CheckpointTestDataPart;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenCheckpointHandler {
    private static final String CHECKPOINT_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.checkpoint/";
    private static final String CHECKPOINT_TEST_DATA_PART_URI = "bundleclass://com.kms.katalon.composer.checkpoint/" + CheckpointTestDataPart.class.getName();
    private static final String CHECKPOINT_EXCEL_PART_URI = "bundleclass://com.kms.katalon.composer.checkpoint/" + CheckpointExcelPart.class.getName();
    private static final String CHECKPOINT_CSV_PART_URI = "bundleclass://com.kms.katalon.composer.checkpoint/" + CheckpointCsvPart.class.getName();
    private static final String CHECKPOINT_DATABASE_PART_URI = "bundleclass://com.kms.katalon.composer.checkpoint/" + CheckpointDatabasePart.class.getName();
    @Inject
    MApplication application;
    @Inject
    EPartService partService;
    @Inject
    EModelService modelService;

    @PostConstruct
    public void openCheckpointTreeEntity(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof CheckpointEntity)) {
                    return;
                }
                OpenCheckpointHandler.this.openCheckpointEntity((CheckpointEntity)object);
            }
        });
    }

    @Inject
    @Optional
    public void openCheckpointEntity(@UIEventTopic(value="CHECKPOINT/OPEN") CheckpointEntity checkpoint) {
        try {
            if (checkpoint == null) {
                return;
            }
            String partId = EntityPartUtil.getCheckpointPartId((String)checkpoint.getId());
            MPartStack partStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            MPart part = (MPart)this.modelService.find(partId, (MUIElement)this.application);
            if (part == null) {
                part = (MPart)this.modelService.createModelElement(MPart.class);
                part.setElementId(partId);
                part.setLabel(checkpoint.getName());
                part.setIconURI(ImageConstants.URL_16_CHECKPOINT);
                this.setContributionURI(part, checkpoint.getSourceInfo());
                part.setCloseable(true);
                part.setTooltip(checkpoint.getIdForDisplay());
                partStack.getChildren().add(part);
            }
            if (part.getObject() == null) {
                part.setObject((Object)checkpoint);
            }
            partStack.setSelectedElement((MUIElement)part);
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setContributionURI(MPart part, CheckpointSourceInfo sourceInfo) {
        if (sourceInfo == null) {
            return;
        }
        if (sourceInfo.isFromTestData()) {
            part.setContributionURI(CHECKPOINT_TEST_DATA_PART_URI);
            return;
        }
        switch (sourceInfo.getSourceType()) {
            case ExcelFile: {
                part.setContributionURI(CHECKPOINT_EXCEL_PART_URI);
                break;
            }
            case CSV: {
                part.setContributionURI(CHECKPOINT_CSV_PART_URI);
                break;
            }
            case DBData: {
                part.setContributionURI(CHECKPOINT_DATABASE_PART_URI);
                break;
            }
        }
    }
}

