/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.handlers;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.dialogs.CheckpointReferencesDialog;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityHandler;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class DeleteCheckpointHandler
extends AbstractDeleteReferredEntityHandler {
    public Class<? extends ITreeEntity> entityType() {
        return CheckpointTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (treeEntity == null || !(treeEntity instanceof CheckpointTreeEntity)) {
                return false;
            }
            CheckpointTreeEntity checkpointTreeEntity = (CheckpointTreeEntity)treeEntity;
            monitor.beginTask(MessageFormat.format(StringConstants.HAND_MSG_DELETING_X_Y, checkpointTreeEntity.getTypeName(), checkpointTreeEntity.getText()), 1);
            CheckpointEntity checkpoint = checkpointTreeEntity.getObject();
            String checkpointId = checkpoint.getIdForDisplay();
            List affectedTestCaseScripts = TestArtifactScriptRefactor.createForCheckpointEntity((String)checkpointId).findReferrersInTestCaseScripts(checkpoint.getProject());
            if (this.deleteCheckpoint(checkpoint, affectedTestCaseScripts)) {
                this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)checkpointId);
                return true;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR, (String)StringConstants.HAND_MSG_UNABLE_TO_DELETE_CHECKPOINT);
        }
        finally {
            monitor.done();
        }
        return false;
    }

    protected boolean deleteCheckpoint(final CheckpointEntity checkpoint, final List<IFile> affectedTestCaseScripts) {
        this.isDeleted = false;
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<FileEntity> testCaseRefList = new ArrayList<FileEntity>();
                    testCaseRefList.addAll(TestCaseEntityUtil.getTestCaseEntities((List)affectedTestCaseScripts));
                    if (!testCaseRefList.isEmpty()) {
                        String checkpointId = checkpoint.getIdForDisplay();
                        if (DeleteCheckpointHandler.this.isDefaultResponse()) {
                            CheckpointReferencesDialog dialog = new CheckpointReferencesDialog(Display.getCurrent().getActiveShell(), checkpointId, testCaseRefList, DeleteCheckpointHandler.this.needYesNoToAllButtons());
                            DeleteCheckpointHandler.this.setResponse(dialog.open());
                        }
                        if (DeleteCheckpointHandler.this.isCancelResponse()) {
                            return;
                        }
                        if (DeleteCheckpointHandler.this.isYesResponse()) {
                            TestArtifactScriptRefactor.createForCheckpointEntity((String)checkpointId).removeReferences(affectedTestCaseScripts);
                        }
                    }
                    EntityPartUtil.closePart((IEntity)checkpoint);
                    CheckpointController.getInstance().delete(checkpoint);
                    if (!DeleteCheckpointHandler.this.isYesNoToAllResponse()) {
                        DeleteCheckpointHandler.this.resetResponse();
                    }
                    DeleteCheckpointHandler.this.isDeleted = true;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        return this.isDeleted;
    }
}

