/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs.wizard;

import com.kms.katalon.composer.checkpoint.dialogs.wizard.AbstractCheckpointWizardPage;
import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCheckpointWizardDialog
extends WizardDialog {
    private Text messageLabel;
    private Label messageImageLabel;
    private Point textLocation;
    private static final int DIFF_SIZE = 2;
    private static final int H_GAP_IMAGE = 5;
    private ShellAdapter onShellOpenListener;

    protected Control createContents(Composite parent) {
        Composite content = (Composite)super.createContents(parent);
        this.findMessageControl(content);
        this.getShell().addShellListener((ShellListener)this.onShellOpenListener);
        return content;
    }

    private void findMessageControl(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text) {
                this.messageLabel = (Text)control;
                break;
            }
            ++n2;
        }
        Object layoutData = this.messageLabel.getLayoutData();
        if (layoutData instanceof FormData) {
            this.messageImageLabel = (Label)((FormData)layoutData).left.control;
        }
    }

    public NewCheckpointWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.setShellStyle(0x10060 | NewCheckpointWizardDialog.getDefaultOrientation());
        this.addListeners();
    }

    private void addListeners() {
        this.addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent e) {
                Shell shell = ((WizardDialog)e.getSource()).getShell();
                if (e.getTargetPage() instanceof AbstractCheckpointWizardPage) {
                    Point pageSize = ((AbstractCheckpointWizardPage)((Object)e.getTargetPage())).getPageSize();
                    shell.setSize(pageSize);
                    shell.layout(true, true);
                    return;
                }
                shell.pack(true);
            }
        });
        this.onShellOpenListener = new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                NewCheckpointWizardDialog.this.setTextCenterVerticalWithImage();
            }
        };
    }

    protected Point getInitialSize() {
        IWizardPage startingPage = this.getWizard().getStartingPage();
        if (startingPage instanceof AbstractCheckpointWizardPage) {
            return ((AbstractCheckpointWizardPage)startingPage).getPageSize();
        }
        return super.getInitialSize();
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        this.setTextCenterVerticalWithImage();
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        this.setTextCenterVerticalWithImage();
    }

    private void setTextCenterVerticalWithImage() {
        if (this.messageLabel == null || this.messageImageLabel == null) {
            return;
        }
        if (this.textLocation == null) {
            this.textLocation = this.messageLabel.getLocation();
        }
        this.messageLabel.setLocation(this.messageImageLabel.getLocation().x + 2 + this.messageImageLabel.getBounds().width + 5, this.textLocation.y + 2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        new HelpCompositeForDialog(parent, DocumentationMessageConstants.NEW_CHECKPOINT){

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginBottom = 0;
                return layout;
            }
        };
        super.createButtonsForButtonBar(parent);
    }
}

