/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs.wizard;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.AbstractCheckpointWizardPage;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewCheckpointStartingPage
extends AbstractCheckpointWizardPage {
    private static final String NAME_ALREADY_EXISTS = com.kms.katalon.composer.components.impl.constants.StringConstants.DIA_NAME_EXISTED;
    public static String[] sourceTypeNames = new String[]{StringConstants.TEST_DATA, DataFileEntity.DataFileDriverType.ExcelFile.toString(), DataFileEntity.DataFileDriverType.CSV.toString(), DataFileEntity.DataFileDriverType.DBData.toString()};
    private String name;
    private String typeName = StringConstants.TEST_DATA;
    private String checkpointDescription = StringConstants.EMPTY;
    private FolderEntity parentFolder;
    private Text txtName;
    private Text txtDescription;
    private Combo comboSourceType;

    public NewCheckpointStartingPage(String name, FolderEntity parentFolder) {
        super(NewCheckpointStartingPage.class.getSimpleName(), StringConstants.CHECKPOINT, StringConstants.DIA_MSG_CREATE_CHECKPOINT);
        this.name = name;
        this.parentFolder = parentFolder;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label labelName = new Label(container, 0);
        labelName.setText(StringConstants.NAME);
        this.txtName = new Text(container, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.setText(this.getName());
        this.txtName.selectAll();
        Label labelDataSourceType = new Label(container, 0);
        labelDataSourceType.setText(StringConstants.DIA_LBL_DATA_TYPE);
        this.comboSourceType = new Combo(container, 8);
        this.comboSourceType.setLayoutData((Object)new GridData(768));
        this.comboSourceType.setItems(sourceTypeNames);
        this.comboSourceType.select(0);
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblDescription.setText(StringConstants.DESCRIPTION);
        this.txtDescription = new Text(container, 2626);
        GridData descLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        descLayoutData.heightHint = 80;
        this.txtDescription.setLayoutData((Object)descLayoutData);
        this.setControlListeners();
        this.setControl((Control)container);
        this.setPageComplete(this.isComplete());
    }

    private void setControlListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCheckpointStartingPage.this.setName(((Text)e.getSource()).getText());
                NewCheckpointStartingPage.this.setPageComplete(NewCheckpointStartingPage.this.isComplete());
            }
        });
        this.comboSourceType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCheckpointStartingPage.this.setTypeName(((Combo)e.getSource()).getText());
            }
        });
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCheckpointStartingPage.this.setCheckpointDescription(((Text)e.getSource()).getText());
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = name.trim().replaceAll("\\s+", " ");
        }
        this.name = name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getCheckpointDescription() {
        return this.checkpointDescription;
    }

    public void setCheckpointDescription(String checkpointDescription) {
        this.checkpointDescription = checkpointDescription;
    }

    public void validateName(String name) throws Exception {
        if (!StringUtils.equalsIgnoreCase((String)EntityNameController.getInstance().getAvailableName(name, this.parentFolder, false), (String)name)) {
            throw new InvalidNameException(NAME_ALREADY_EXISTS);
        }
    }

    @Override
    protected boolean isComplete() {
        try {
            String checkpointName = this.getName();
            EntityNameController.getInstance().validateName(checkpointName);
            this.validateName(checkpointName);
            this.setErrorMessage(null);
            return true;
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
    }

    @Override
    public Point getPageSize() {
        return this.getShell().computeSize(500, 300);
    }
}

