/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs.wizard;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.AbstractCheckpointWizardPage;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.testdata.job.LoadExcelFileJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.checkpoint.ExcelCheckpointSourceInfo;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewCheckpointExcelPage
extends AbstractCheckpointWizardPage {
    private static final String[] FILTER_NAMES = new String[]{"Microsoft Excel Spreadsheet Files (*.xls, *.xlsx)"};
    private static final String[] FILTER_EXTS = new String[]{"*.xlsx; *.xls"};
    protected Combo comboContentIndicator;
    private Text txtFileLocation;
    private Button btnBrowse;
    private Button chkRelativeLocation;
    private Button chkFirstRowHeader;
    private LoadExcelFileJob loadFileJob;
    private String fileLocation;
    private String contentIndicator;
    private boolean isRelativeLocation;
    private boolean isFirstRowHeader = true;

    public NewCheckpointExcelPage() {
        this(NewCheckpointExcelPage.class.getSimpleName());
    }

    public NewCheckpointExcelPage(String pageName) {
        super(pageName, StringConstants.WIZ_TITLE_EXCEL_DATA, StringConstants.WIZ_EXCEL_SOURCE_CONFIGURATION);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblSourceUrl = new Label(container, 0);
        lblSourceUrl.setText(StringConstants.DIA_LBL_FILE_PATH);
        this.txtFileLocation = new Text(container, 2056);
        this.txtFileLocation.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnBrowse = new Button(container, 0x800008);
        this.btnBrowse.setText(StringConstants.BROWSE);
        this.btnBrowse.setLayoutData((Object)new GridData(131072, 4, false, false));
        Label lblIndicator = new Label(container, 0);
        lblIndicator.setText(this.getContentIndicatorLabel());
        this.comboContentIndicator = new Combo(container, 8);
        this.comboContentIndicator.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label(container, 0);
        new Label(container, 0);
        this.chkFirstRowHeader = new Button(container, 32);
        this.chkFirstRowHeader.setText(StringConstants.DIA_CHK_USING_FIRST_ROW_AS_HEADER);
        this.comboContentIndicator.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label(container, 0);
        new Label(container, 0);
        this.chkRelativeLocation = new Button(container, 32);
        this.chkRelativeLocation.setText(StringConstants.DIA_CHK_IS_USING_RELATIVE_PATH);
        this.chkRelativeLocation.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label(container, 0);
        this.setControlListeners();
        this.setControl((Control)container);
        this.chkFirstRowHeader.setSelection(this.isFirstRowHeader);
        this.setPageComplete(this.isComplete());
    }

    private void setControlListeners() {
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(NewCheckpointExcelPage.this.btnBrowse.getShell());
                dialog.setFilterNames(NewCheckpointExcelPage.this.getFilterNames());
                dialog.setFilterExtensions(NewCheckpointExcelPage.this.getFilterExtensions());
                if (StringUtils.isBlank((String)NewCheckpointExcelPage.this.fileLocation)) {
                    dialog.setFilterPath(NewCheckpointExcelPage.this.getProjectFolderLocation());
                } else {
                    dialog.setFileName(NewCheckpointExcelPage.this.fileLocation);
                }
                String absolutePath = dialog.open();
                if (absolutePath == null || absolutePath.equals(NewCheckpointExcelPage.this.fileLocation)) {
                    return;
                }
                NewCheckpointExcelPage.this.setFileLocation(absolutePath);
                NewCheckpointExcelPage.this.comboContentIndicator.clearSelection();
                NewCheckpointExcelPage.this.txtFileLocation.setText(StringUtils.defaultString((String)NewCheckpointExcelPage.this.fileLocation));
                if (NewCheckpointExcelPage.this.isRelativeLocation()) {
                    NewCheckpointExcelPage.this.txtFileLocation.setText(PathUtil.absoluteToRelativePath((String)NewCheckpointExcelPage.this.fileLocation, (String)NewCheckpointExcelPage.this.getProjectFolderLocation()));
                }
                if (StringUtils.isNotBlank((String)NewCheckpointExcelPage.this.fileLocation)) {
                    NewCheckpointExcelPage.this.loadIndicatorData(StringUtils.defaultString((String)NewCheckpointExcelPage.this.getContentIndicator()));
                }
            }
        });
        this.comboContentIndicator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedSheetName = NewCheckpointExcelPage.this.comboContentIndicator.getText();
                if (StringUtils.equals((String)NewCheckpointExcelPage.this.getContentIndicator(), (String)selectedSheetName)) {
                    return;
                }
                NewCheckpointExcelPage.this.setContentIndicator(selectedSheetName);
                NewCheckpointExcelPage.this.setPageComplete(NewCheckpointExcelPage.this.isComplete());
            }
        });
        this.chkFirstRowHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCheckpointExcelPage.this.setFirstRowHeader(NewCheckpointExcelPage.this.chkFirstRowHeader.getSelection());
            }
        });
        this.chkRelativeLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isRelativeLocation = NewCheckpointExcelPage.this.chkRelativeLocation.getSelection();
                NewCheckpointExcelPage.this.setRelativeLocation(isRelativeLocation);
                String fileLocation = NewCheckpointExcelPage.this.txtFileLocation.getText();
                if (StringUtils.isBlank((String)fileLocation)) {
                    return;
                }
                fileLocation = isRelativeLocation ? PathUtil.absoluteToRelativePath((String)fileLocation, (String)NewCheckpointExcelPage.this.getProjectFolderLocation()) : PathUtil.relativeToAbsolutePath((String)fileLocation, (String)NewCheckpointExcelPage.this.getProjectFolderLocation());
                NewCheckpointExcelPage.this.txtFileLocation.setText(fileLocation);
                NewCheckpointExcelPage.this.setFileLocation(fileLocation);
            }
        });
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public String getContentIndicator() {
        return this.contentIndicator;
    }

    public void setContentIndicator(String contentIndicator) {
        this.contentIndicator = contentIndicator;
    }

    public boolean isRelativeLocation() {
        return this.isRelativeLocation;
    }

    public void setRelativeLocation(boolean isRelativeLocation) {
        this.isRelativeLocation = isRelativeLocation;
    }

    public boolean isFirstRowHeader() {
        return this.isFirstRowHeader;
    }

    public void setFirstRowHeader(boolean isFirstRowHeader) {
        this.isFirstRowHeader = isFirstRowHeader;
    }

    private void loadIndicatorData(String indicator) {
        this.setIndicatorSelection(indicator, this.getIndicatorData());
        this.setPageComplete(this.isComplete());
    }

    private void setIndicatorSelection(String indicator, String[] indicators) {
        if (indicators == null) {
            return;
        }
        this.comboContentIndicator.setItems(indicators);
        int indicatorSelectionIndex = ArrayUtils.indexOf((Object[])indicators, (Object)indicator);
        if (indicatorSelectionIndex == -1) {
            this.comboContentIndicator.select(0);
            this.setContentIndicator(this.comboContentIndicator.getText());
            return;
        }
        this.comboContentIndicator.select(indicatorSelectionIndex);
    }

    protected String[] getIndicatorData() {
        this.loadFileJob = new LoadExcelFileJob(this.getAbsoluteFileLocation(), this.chkFirstRowHeader.getSelection());
        this.loadFileJob.setUser(true);
        this.loadFileJob.schedule();
        this.loadFileJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult() != Status.OK_STATUS || NewCheckpointExcelPage.this.loadFileJob.getExcelData() == null) {
                            return;
                        }
                        NewCheckpointExcelPage.this.setIndicatorSelection(NewCheckpointExcelPage.this.getContentIndicator(), NewCheckpointExcelPage.this.loadFileJob.getExcelData().getSheetNames());
                        NewCheckpointExcelPage.this.setPageComplete(NewCheckpointExcelPage.this.isComplete());
                    }
                });
            }
        });
        return null;
    }

    protected String getContentIndicatorLabel() {
        return StringConstants.DIA_LBL_SHEET_NAME;
    }

    protected String[] getFilterNames() {
        return FILTER_NAMES;
    }

    protected String[] getFilterExtensions() {
        return FILTER_EXTS;
    }

    private String getAbsoluteFileLocation() {
        String fileLocation = this.txtFileLocation.getText();
        if (this.chkRelativeLocation.getSelection()) {
            fileLocation = PathUtil.relativeToAbsolutePath((String)fileLocation, (String)this.getProjectFolderLocation());
        }
        return fileLocation;
    }

    private String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation();
    }

    public CheckpointSourceInfo getSourceInfo() {
        if (((Object)((Object)this)).equals(this.getContainer().getCurrentPage())) {
            return new ExcelCheckpointSourceInfo(this.getFileLocation(), this.getContentIndicator(), this.isRelativeLocation(), this.isFirstRowHeader());
        }
        return new ExcelCheckpointSourceInfo();
    }

    @Override
    protected boolean isComplete() {
        return StringUtils.isNotBlank((String)this.txtFileLocation.getText()) && StringUtils.isNotBlank((String)this.comboContentIndicator.getText());
    }

    @Override
    public Point getPageSize() {
        return this.getShell().computeSize(500, 250);
    }
}

