/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.dialogs;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.CommonNewEntityDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import javax.inject.Inject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCheckpointFromTestDataDialog
extends CommonNewEntityDialog<CheckpointEntity> {
    private DataFileEntity testdata;
    private Text txtId;

    public NewCheckpointFromTestDataDialog(Shell parentShell, DataFileEntity testdata, String suggestedName) {
        super(parentShell, NewCheckpointFromTestDataDialog.getCheckpointRootFolder(), suggestedName);
        this.setDialogTitle(StringConstants.CHECKPOINT);
        this.setDialogMsg(StringConstants.DIA_MSG_CREATE_CHECKPOINT_FROM_TEST_DATA);
        this.testdata = testdata;
    }

    @Inject
    private static FolderEntity getCheckpointRootFolder() {
        try {
            return FolderController.getInstance().getCheckpointRoot(ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    protected void createEntity() {
        try {
            this.entity = CheckpointController.getInstance().initialNewCheckpoint(this.parentFolder, this.getName());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected Control createEntityCustomControl(Composite parent, int column, int span) {
        this.createDataSourceTypeControl(parent, column);
        return super.createEntityCustomControl(parent, column, span);
    }

    private Control createDataSourceTypeControl(Composite parent, int column) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(column, false));
        Label labelDataSourceType = new Label(parent, 0);
        labelDataSourceType.setText(StringConstants.DIA_LBL_TEST_DATA_ID);
        this.txtId = new Text(parent, 2056);
        this.txtId.setLayoutData((Object)new GridData(768));
        this.txtId.setText(this.testdata.getIdForDisplay());
        return parent;
    }

    protected void setEntityProperties() {
        super.setEntityProperties();
        ((CheckpointEntity)this.entity).setSourceInfo(new CheckpointSourceInfo(this.testdata.getIdForDisplay()));
    }
}

