/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.resources.image;

import com.kms.katalon.composer.resources.util.ImageUtil;
import java.net.URL;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ImageManager {
    public static final String IMAGE_PATH = "/icons/";
    private static final Bundle currentBundle = FrameworkUtil.getBundle(ImageManager.class);
    private static ImageRegistry imageRegistry = JFaceResources.getImageRegistry();

    private ImageManager() {
    }

    public static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }

    public static String getImageURLString(String key) {
        return ImageUtil.getImageURLString(currentBundle, IMAGE_PATH + key);
    }

    public static URL getImageURL(String key) {
        return ImageUtil.getImageURL(currentBundle, IMAGE_PATH + key);
    }

    public static Image getImage(String key) {
        Image registeredImage = imageRegistry.get(key);
        if (registeredImage != null && registeredImage.isDisposed()) {
            ImageManager.removeImage(key);
            ImageManager.registerImage(key);
        }
        return imageRegistry.get(key);
    }

    public static void registerImage(String key, Image image) {
        Image registeredImage = ImageManager.getImage(key);
        if (registeredImage != null && registeredImage.isDisposed()) {
            ImageManager.removeImage(key);
        }
        if (registeredImage == null) {
            imageRegistry.put(key, image);
        }
    }

    public static void registerImage(String key) {
        ImageManager.registerImage(key, ImageUtil.loadImage(currentBundle, IMAGE_PATH + key));
    }

    public static void removeImage(String key) {
        imageRegistry.remove(key);
    }

    public static void updateImage(String key, Image image) {
        imageRegistry.remove(key);
        imageRegistry.put(key, image);
    }
}

