/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.util;

import com.google.common.io.Files;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;

public class WebDriverInstallationUtil {
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String KATALON_FOLDER = String.valueOf(USER_HOME) + "/.katalon";
    private static final String SAFARI_WEB_DRIVER_FILE_NAME = "SafariDriver.safariextz";
    private static final String SAFARI_WEBDRIVER_FILE_PATH = String.valueOf(KATALON_FOLDER) + "/" + "SafariDriver.safariextz";
    private static final String INSTALLED_SAFARI_WEBDRIVER = String.valueOf(USER_HOME) + "/Library/Safari/Extensions/WebDriver.safariextz";
    private static String safariDriverFolder;
    private static String safariWebDriverInstallScript;

    static {
        try {
            safariDriverFolder = String.valueOf(ClassPathResolver.getConfigurationFolder().getCanonicalPath()) + "/resources/drivers/safaridriver";
            safariWebDriverInstallScript = String.valueOf(safariDriverFolder) + "/InstallWebDriver.scpt";
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    public static boolean installSafariWebDriverAsNeed() {
        if (!Platform.getOS().equals("macosx")) {
            return true;
        }
        String installFile2 = INSTALLED_SAFARI_WEBDRIVER.replaceAll("\\.safariextz", "-2.safariextz");
        if (!new File(INSTALLED_SAFARI_WEBDRIVER).exists() && !new File(installFile2).exists()) {
            boolean confirmed = MessageDialog.openConfirm(null, (String)ComposerExecutionMessageConstants.DIA_CONFIRM_INSTALL_WEBDRIVER_TITLE, (String)MessageFormat.format(ComposerExecutionMessageConstants.DIA_CONFIRM_INSTALL_WEBDRIVER, "Safari"));
            if (!confirmed) {
                return false;
            }
            WebDriverInstallationUtil.createFileWebDriver();
            return WebDriverInstallationUtil.installWebDriver();
        }
        return true;
    }

    private static void createFileWebDriver() {
        try {
            File srcWebDriver = new File(String.valueOf(safariDriverFolder) + File.separator + SAFARI_WEB_DRIVER_FILE_NAME);
            if (srcWebDriver.exists()) {
                File descWebDriver = new File(String.valueOf(KATALON_FOLDER) + File.separator + SAFARI_WEB_DRIVER_FILE_NAME);
                Files.copy((File)srcWebDriver, (File)descWebDriver);
            }
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private static boolean installWebDriver() {
        try {
            new File(safariWebDriverInstallScript).setExecutable(true);
            Process proc = Runtime.getRuntime().exec(new String[]{"osascript", safariWebDriverInstallScript, SAFARI_WEBDRIVER_FILE_PATH, INSTALLED_SAFARI_WEBDRIVER});
            proc.waitFor();
            return new File(INSTALLED_SAFARI_WEBDRIVER).exists();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }
}

