/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.tree;

import com.kms.katalon.composer.execution.tree.ILogParentTreeNode;
import com.kms.katalon.composer.execution.tree.ILogTreeNode;
import com.kms.katalon.composer.execution.tree.LogChildTreeNode;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.util.internal.DateUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LogParentTreeNode
extends LogChildTreeNode
implements ILogParentTreeNode {
    private XmlLogRecord recordStart;
    private XmlLogRecord recordEnd;
    private List<ILogTreeNode> children;
    private XmlLogRecord recordResult;

    public LogParentTreeNode(ILogParentTreeNode parentTreeNode, XmlLogRecord recordStart) {
        super(parentTreeNode, recordStart);
        this.recordStart = recordStart;
        this.children = new ArrayList<ILogTreeNode>();
    }

    @Override
    public XmlLogRecord getResult() {
        return this.recordResult;
    }

    @Override
    public void setResult(XmlLogRecord result) {
        this.recordResult = result;
    }

    @Override
    public String getMessage() {
        int index = this.recordStart.getMessage().indexOf(":");
        return this.recordStart.getMessage().substring(index + 1).trim();
    }

    @Override
    public List<ILogTreeNode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ILogTreeNode>();
        }
        return this.children;
    }

    @Override
    public XmlLogRecord getRecordEnd() {
        return this.recordEnd;
    }

    @Override
    public void setRecordEnd(XmlLogRecord recordEnd) {
        this.recordEnd = recordEnd;
    }

    @Override
    public String getElapsedTime() {
        if (this.recordEnd == null) {
            return "";
        }
        double elapsedSeconds = (double)(this.recordEnd.getMillis() - this.recordStart.getMillis()) / 1000.0;
        return String.valueOf(DateUtil.SECOND_FORMAT.format(elapsedSeconds)) + "s";
    }

    @Override
    public void addChild(ILogTreeNode childNode) {
        this.children.add(childNode);
    }

    @Override
    public XmlLogRecord getRecordStart() {
        return this.recordStart;
    }

    @Override
    public String getFullElapsedTime() {
        if (this.recordEnd == null) {
            return "";
        }
        return DateUtil.getElapsedTime((long)this.recordStart.getMillis(), (long)this.recordEnd.getMillis());
    }

    @Override
    public String getIndexString() {
        if (!this.record.getMessage().startsWith("Start action")) {
            return "";
        }
        String parentIdxAsString = this.getParent().getIndexString();
        if (!StringUtils.isBlank((String)parentIdxAsString)) {
            parentIdxAsString = String.valueOf(parentIdxAsString) + ".";
        }
        return String.valueOf(parentIdxAsString) + this.getIndex();
    }

    @Override
    public int getIndex() {
        int stepIndex = this.record.getIndex();
        if (stepIndex < 0) {
            stepIndex = 1;
            for (ILogTreeNode siblingNode : this.getParent().getChildren()) {
                if (!(siblingNode instanceof ILogParentTreeNode)) continue;
                if (siblingNode.equals(this)) break;
                ++stepIndex;
            }
        }
        return stepIndex;
    }
}

