/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.trace;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.trace.ArtifactStyleRangeMatcher;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.repository.WebElementEntity;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TestObjectStyleRangeMatcher
extends ArtifactStyleRangeMatcher {
    private static final String TEST_OBJECT_ID_PATTERN = "'Object Repository\\/([^']*)'";

    @Override
    public String getPattern() {
        return TEST_OBJECT_ID_PATTERN;
    }

    @Override
    protected void internalClick(String testObjectId) {
        WebElementEntity webElement = this.getTestObject(testObjectId);
        if (webElement == null) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_TEST_OBEJCT_NOT_FOUND, testObjectId));
            return;
        }
        EventBrokerSingleton.getInstance().getEventBroker().post("TESTOBJECT/OPEN", (Object)webElement);
    }

    private WebElementEntity getTestObject(String testObjectId) {
        WebElementEntity webElement = null;
        try {
            webElement = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return webElement;
    }
}

