/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.trace;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.trace.ArtifactStyleRangeMatcher;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TestDataStyleRangeMatcher
extends ArtifactStyleRangeMatcher {
    private static final String TEST_DATA_ID_PATTERN = "'Data Files\\/([^']*)'";

    @Override
    public String getPattern() {
        return TEST_DATA_ID_PATTERN;
    }

    @Override
    protected void internalClick(String testDataId) {
        DataFileEntity testData = this.getTestData(testDataId);
        if (testData == null) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_TEST_DATA_NOT_FOUND, testDataId));
            return;
        }
        EventBrokerSingleton.getInstance().getEventBroker().post("TESTDATA/OPEN", (Object)testData);
    }

    private DataFileEntity getTestData(String testDataId) {
        DataFileEntity testData = null;
        try {
            testData = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return testData;
    }
}

