/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.toolbar;

import com.kms.katalon.composer.components.impl.control.CDropdownBox;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.osgi.service.event.EventHandler;

public class ExecutionToolControl
implements EventHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EModelService modelService;
    private CDropdownBox dropdownBox;
    private MApplication app;
    private List<ExecutionProfileEntity> profiles;

    @PostConstruct
    private void createWidget(Composite parent, MApplication app) {
        this.app = app;
        this.dropdownBox = new CDropdownBox(parent, 2048, ImageConstants.IMG_PROFILE);
        this.dropdownBox.setToolTipText(ComposerExecutionMessageConstants.TOOLTIP_CONTROL_EXECUTION_PROFILE);
        GridData gridData = new GridData(131072, 4, false, true);
        this.dropdownBox.setLayoutData((Object)gridData);
        this.setVisible(false);
        this.registerEventListeners();
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)this);
        this.eventBroker.subscribe("EXECUTION_PROFILE/CREATED", (EventHandler)this);
        this.eventBroker.subscribe("EXECUTION_PROFILE/RENAMED", (EventHandler)this);
        this.eventBroker.subscribe("EXECUTION_PROFILE/DELETED", (EventHandler)this);
        this.dropdownBox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExecutionToolControl.this.fireSelectedProfileChange();
            }
        });
    }

    private void updateComboboxInput() {
        try {
            this.profiles = GlobalVariableController.getInstance().getAllGlobalVariableCollections(ProjectController.getInstance().getCurrentProject());
            String[] profileNames = this.profiles.stream().map(p -> p.getName()).collect(Collectors.toList()).toArray(new String[0]);
            this.dropdownBox.setItems(profileNames);
            this.fireSelectedProfileChange();
        }
        catch (ControllerException controllerException) {
            this.setVisible(true);
        }
    }

    private void fireSelectedProfileChange() {
        if (this.dropdownBox.getSelectionIndex() < 0 || this.profiles.isEmpty()) {
            return;
        }
        ExecutionProfileEntity selectedProfile = this.profiles.get(this.dropdownBox.getSelectionIndex());
        this.eventBroker.post("PROFILE/SELECTED_PROFILE_CHANGE", (Object)selectedProfile);
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        switch (event.getTopic()) {
            case "PROJECT/OPENED": {
                this.updateComboboxInput();
                this.setVisible(true);
                break;
            }
            case "PROJECT/CLOSED": {
                this.setVisible(false);
                break;
            }
            case "EXECUTION_PROFILE/CREATED": {
                this.updateComboboxInput();
            }
            case "EXECUTION_PROFILE/RENAMED": {
                ExecutionProfileEntity selectedProfile = this.profiles.get(this.dropdownBox.getSelectionIndex());
                this.updateComboboxInput();
                this.dropdownBox.setSelectionIndex(this.profiles.indexOf(selectedProfile));
                break;
            }
            case "EXECUTION_PROFILE/DELETED": {
                ExecutionProfileEntity selectedProfile = this.profiles.get(this.dropdownBox.getSelectionIndex());
                this.updateComboboxInput();
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof Object)) {
                    return;
                }
                ExecutionProfileEntity deletedProfile = (ExecutionProfileEntity)object;
                if (deletedProfile.equals((Object)selectedProfile)) {
                    selectedProfile = this.profiles.get(0);
                }
                this.dropdownBox.setSelectionIndex(this.profiles.indexOf(selectedProfile));
                break;
            }
        }
    }

    private void setVisible(boolean visible) {
        this.dropdownBox.setVisible(visible);
        ((GridData)this.dropdownBox.getLayoutData()).exclude = !visible;
        this.dropdownBox.pack();
        this.modelService.find("com.kms.katalon.composer.toolbar.execution", (MUIElement)this.app).setToBeRendered(visible);
        this.dropdownBox.getParent().layout(true, true);
    }
}

