/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.exceptions.FileBeingUsedException;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.classpath.ProjectBuildPath;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class ExternalLibratiesSettingPage
extends PreferencePageWithHelp {
    private static final int DELETING_EXTERNAL_JAR_TIMEOUT = 30000;
    private static final int TICK = 1;
    private static final String JAR_FILE_EXTENSION = "*.jar";
    private TableViewer tableViewer;
    private ProjectBuildPath projectBuildPath;
    private ToolItem tltmRemoveJars;
    private ToolItem tltmAddJars;
    private Collection<File> externalJars;
    private boolean modified;

    public ExternalLibratiesSettingPage() {
        this.noDefaultButton();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(container, 0x820000);
        this.tltmAddJars = new ToolItem(toolBar, 0);
        this.tltmAddJars.setText(StringConstants.ADD);
        this.tltmAddJars.setImage(ImageConstants.IMG_24_ADD);
        this.tltmRemoveJars = new ToolItem(toolBar, 0);
        this.tltmRemoveJars.setText(StringConstants.REMOVE);
        this.tltmRemoveJars.setImage(ImageConstants.IMG_24_REMOVE);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableLayout);
        this.tableViewer = new CTableViewer(composite, 67586);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tableViewerColumn.setLabelProvider((CellLabelProvider)new FileLabelCellProvider());
        tableLayout.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(98, 0));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.updateInput();
        this.registerControlModifyListeners();
        return container;
    }

    private void registerControlModifyListeners() {
        this.tltmAddJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 2);
                fileDialog.setFilterExtensions(new String[]{ExternalLibratiesSettingPage.JAR_FILE_EXTENSION});
                if (StringUtils.isEmpty((String)fileDialog.open())) {
                    return;
                }
                Object[] selectedFileNames = fileDialog.getFileNames();
                if (ArrayUtils.isEmpty((Object[])selectedFileNames)) {
                    return;
                }
                ArrayList<File> newFiles = new ArrayList<File>();
                Object[] objectArray = selectedFileNames;
                int n = selectedFileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object fileName = objectArray[n2];
                    File newExternalFile = new File(ExternalLibratiesSettingPage.this.getExternalDir(), (String)fileName);
                    newFiles.add(newExternalFile);
                    try {
                        FileUtils.copyFile((File)new File(fileDialog.getFilterPath(), (String)fileName), (File)newExternalFile, (boolean)true);
                        if (!ExternalLibratiesSettingPage.this.externalJars.contains(newExternalFile)) {
                            ExternalLibratiesSettingPage.this.externalJars.add(newExternalFile);
                        }
                    }
                    catch (IOException veryImportantException) {
                        LoggerSingleton.logError((Throwable)veryImportantException);
                    }
                    ++n2;
                }
                ExternalLibratiesSettingPage.this.tableViewer.refresh();
                ExternalLibratiesSettingPage.this.tableViewer.setSelection((ISelection)new StructuredSelection(newFiles));
                ExternalLibratiesSettingPage.this.modified = true;
            }
        });
        this.tltmRemoveJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalLibratiesSettingPage.this.removeSelectedExternalJars();
            }
        });
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ExternalLibratiesSettingPage.this.removeSelectedExternalJars();
                }
            }
        });
    }

    private void removeSelectedExternalJars() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectFile = objectArray[n2];
            File file = (File)objectFile;
            this.externalJars.remove(file);
            ++n2;
        }
        this.tableViewer.refresh();
        this.modified = true;
    }

    private ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    private void updateInput() {
        ProjectEntity currentProject = this.getCurrentProject();
        this.projectBuildPath = new ProjectBuildPath(currentProject);
        this.externalJars = this.getJars();
        this.tableViewer.setInput(this.externalJars);
        this.modified = false;
    }

    private Collection<File> getJars() {
        final File externalDir = this.getExternalDir();
        Collection<File> listJarFiles = new ArrayList<File>();
        if (externalDir.exists()) {
            listJarFiles = FileUtils.listFiles((File)externalDir, (IOFileFilter)new WildcardFileFilter(JAR_FILE_EXTENSION), (IOFileFilter)new AbstractFileFilter(){

                public boolean accept(File file) {
                    return file == externalDir;
                }
            });
        }
        return listJarFiles;
    }

    private File getExternalDir() {
        return this.projectBuildPath.getExternalLibrariesDir();
    }

    public boolean performOk() {
        if (!this.modified || this.tableViewer == null || this.tableViewer.getTable().isDisposed()) {
            return true;
        }
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                private void removeUnusedFiles(IProgressMonitor monitor) throws FileBeingUsedException {
                    Collection needRemovedJars = ExternalLibratiesSettingPage.this.getJars();
                    needRemovedJars.removeAll(ExternalLibratiesSettingPage.this.externalJars);
                    if (needRemovedJars.isEmpty()) {
                        return;
                    }
                    monitor.beginTask(ComposerExecutionMessageConstants.MSG_DELETING_LIBRARY_FILES, needRemovedJars.size());
                    for (File file : needRemovedJars) {
                        monitor.subTask(MessageFormat.format(ComposerExecutionMessageConstants.MSG_DELETING_FILE_X, file.getName()));
                        this.safelyDeleleFile(file, 30000L);
                        monitor.worked(1);
                    }
                }

                private void safelyDeleleFile(File file, long timeoutInMillis) throws FileBeingUsedException {
                    long startTime = System.currentTimeMillis();
                    while (file.exists() && System.currentTimeMillis() - startTime <= timeoutInMillis) {
                        FileUtils.deleteQuietly((File)file);
                    }
                    if (file.exists()) {
                        throw new FileBeingUsedException(file, ExternalLibratiesSettingPage.this.getCurrentProject());
                    }
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(StringConstants.PAGE_EXTERNAL_LIB_JOB_TASK_REBUILD_PROJECT, 5);
                            ProjectController projectController = ProjectController.getInstance();
                            ProjectEntity currentProject = ExternalLibratiesSettingPage.this.getCurrentProject();
                            projectController.cleanProjectUISettings(currentProject);
                            monitor.worked(1);
                            ExternalLibratiesSettingPage.this.saveAllProject();
                            monitor.worked(1);
                            GroovyUtil.getGroovyProject((ProjectEntity)currentProject).close((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            try {
                                this.removeUnusedFiles(monitor);
                                monitor.worked(1);
                            }
                            finally {
                                projectController.openProjectForUI(currentProject.getId(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (!(targetException instanceof FileBeingUsedException)) {
                LoggerSingleton.logError((Throwable)targetException);
            } else {
                this.updateInput();
            }
            MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)StringConstants.PAGE_EXTERNAL_LIB_MSG_UNABLE_UPDATE_PROJECT, (String)targetException.getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return super.performOk();
    }

    private void saveAllProject() {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (this.getService(EPartService.class).getDirtyParts().isEmpty()) {
                    return;
                }
                try {
                    this.getService(IHandlerService.class).executeCommand("com.kms.katalon.command.saveAll", null);
                }
                catch (CommandException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }

            private <T> T getService(Class<? extends T> clazz) {
                return (T)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(clazz);
            }
        });
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXTERNAL_LIBRARIES;
    }

    private class FileLabelCellProvider
    extends TypeCheckedStyleCellLabelProvider<File> {
        public FileLabelCellProvider() {
            super(0);
        }

        protected Class<File> getElementType() {
            return File.class;
        }

        protected Image getImage(File element) {
            return ImageConstants.IMG_16_EXTERNAL_LIBRARY;
        }

        protected String getText(File file) {
            return FilenameUtils.getName((String)file.getName());
        }
    }
}

