/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.setting.EmailSettingStore;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EmailTemplatePage
extends PreferencePageWithHelp {
    private File templateFile;
    private Browser browser;
    private EmailSettingStore settingStore = new EmailSettingStore(ProjectController.getInstance().getCurrentProject());

    protected Control createContents(Composite parent) {
        Composite browserComposite = new Composite(parent, 2048);
        browserComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        browserComposite.setLayout((Layout)new FillLayout());
        this.browser = new Browser(browserComposite, 2048);
        this.browser.setJavascriptEnabled(true);
        this.updateInput();
        return browserComposite;
    }

    private void updateInput() {
        try {
            this.templateFile = new File(this.settingStore.getTemplateFolder(), String.format("template_%d.html", System.currentTimeMillis()));
            String tinyMCE = FileUtils.readFileToString((File)new File(this.settingStore.getTemplateFolder(), "tinymce_template.html"), (String)"UTF-8");
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("htmlTemplate", this.settingStore.getEmailHTMLTemplate());
            String newContent = GroovyStringUtil.evaluate((String)tinyMCE, variables);
            FileUtils.write((File)this.templateFile, (CharSequence)newContent, (String)"UTF-8");
            this.browser.setUrl(this.templateFile.toURI().toURL().toString());
        }
        catch (IOException | URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void dispose() {
        if (this.isControlCreated()) {
            this.cleanTempTemplateFile();
        }
        super.dispose();
    }

    private void cleanTempTemplateFile() {
        try {
            FileUtils.forceDelete((File)this.templateFile);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String getHtmlMessage() {
        String body = (String)this.browser.evaluate("return tinyMCE.get('myTextArea').getContent();");
        return String.format("<html><body>%s</body></html>", body);
    }

    protected void performDefaults() {
        try {
            String tinyMCE = FileUtils.readFileToString((File)new File(this.settingStore.getTemplateFolder(), "tinymce_template.html"), (String)"UTF-8");
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("htmlTemplate", this.settingStore.getDefaultEmailHTMLTemplate());
            FileUtils.write((File)this.templateFile, (CharSequence)GroovyStringUtil.evaluate((String)tinyMCE, variables), (String)"UTF-8");
            this.browser.setUrl(this.templateFile.toURI().toURL().toString());
        }
        catch (IOException | URISyntaxException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return true;
        }
        try {
            this.settingStore.setHTMLTemplate(this.getHtmlMessage());
            return true;
        }
        catch (IOException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }
}

