/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.execution.components.DriverPreferenceComposite;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.configuration.IDriverConnector;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class DriverPreferencePage
extends PreferencePageWithHelp {
    protected DriverPreferenceComposite driverPreferenceComposite;
    protected IDriverConnector driverConnector;

    public DriverPreferencePage() {
        this.initilize();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.driverPreferenceComposite = new DriverPreferenceComposite(container, 0, this.driverConnector);
        this.updateInput();
        return container;
    }

    protected void updateInput() {
        this.driverPreferenceComposite.setInput(this.driverConnector.getUserConfigProperties());
    }

    protected void initilize() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        this.driverConnector = this.getDriverConnector(String.valueOf(projectEntity.getFolderLocation()) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME);
    }

    protected abstract IDriverConnector getDriverConnector(String var1);

    public boolean performOk() {
        block3: {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            try {
                if (projectEntity != null && this.driverPreferenceComposite != null && this.driverPreferenceComposite.getResult() != null && this.driverConnector != null) break block3;
                return true;
            }
            catch (Exception exception) {
                MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.SETT_ERROR_MSG_UNABLE_TO_SAVE_PROJ_SETTS);
                return false;
            }
        }
        this.driverConnector = this.driverPreferenceComposite.getResult();
        this.driverConnector.saveUserConfigProperties();
        return true;
    }

    protected void performDefaults() {
        this.initilize();
        this.updateInput();
        super.performDefaults();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXECUTION;
    }
}

