/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.components.DriverConnectorListCellEditor;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.collector.DriverConnectorCollector;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.CustomRunConfiguration;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.exception.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class CustomExecutionSettingPage
extends PreferencePageWithHelp {
    private static final String DEFAULT_CUSTOM_CONFIGURATION_NAME = "custom";
    private List<CustomRunConfiguration> customRunConfigurationList = new ArrayList<CustomRunConfiguration>();
    private Table table;
    private TableViewer tableViewer;
    private ToolItem tltmAddProperty;
    private ToolItem tltmRemoveProperty;
    private ToolItem tltmClearProperty;

    public CustomExecutionSettingPage() {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        String[] stringArray = RunConfigurationCollector.getInstance().getAllCustomRunConfigurationIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String customRunConfigurationId = stringArray[n2];
            try {
                this.customRunConfigurationList.add(new CustomRunConfiguration(projectDir, customRunConfigurationId));
            }
            catch (ExecutionException | IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            ++n2;
        }
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Composite formComposite = new Composite(container, 0);
        formComposite.setLayout((Layout)new GridLayout(1, false));
        formComposite.setLayoutData((Object)new GridData(1808));
        Composite toolbarComposite = new Composite(formComposite, 0);
        toolbarComposite.setLayout((Layout)new FillLayout(256));
        toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        this.tltmAddProperty = new ToolItem(toolBar, 0);
        this.tltmAddProperty.setText(StringConstants.SETT_TOOLITEM_ADD);
        this.tltmAddProperty.setImage(ImageConstants.IMG_16_ADD);
        this.tltmRemoveProperty = new ToolItem(toolBar, 0);
        this.tltmRemoveProperty.setText(StringConstants.SETT_TOOLITEM_REMOVE);
        this.tltmRemoveProperty.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmClearProperty = new ToolItem(toolBar, 0);
        this.tltmClearProperty.setText(StringConstants.SETT_TOOLITEM_CLEAR);
        this.tltmClearProperty.setImage(ImageConstants.IMG_16_CLEAR);
        this.addToolItemListeners();
        Composite composite = new Composite(formComposite, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(tableComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE_NAME, 100, 30, new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof CustomRunConfiguration && value instanceof String) {
                    try {
                        CustomRunConfiguration customRunConfig = (CustomRunConfiguration)element;
                        String newName = (String)value;
                        if (!newName.equalsIgnoreCase(customRunConfig.getName())) {
                            ((CustomRunConfiguration)element).setName(newName.toLowerCase());
                            CustomExecutionSettingPage.this.tableViewer.refresh();
                        }
                    }
                    catch (ExecutionException | IOException e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof CustomRunConfiguration) {
                    return ((CustomRunConfiguration)element).getName();
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)CustomExecutionSettingPage.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return element instanceof CustomRunConfiguration;
            }
        }, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CustomRunConfiguration) {
                    return ((CustomRunConfiguration)element).getName();
                }
                return "";
            }
        });
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE_VALUE, 100, 70, new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof CustomRunConfiguration) {
                    CustomRunConfiguration customRunConfig = (CustomRunConfiguration)element;
                    return new DriverConnectorListCellEditor((Composite)CustomExecutionSettingPage.this.tableViewer.getTable(), customRunConfig.toString(), customRunConfig);
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof CustomRunConfiguration;
            }

            protected Object getValue(Object element) {
                if (element instanceof CustomRunConfiguration) {
                    CustomRunConfiguration runConfiguration = (CustomRunConfiguration)element;
                    ArrayList<IDriverConnector> driverConnectorList = new ArrayList<IDriverConnector>();
                    for (IDriverConnector driverConnector : runConfiguration.getDriverConnectors().values()) {
                        driverConnectorList.add(driverConnector);
                    }
                    return driverConnectorList;
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof CustomRunConfiguration && value instanceof List) {
                    CustomRunConfiguration runConfiguration = (CustomRunConfiguration)element;
                    String configFolderPath = runConfiguration.getConfigFolder().getAbsolutePath();
                    List driverConnectorList = (List)value;
                    runConfiguration.clearAllDriverConnectors();
                    try {
                        for (IDriverConnector driverConnector : driverConnectorList) {
                            String name = DriverConnectorCollector.getInstance().getContributorName(driverConnector, configFolderPath);
                            runConfiguration.addDriverConnector(name, driverConnector);
                        }
                        CustomExecutionSettingPage.this.tableViewer.refresh();
                    }
                    catch (IOException e) {
                        LoggerSingleton.logError((Throwable)e);
                        MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to update custom configuration", (String)e.getMessage());
                    }
                }
            }
        }, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CustomRunConfiguration) {
                    return ((CustomRunConfiguration)element).toString();
                }
                return "";
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.customRunConfigurationList);
        return container;
    }

    private void addTableColumn(TableViewer parent, TableColumnLayout tableColumnLayout, String headerText, int width, int weight, EditingSupport editingSupport, CellLabelProvider labelProvider) {
        TableViewerColumn tableColumn = new TableViewerColumn(parent, 0);
        tableColumn.getColumn().setWidth(width);
        tableColumn.getColumn().setMoveable(true);
        tableColumn.getColumn().setText(headerText);
        tableColumn.setLabelProvider(labelProvider);
        tableColumn.setEditingSupport(editingSupport);
        tableColumnLayout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, tableColumn.getColumn().getWidth()));
    }

    private void addToolItemListeners() {
        this.tltmAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CustomExecutionSettingPage.this.customRunConfigurationList.add(new CustomRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation(), CustomExecutionSettingPage.this.generateNewCustomConfigurationName()));
                    CustomExecutionSettingPage.this.tableViewer.refresh();
                }
                catch (ExecutionException | IOException exception) {
                    LoggerSingleton.logError((Throwable)exception);
                }
            }
        });
        this.tltmRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CustomExecutionSettingPage.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object selectedObject : selection.toList()) {
                        if (!(selectedObject instanceof CustomRunConfiguration)) continue;
                        CustomRunConfiguration selectedCustomRunConfig = (CustomRunConfiguration)selectedObject;
                        CustomExecutionSettingPage.this.customRunConfigurationList.remove(selectedCustomRunConfig);
                    }
                    CustomExecutionSettingPage.this.tableViewer.refresh();
                }
            }
        });
        this.tltmClearProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomExecutionSettingPage.this.customRunConfigurationList.clear();
                CustomExecutionSettingPage.this.tableViewer.refresh();
            }
        });
    }

    private String generateNewCustomConfigurationName() {
        String name = DEFAULT_CUSTOM_CONFIGURATION_NAME;
        boolean exists = false;
        for (CustomRunConfiguration customRunConfig : this.customRunConfigurationList) {
            if (!customRunConfig.getName().equalsIgnoreCase(name)) continue;
            exists = true;
        }
        if (!exists) {
            return name;
        }
        int index = 0;
        boolean isUnique = false;
        while (!isUnique) {
            String newName = String.valueOf(name) + "_" + ++index;
            isUnique = true;
            for (CustomRunConfiguration customRunConfig : this.customRunConfigurationList) {
                if (!customRunConfig.getName().equalsIgnoreCase(newName)) continue;
                isUnique = false;
            }
        }
        return String.valueOf(name) + "_" + index;
    }

    public boolean performOk() {
        File customConfigFolder = new File(String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + RunConfigurationCollector.CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH);
        if (customConfigFolder.exists() && customConfigFolder.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)customConfigFolder);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        for (CustomRunConfiguration customRunConfiguration : this.customRunConfigurationList) {
            try {
                customRunConfiguration.save();
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return true;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXECUTION;
    }
}

