/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.provider;

import com.kms.katalon.composer.execution.provider.LogViewerFilter;
import com.kms.katalon.composer.execution.tree.ILogParentTreeNode;
import com.kms.katalon.composer.execution.tree.ILogTreeNode;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import org.eclipse.jface.viewers.Viewer;

public class LogTreeViewerFilter
extends LogViewerFilter {
    public static final String PROPERTY_FILTER = "filter";

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof ILogTreeNode)) {
            return true;
        }
        ILogTreeNode logTreeNode = (ILogTreeNode)element;
        if (!(logTreeNode instanceof ILogParentTreeNode)) {
            return (this.evaluteLog(logTreeNode.getLogRecord()) & this.getPreferenceShowedValue()) != 0;
        }
        ILogParentTreeNode logParentTreeNode = (ILogParentTreeNode)logTreeNode;
        if (!this.isLogEnded(logParentTreeNode) || this.isTestSuiteLog(logParentTreeNode)) {
            return true;
        }
        return (this.evaluteLog(logParentTreeNode.getResult()) & this.getPreferenceShowedValue()) != 0;
    }

    public boolean isFilterProperty(Object element, String property) {
        if (PROPERTY_FILTER.equals(property)) {
            return true;
        }
        return super.isFilterProperty(element, property);
    }

    private boolean isTestSuiteLog(ILogParentTreeNode logParentTreeNode) {
        return "startSuite".equals(logParentTreeNode.getRecordStart().getSourceMethodName());
    }

    protected boolean isGeneralStep(ILogParentTreeNode logParentTreeNode) {
        return logParentTreeNode.getResult() == null;
    }

    protected boolean isLogEnded(ILogParentTreeNode logParentTreeNode) {
        return logParentTreeNode.getRecordEnd() != null || logParentTreeNode.getResult() != null;
    }

    @Override
    protected int getPreferenceShowedValue() {
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(LogViewerFilter.class);
        boolean isShowedFailedLogs = store.getBoolean("log.treeViewer.showFailures");
        return isShowedFailedLogs ? 8 : 1;
    }
}

