/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.provider;

import com.kms.katalon.composer.execution.tree.ILogParentTreeNode;
import com.kms.katalon.composer.execution.tree.ILogTreeNode;
import com.kms.katalon.composer.execution.tree.LogChildTreeNode;
import com.kms.katalon.composer.execution.tree.LogParentTreeNode;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class LogRecordTreeViewer
extends TreeViewer {
    private ILogParentTreeNode currentParentTreeNode;
    private List<ILogParentTreeNode> rootNodes = new ArrayList<ILogParentTreeNode>();
    private ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(LogRecordTreeViewer.class);

    public LogRecordTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void reset(List<XmlLogRecord> records) {
        this.currentParentTreeNode = null;
        this.rootNodes.clear();
        this.setInput(this.rootNodes);
        this.refresh();
        this.addRecords(records);
    }

    public void addRecords(List<XmlLogRecord> records) {
        for (XmlLogRecord record : records) {
            this.addRecord(record);
        }
    }

    private void select(IStructuredSelection selection) {
        if (this.isScrollLogEnable()) {
            this.setSelection((ISelection)selection);
        }
    }

    public void addRecord(XmlLogRecord record) {
        LogLevel logLevel = LogLevel.valueOf((Level)record.getLevel());
        if (logLevel == null) {
            return;
        }
        switch (logLevel) {
            case START: {
                LogParentTreeNode newParentTreeNode = new LogParentTreeNode(this.currentParentTreeNode, record);
                if (this.currentParentTreeNode == null) {
                    this.rootNodes.add(newParentTreeNode);
                    this.refresh(this.rootNodes);
                } else {
                    this.currentParentTreeNode.addChild(newParentTreeNode);
                    this.refresh(this.currentParentTreeNode);
                }
                this.currentParentTreeNode = newParentTreeNode;
                this.select((IStructuredSelection)new StructuredSelection((Object)newParentTreeNode));
                break;
            }
            case END: {
                this.currentParentTreeNode.setRecordEnd(record);
                LogParentTreeNode currentParentNodeImpl = (LogParentTreeNode)this.currentParentTreeNode;
                this.refresh(currentParentNodeImpl);
                this.update(currentParentNodeImpl, new String[]{"filter"});
                if ((currentParentNodeImpl.getResult() == null || LogLevel.valueOf((Level)currentParentNodeImpl.getResult().getLevel()) == LogLevel.PASSED) && this.isScrollLogEnable() && currentParentNodeImpl.getParent() != null) {
                    this.setExpandedState(currentParentNodeImpl, false);
                }
                this.select((IStructuredSelection)new StructuredSelection((Object)currentParentNodeImpl));
                this.currentParentTreeNode = currentParentNodeImpl.getParent();
                break;
            }
            case PASSED: 
            case WARNING: 
            case FAILED: 
            case ERROR: 
            case NOT_RUN: {
                if (this.currentParentTreeNode == null) break;
                this.currentParentTreeNode.setResult(record);
                this.refresh(this.currentParentTreeNode);
                break;
            }
            default: {
                LogChildTreeNode newChildTreeNode = new LogChildTreeNode(this.currentParentTreeNode, record);
                this.currentParentTreeNode.addChild(newChildTreeNode);
                this.refresh(this.currentParentTreeNode);
                this.setExpandedState(this.currentParentTreeNode, true);
                this.select((IStructuredSelection)new StructuredSelection((Object)newChildTreeNode));
            }
        }
    }

    private boolean isFailureNode(ILogParentTreeNode treeNode) {
        if (treeNode.getResult() != null && !treeNode.getElapsedTime().isEmpty()) {
            LogLevel logLevel = LogLevel.valueOf((Level)treeNode.getResult().getLevel());
            return logLevel == LogLevel.FAILED || logLevel == LogLevel.ERROR;
        }
        return false;
    }

    private ILogParentTreeNode findFirstFailureNodeInBranch(ILogTreeNode selectedNode, ILogParentTreeNode parentNode) {
        if (this.isFailureNode(parentNode) && !parentNode.equals(selectedNode)) {
            return parentNode;
        }
        for (ILogTreeNode childNode : parentNode.getChildren()) {
            ILogParentTreeNode foundNode;
            if (!(childNode instanceof ILogParentTreeNode) || (foundNode = this.findFirstFailureNodeInBranch(selectedNode, (ILogParentTreeNode)childNode)) == null) continue;
            return foundNode;
        }
        return null;
    }

    private ILogParentTreeNode findLastFailureNodeInBranch(ILogTreeNode selectedNode, ILogParentTreeNode parentNode) {
        if (parentNode.equals(selectedNode)) {
            return null;
        }
        int index = parentNode.getChildren().size() - 1;
        while (index >= 0) {
            ILogParentTreeNode foundNode;
            ILogTreeNode childNode = parentNode.getChildren().get(index);
            if (childNode instanceof ILogParentTreeNode && (foundNode = this.findLastFailureNodeInBranch(selectedNode, (ILogParentTreeNode)childNode)) != null) {
                return foundNode;
            }
            --index;
        }
        return this.isFailureNode(parentNode) && !parentNode.equals(selectedNode) ? parentNode : null;
    }

    private ILogParentTreeNode findSiblingNode(ILogTreeNode treeNode, boolean previousFlag) {
        if (treeNode == null) {
            return null;
        }
        if (treeNode.getParent() == null) {
            int index = this.rootNodes.indexOf(treeNode);
            if (index < 0) {
                return null;
            }
            if (previousFlag && index > 0) {
                return this.rootNodes.get(index - 1);
            }
            if (!previousFlag && index < this.rootNodes.size() - 1) {
                return this.rootNodes.get(index + 1);
            }
        } else {
            ILogParentTreeNode parentNode = treeNode.getParent();
            int index = parentNode.getChildren().indexOf(treeNode);
            if (previousFlag) {
                int i = index - 1;
                while (i >= 0) {
                    ILogTreeNode siblingNode = parentNode.getChildren().get(i);
                    if (siblingNode instanceof ILogParentTreeNode) {
                        return (ILogParentTreeNode)siblingNode;
                    }
                    --i;
                }
            } else {
                int i = index + 1;
                while (i < parentNode.getChildren().size()) {
                    ILogTreeNode siblingNode = parentNode.getChildren().get(i);
                    if (siblingNode instanceof ILogParentTreeNode) {
                        return (ILogParentTreeNode)siblingNode;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private boolean isAncentor(ILogParentTreeNode parentNode, ILogTreeNode treeNode) {
        if (parentNode == null) {
            return false;
        }
        if (parentNode.equals(treeNode.getParent())) {
            return true;
        }
        if (treeNode.getParent() != null) {
            return this.isAncentor(parentNode, treeNode.getParent());
        }
        return false;
    }

    private ILogParentTreeNode selectFailureRecursively(ILogTreeNode selectedNode, ILogTreeNode treeNode, boolean previousFlag) {
        ILogParentTreeNode qualifiedNodeFound = null;
        if (treeNode instanceof ILogParentTreeNode) {
            ILogParentTreeNode parentNode = (ILogParentTreeNode)treeNode;
            if (previousFlag) {
                if (this.isAncentor(parentNode, selectedNode)) {
                    if (this.isFailureNode(parentNode)) {
                        return parentNode;
                    }
                } else {
                    qualifiedNodeFound = this.findLastFailureNodeInBranch(selectedNode, parentNode);
                }
            } else if (!this.isAncentor(parentNode, selectedNode)) {
                qualifiedNodeFound = this.findFirstFailureNodeInBranch(selectedNode, parentNode);
            }
        }
        if (qualifiedNodeFound == null) {
            ILogParentTreeNode siblingNodeFound = this.findSiblingNode(treeNode, previousFlag);
            if (siblingNodeFound != null) {
                qualifiedNodeFound = this.selectFailureRecursively(selectedNode, siblingNodeFound, previousFlag);
            }
            if (qualifiedNodeFound == null && treeNode != null && treeNode.getParent() != null) {
                ILogParentTreeNode parentNode = treeNode.getParent();
                return this.selectFailureRecursively(selectedNode, parentNode, previousFlag);
            }
        }
        return qualifiedNodeFound;
    }

    public void selectPreviousFailure() {
        ILogTreeNode selectedNode;
        ILogParentTreeNode foundNode;
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        if (selection != null && (foundNode = this.selectFailureRecursively(selectedNode = (ILogTreeNode)selection.getFirstElement(), selectedNode, true)) != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)foundNode));
        }
    }

    public void selectNextFailure() {
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        ILogParentTreeNode foundNode = null;
        if (selection != null) {
            ILogTreeNode selectedNode = (ILogTreeNode)selection.getFirstElement();
            foundNode = this.selectFailureRecursively(selectedNode, selectedNode, false);
        } else {
            foundNode = this.selectFailureRecursively(null, this.rootNodes.get(0), false);
        }
        if (foundNode != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)foundNode));
        }
    }

    private void expandParentFailureRecursively(ILogParentTreeNode parentNode) {
        if (parentNode.getResult() == null && !parentNode.getElapsedTime().isEmpty() || this.isFailureNode(parentNode)) {
            this.setExpandedState(parentNode, true);
            for (ILogTreeNode childNode : parentNode.getChildren()) {
                if (!(childNode instanceof ILogParentTreeNode)) continue;
                this.expandParentFailureRecursively((ILogParentTreeNode)childNode);
            }
        }
    }

    public void expandAllFailures() {
        this.collapseAll();
        for (ILogParentTreeNode parentNode : this.rootNodes) {
            this.expandParentFailureRecursively(parentNode);
        }
    }

    private boolean isScrollLogEnable() {
        return !this.store.getBoolean("log.pinView");
    }
}

