/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.menu;

import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.menu.ExecutionHandledMenuItem;
import com.kms.katalon.composer.execution.menu.ExistingExecutionHandledMenuItem;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;

public abstract class AbstractExecutionMenuContribution {
    private static final String EXISTING_EXECUTION_COMMAND_ID = "com.kms.katalon.composer.execution.command.existing";
    private static final int DEFAULT_MAX_TITLE_WIDTH = 20;
    @Inject
    protected ECommandService commandService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        List exisingDrivers = ExecutionSessionSocketServer.getInstance().getAllAvailableExecutionSessionByDriverTypeName(this.getDriverTypeName());
        if (exisingDrivers.isEmpty()) {
            this.aboutToShowDefault(menuItems);
        } else {
            this.aboutToShowWithExisting(menuItems, exisingDrivers);
        }
    }

    protected void aboutToShowWithExisting(List<MMenuElement> menuItems, List<ExecutionSession> exisingDrivers) {
        MMenu executionMenu = this.createExecutionMenu();
        ExecutionHandledMenuItem defaultMenuItem = this.createDefaultMenuItem();
        defaultMenuItem.setLabel(ComposerExecutionMessageConstants.LBL_EXECUTION_NEW_SESSION);
        List executionMenuItems = executionMenu.getChildren();
        executionMenuItems.add(new ExecutionHandledMenuItem((MHandledMenuItem)defaultMenuItem));
        executionMenuItems.add(MMenuFactory.INSTANCE.createMenuSeparator());
        HashMap<String, Integer> labelMap = new HashMap<String, Integer>();
        for (ExecutionSession executionSession : exisingDrivers) {
            Map<String, Object> parameters = this.createParametersForExistingSession(executionSession);
            ParameterizedCommand executionCommand = this.commandService.createCommand(this.getExistingExecutionCommandId(), parameters);
            String abbreviatedLabel = this.getLabelForExecutionSession(executionSession);
            if (labelMap.containsKey(abbreviatedLabel)) {
                Integer numberOfInstances = (Integer)labelMap.get(abbreviatedLabel) + 1;
                labelMap.put(abbreviatedLabel, numberOfInstances);
                abbreviatedLabel = String.valueOf(abbreviatedLabel) + " (" + numberOfInstances + ")";
            } else {
                labelMap.put(abbreviatedLabel, 1);
            }
            MHandledMenuItem executionMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)executionCommand, (String)abbreviatedLabel, (String)ConstantsHelper.getApplicationURI());
            executionMenuItem.setIconURI(this.getIconUri());
            executionMenuItem.setTooltip(null);
            executionMenuItems.add(new ExistingExecutionHandledMenuItem(executionMenuItem));
        }
        menuItems.add((MMenuElement)executionMenu);
    }

    protected MMenu createExecutionMenu() {
        String menuLabel = this.getMenuLabel();
        String defaultItemLabel = ExecutionDefaultSettingStore.getStore().getExecutionConfiguration();
        if (defaultItemLabel.equals(menuLabel)) {
            menuLabel = String.valueOf(menuLabel) + " (default)";
        }
        MMenu executionMenu = MenuFactory.createPopupMenu((String)menuLabel, (String)ConstantsHelper.getApplicationURI());
        executionMenu.setIconURI(this.getIconUri());
        executionMenu.setTooltip(null);
        return executionMenu;
    }

    protected String getLabelForExecutionSession(ExecutionSession executionSession) {
        String executionTitle = executionSession.getTitle();
        if (executionTitle.isEmpty()) {
            executionTitle = ComposerExecutionMessageConstants.LBL_EXECUTION_EXISTING_SESSION_BLANK_TITLE;
        }
        return StringUtils.abbreviate((String)executionTitle, (int)20);
    }

    protected String getExistingExecutionCommandId() {
        return EXISTING_EXECUTION_COMMAND_ID;
    }

    public void aboutToShowDefault(List<MMenuElement> items) {
        items.add((MMenuElement)this.createDefaultMenuItem());
    }

    protected LaunchMode getLaunchMode() {
        return LaunchMode.RUN;
    }

    private Map<String, Object> createParametersForExistingSession(ExecutionSession executionSession) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("com.kms.katalon.composer.execution.existingSession.sessionId", executionSession.getSessionId());
        parameters.put("com.kms.katalon.composer.execution.existingSession.serverUrl", executionSession.getRemoteUrl());
        parameters.put("com.kms.katalon.composer.execution.existingSession.driverName", executionSession.getDriverTypeName());
        parameters.put("com.kms.katalon.composer.execution.runMode", this.getLaunchMode().toString());
        return parameters;
    }

    public ExecutionHandledMenuItem createDefaultMenuItem() {
        ParameterizedCommand executionCommand = this.commandService.createCommand(this.getCommandId(), this.getParametersForCommand());
        MHandledMenuItem executionMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)executionCommand, (String)this.getMenuLabel(), (String)ConstantsHelper.getApplicationURI());
        executionMenuItem.setTooltip(null);
        executionMenuItem.setIconURI(this.getIconUri());
        return new ExecutionHandledMenuItem(executionMenuItem);
    }

    protected Map<String, Object> getParametersForCommand() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("com.kms.katalon.composer.execution.runMode", this.getLaunchMode().toString());
        return parameters;
    }

    protected abstract String getIconUri();

    protected abstract String getDriverTypeName();

    protected abstract String getCommandId();

    protected abstract String getMenuLabel();
}

