/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.launcher;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.launcher.IDELaunchProcess;
import com.kms.katalon.composer.execution.launcher.IDELaunchShorcut;
import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.ExistingRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.e4.core.services.events.IEventBroker;

public class IDELauncher
extends ReportableLauncher
implements ILaunchListener,
IDEObservableLauncher {
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private boolean observed;
    private ILaunch launch;
    private LaunchMode mode;
    private boolean launchRemoved;

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDELauncher(LauncherManager manager, IRunConfiguration runConfig, LaunchMode mode) {
        super(manager, runConfig);
        this.mode = mode;
        this.observed = false;
    }

    public ReportableLauncher clone(IRunConfiguration newConfig) {
        return new IDELauncher(this.getManager(), newConfig, this.mode);
    }

    protected ILaunchProcess launch() throws ExecutionException {
        try {
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    IFile scriptFile = GroovyUtil.getTempScriptIFile((File)IDELauncher.this.getRunConfig().getExecutionSetting().getScriptFile(), (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                    if (scriptFile == null) {
                        return;
                    }
                    IDELauncher.this.launchRemoved = false;
                    ILaunch expectedLaunch = new IDELaunchShorcut().launch(scriptFile, IDELauncher.this.mode, IDELauncher.this.runConfig.getAdditionalEnvironmentVariables());
                    IDELauncher.this.launch = IDELauncher.this.launchRemoved ? null : expectedLaunch;
                }

                public void handleException(Throwable exception) {
                    LoggerSingleton.logError((Throwable)exception);
                }
            });
            IDELaunchProcess iDELaunchProcess = this.launch != null ? new IDELaunchProcess(this.launch) : null;
            return iDELaunchProcess;
        }
        finally {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        }
    }

    protected void onStartExecutionComplete() {
        super.onStartExecutionComplete();
        this.sendUpdateLogViewerEvent(this.getId());
        if (this.runConfig instanceof ExistingRunConfiguration) {
            this.pauseExecutionSession((ExistingRunConfiguration)this.runConfig);
        }
    }

    private void pauseExecutionSession(ExistingRunConfiguration runConfig) {
        ExecutionSession executionSession = ExecutionSessionSocketServer.getInstance().getExecutionSessionBySessionAndRemoteURL(runConfig.getSessionId(), runConfig.getRemoteUrl());
        if (executionSession != null) {
            executionSession.pause();
        }
    }

    public void setStatus(LauncherStatus status, String message) {
        super.setStatus(status, message);
        this.sendUpdateJobViewerEvent();
    }

    protected void onUpdateResult(TestStatus.TestStatusValue statusValue) {
        super.onUpdateResult(statusValue);
        this.sendUpdateJobViewerEvent();
    }

    @Override
    public void setObserved(boolean observed) {
        this.observed = observed;
    }

    @Override
    public boolean isObserved() {
        return this.observed;
    }

    protected void postExecutionComplete() {
        super.postExecutionComplete();
        this.sendUpdateJobViewerEvent();
        this.eventBroker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
        this.updateReport();
        if (this.runConfig instanceof ExistingRunConfiguration) {
            this.resumeExecutionSession((ExistingRunConfiguration)this.runConfig);
        } else {
            this.resumeExecutionSession(this.runConfig);
        }
    }

    private void resumeExecutionSession(IRunConfiguration runConfig) {
        ExecutionSession executionSession = ExecutionSessionSocketServer.getInstance().getExecutionSessionByLogFolderPath(runConfig.getExecutionSetting().getFolderPath());
        if (executionSession != null) {
            executionSession.resume();
        }
    }

    private void resumeExecutionSession(ExistingRunConfiguration runConfig) {
        ExecutionSession executionSession = ExecutionSessionSocketServer.getInstance().getExecutionSessionBySessionAndRemoteURL(runConfig.getSessionId(), runConfig.getRemoteUrl());
        if (executionSession != null) {
            executionSession.resume();
        }
    }

    protected void updateReport() {
        try {
            if (this.getTestSuite() == null || this.getStatus() != LauncherStatus.DONE) {
                return;
            }
            ReportEntity report = ReportController.getInstance().getReportEntity(this.getTestSuite(), this.getId());
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", null);
            if (ExecutionDefaultSettingStore.getStore().isPostExecOpenReport()) {
                this.eventBroker.post("REPORT/OPEN", (Object)report);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void updateLastRun(Date startTime) throws Exception {
        super.updateLastRun(startTime);
        TestSuiteEntity testSuite = this.getTestSuite();
        this.eventBroker.send("TESTSUITE/UPDATED", (Object)new Object[]{testSuite.getId(), testSuite});
    }

    public void clean() {
        try {
            IDELaunchShorcut.cleanConfiguration(this.getLaunch());
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            IFile scriptFile = GroovyUtil.getTempScriptIFile((File)this.getRunConfig().getExecutionSetting().getScriptFile(), (ProjectEntity)currentProject);
            if (scriptFile == null) {
                return;
            }
            scriptFile.delete(true, null);
            IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)currentProject);
            libFolder.refreshLocal(1, null);
            if (this.isObserved()) {
                this.sendUpdateLogViewerEvent(null);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void sendUpdateLogViewerEvent(String message) {
        this.eventBroker.send("CONSOLE_LOG/RESET", (Object)message);
    }

    protected void sendUpdateJobViewerEvent() {
        this.eventBroker.post("JOB/REFRESH", null);
    }

    protected synchronized void writeError(String line) {
        LogUtil.logErrorMessage((String)line);
    }

    private boolean isExpectedLaunch(ILaunch launch) {
        String expectedName = FilenameUtils.getBaseName((String)this.getRunConfig().getExecutionSetting().getScriptFile().getName());
        ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
        return launchConfig != null && expectedName.equals(launchConfig.getName());
    }

    @Override
    public LaunchMode getMode() {
        return this.mode;
    }

    public void launchRemoved(ILaunch launch) {
        if (this.isExpectedLaunch(launch)) {
            this.launchRemoved = true;
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    @Override
    public void suspend() {
        try {
            this.getLaunch().getDebugTarget().suspend();
            this.onSuspended();
        }
        catch (DebugException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void onSuspended() {
        this.setStatus(LauncherStatus.SUSPENDED);
        this.sendUpdateJobViewerEvent();
    }

    @Override
    public void resume() {
        try {
            this.getLaunch().getDebugTarget().resume();
            this.setStatus(LauncherStatus.RUNNING);
            this.sendUpdateJobViewerEvent();
        }
        catch (DebugException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public String getDisplayMessage() {
        String currentStatusMessage = this.getMessage();
        String displayMessage = StringUtils.isNotEmpty((String)currentStatusMessage) ? currentStatusMessage : this.getStatus().toString();
        return "<" + displayMessage + ">" + " - " + this.getRunConfig().getName();
    }

    protected void onStartExecution() {
        super.onStartExecution();
    }
}

