/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.jobs;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.exceptions.JobCancelException;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.execution.launcher.IDELauncher;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;

public class ExecuteTestCaseJob
extends Job {
    protected final UISynchronize sync;
    protected final IRunConfiguration runConfig;
    protected final TestCaseEntity testCase;
    protected final LaunchMode launchMode;

    public ExecuteTestCaseJob(String name, IRunConfiguration runConfig, TestCaseEntity testCase, LaunchMode launchMode, UISynchronize sync) {
        super(name);
        this.runConfig = runConfig;
        this.testCase = testCase;
        this.launchMode = launchMode;
        this.sync = sync;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(StringConstants.HAND_JOB_LAUNCHING_TEST_CASE, 3);
            monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
            this.activateViewers();
            ExecuteTestCaseJob.validateJobProgressMonitor(monitor);
            monitor.worked(1);
            monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
            this.buildScripts();
            ExecuteTestCaseJob.validateJobProgressMonitor(monitor);
            this.startLauncher();
            Trackings.trackExecuteTestCase((String)this.launchMode.toString(), (String)this.runConfig.getName());
            monitor.worked(1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (JobCancelException jobCancelException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_CASE, (String)StringConstants.HAND_ERROR_MSG_REASON_WRONG_SYNTAX);
                }
            });
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected void startLauncher() {
        LauncherManager launcherManager = LauncherManager.getInstance();
        IDELauncher launcher = new IDELauncher(launcherManager, this.runConfig, this.launchMode);
        launcherManager.addLauncher((ILauncher)launcher);
    }

    protected void activateViewers() {
        AbstractExecutionHandler.openConsoleLog();
    }

    protected void buildScripts() throws IOException, ExecutionException {
        this.runConfig.build((FileEntity)this.testCase, (IExecutedEntity)new TestCaseExecutedEntity(this.testCase));
    }

    private static void validateJobProgressMonitor(IProgressMonitor monitor) throws JobCancelException {
        if (monitor.isCanceled()) {
            throw new JobCancelException();
        }
    }
}

