/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.kms.katalon.composer.execution.dialog.GenerateCommandDialog;
import com.kms.katalon.controller.ProjectController;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class GenerateCommandHandler {
    private ProjectController pController = ProjectController.getInstance();
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEvent() {
        this.eventBroker.subscribe("KATALON/GENERATE_COMMAND", new EventHandler(){

            public void handleEvent(Event event) {
                GenerateCommandHandler.this.execute();
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return this.isProjectOpened();
    }

    @Execute
    public void execute() {
        if (!this.isProjectOpened()) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        GenerateCommandDialog dialog = new GenerateCommandDialog(shell, this.pController.getCurrentProject());
        dialog.open();
    }

    private boolean isProjectOpened() {
        return this.pController.getCurrentProject() != null;
    }
}

