/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.ExistingRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import java.io.IOException;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.commands.ParameterizedCommand;

public class ExistingExecutionHandler
extends AbstractExecutionHandler {
    private String sessionId;
    private String remoteServerUrl;
    private String driverTypeName;

    @Override
    protected IRunConfiguration getRunConfigurationForExecution(String projectDir) throws IOException, ExecutionException, InterruptedException {
        return new ExistingRunConfiguration(projectDir);
    }

    @Override
    public void execute(ParameterizedCommand command) {
        this.sessionId = this.getSessionId(command);
        this.remoteServerUrl = this.getServerUrl(command);
        this.driverTypeName = this.getDriverTypeName(command);
        super.execute(command);
    }

    private String getSessionId(ParameterizedCommand command) {
        return this.getParameter(command, "com.kms.katalon.composer.execution.existingSession.sessionId");
    }

    protected String getParameter(ParameterizedCommand command, String parameterId) {
        return ObjectUtils.toString(command.getParameterMap().get(parameterId));
    }

    protected String getServerUrl(ParameterizedCommand command) {
        return this.getParameter(command, "com.kms.katalon.composer.execution.existingSession.serverUrl");
    }

    protected String getDriverTypeName(ParameterizedCommand command) {
        return this.getParameter(command, "com.kms.katalon.composer.execution.existingSession.driverName");
    }

    @Override
    public void executeTestCase(TestCaseEntity testCase, LaunchMode launchMode, IRunConfiguration runConfig) throws Exception {
        this.prepareData(runConfig);
        super.executeTestCase(testCase, launchMode, runConfig);
    }

    @Override
    public void executeTestSuite(TestSuiteEntity testSuite, LaunchMode launchMode, IRunConfiguration runConfig) throws Exception {
        this.prepareData(runConfig);
        super.executeTestSuite(testSuite, launchMode, runConfig);
    }

    protected void prepareData(IRunConfiguration runConfig) {
        ExistingRunConfiguration existingRunConfiguration = (ExistingRunConfiguration)runConfig;
        existingRunConfiguration.setSessionId(this.sessionId);
        existingRunConfiguration.setRemoteUrl(this.remoteServerUrl);
        existingRunConfiguration.setDriverName(this.driverTypeName);
    }
}

