/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.execution.menu.AbstractExecutionMenuContribution;
import com.kms.katalon.composer.execution.menu.ExecutionHandledMenuItem;
import com.kms.katalon.composer.execution.menu.ExistingExecutionHandledMenuItem;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.util.ExecutionUtil;
import java.io.IOException;
import java.text.MessageFormat;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExecuteHandler
extends AbstractExecutionHandler {
    private static final String TEMP_ID = "tempId";
    @Inject
    private IContributionFactory contributionFactory;
    private MMenu runMenu;
    private MMenu debugMenu;

    @Override
    protected IRunConfiguration getRunConfigurationForExecution(String projectDir) throws IOException {
        return null;
    }

    private MMenu getRunMenu() {
        if (this.runMenu == null) {
            MHandledToolItem runToolItem = (MHandledToolItem)modelService.find("com.kms.katalon.composer.execution.handledtoolitem.run", (MUIElement)application);
            this.runMenu = runToolItem.getMenu();
        }
        return this.runMenu;
    }

    private MMenu getDebugMenu() {
        if (this.runMenu == null) {
            MHandledToolItem debugToolItem = (MHandledToolItem)modelService.find("com.kms.katalon.composer.execution.handledtoolitem.debug", (MUIElement)application);
            this.debugMenu = debugToolItem.getMenu();
        }
        return this.debugMenu;
    }

    private MMenu getMenu(LaunchMode launchMode) {
        MMenu menu = null;
        if (launchMode == LaunchMode.RUN) {
            menu = this.getRunMenu();
        }
        if (launchMode == LaunchMode.DEBUG) {
            menu = this.getDebugMenu();
        }
        return menu;
    }

    @Override
    @Execute
    public void execute(ParameterizedCommand command) {
        try {
            LaunchMode launchMode = this.getLaunchMode(command);
            IRunConfigurationContributor defaultRunContributor = ExecutionUtil.getDefaultExecutionConfiguration();
            if (defaultRunContributor == null) {
                return;
            }
            MMenu menu = this.getMenu(launchMode);
            ExecutionHandledMenuItem defaultMenuItem = this.findDefaultMenuItem(menu);
            if (defaultMenuItem == null) {
                return;
            }
            handlerService.executeHandler(defaultMenuItem.getParameterizedCommandFromMenuItem(commandService));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_TEST_SCRIPT_ROOT_CAUSE, e.getMessage()));
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private ExecutionHandledMenuItem findDefaultMenuItem(MMenu parentMenu) {
        for (MMenuElement menuItem : parentMenu.getChildren()) {
            ExecutionHandledMenuItem contributionDefaultMenuItem;
            ExecutionHandledMenuItem result;
            ExecutionHandledMenuItem handledMenuItem;
            if (menuItem instanceof ExecutionHandledMenuItem && !(menuItem instanceof ExistingExecutionHandledMenuItem) && (handledMenuItem = (ExecutionHandledMenuItem)menuItem).isDefault() && handledMenuItem.getCommand() != null) {
                return handledMenuItem;
            }
            if (menuItem instanceof MMenu && (result = this.findDefaultMenuItem((MMenu)menuItem)) != null) {
                return result;
            }
            if (!(menuItem instanceof MDynamicMenuContribution)) continue;
            MDynamicMenuContribution dynamicMenuContribution = (MDynamicMenuContribution)menuItem;
            Object contribution = dynamicMenuContribution.getObject();
            if (contribution == null) {
                IEclipseContext context = modelService.getContainingContext((MUIElement)parentMenu);
                contribution = this.contributionFactory.create(dynamicMenuContribution.getContributionURI(), context);
            }
            if (!(contribution instanceof AbstractExecutionMenuContribution) || !(contributionDefaultMenuItem = ((AbstractExecutionMenuContribution)contribution).createDefaultMenuItem()).isDefault()) continue;
            contributionDefaultMenuItem.setElementId(TEMP_ID + System.currentTimeMillis());
            return contributionDefaultMenuItem;
        }
        return null;
    }
}

