/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.katalon.platform.api.exception.PlatformException;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.ExecutionProfileManager;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.exceptions.JobCancelException;
import com.kms.katalon.composer.execution.jobs.ExecuteTestCaseJob;
import com.kms.katalon.composer.execution.launcher.IDELaunchShorcut;
import com.kms.katalon.composer.execution.launcher.IDELauncher;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteCompositePart;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.entity.FeatureFileExecutedEntity;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.exception.ExtensionRequiredException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.menu.impl.ToolControlImpl;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractExecutionHandler {
    @Inject
    protected static EPartService partService;
    @Inject
    protected static EModelService modelService;
    @Inject
    protected static ECommandService commandService;
    @Inject
    protected static EHandlerService handlerService;
    @Inject
    protected static MApplication application;
    @Inject
    protected static IEventBroker eventBroker;
    @Inject
    protected static UISynchronize sync;

    @Inject
    public void start() {
        eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    IDELaunchShorcut.cleanAllConfigurations();
                }
                catch (CoreException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        block4: {
            block6: {
                String partElementId;
                MPart part;
                block7: {
                    MPartStack composerStack;
                    block5: {
                        if (ProjectController.getInstance().getCurrentProject() == null) break block4;
                        composerStack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)application);
                        if (composerStack != null) break block5;
                        return false;
                    }
                    if (!composerStack.isVisible() || composerStack.getSelectedElement() == null) break block6;
                    part = (MPart)composerStack.getSelectedElement();
                    partElementId = part.getElementId();
                    if (!partElementId.startsWith("com.kms.katalon.composer.content.testcase") && !partElementId.startsWith("com.kms.katalon.composer.content.testsuite")) break block7;
                    return true;
                }
                try {
                    CompatibilityEditor editor;
                    if (!partElementId.startsWith("org.eclipse.e4.ui.compatibility.editor") || !"cucumber.eclipse.editor.editors.Editor".equals((editor = (CompatibilityEditor)part.getObject()).getReference().getId())) break block6;
                    return true;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
            return false;
        }
        return false;
    }

    protected LaunchMode getLaunchMode(ParameterizedCommand command) {
        String launchModeAsString = ObjectUtils.toString(command.getParameterMap().get("com.kms.katalon.composer.execution.runMode"));
        return LaunchMode.fromText((String)launchModeAsString);
    }

    @Execute
    public void execute(ParameterizedCommand command) {
        try {
            this.execute(this.getLaunchMode(command));
        }
        catch (ExecutionException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)e.getMessage());
        }
        catch (SWTException sWTException) {
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_TEST_SCRIPT_ROOT_CAUSE, e.getMessage()));
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static Entity getExecutionTarget() throws DALException {
        MPartStack composerStack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)application);
        MPart selectedPart = (MPart)composerStack.getSelectedElement();
        if (AbstractExecutionHandler.saveAllParts() && AbstractExecutionHandler.isAnyPartDirty()) {
            CompatibilityEditor editor;
            String partElementId = selectedPart.getElementId();
            if (partElementId.startsWith("com.kms.katalon.composer.content.testcase") && selectedPart.getObject() instanceof TestCaseCompositePart) {
                TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)selectedPart.getObject();
                try {
                    testCaseCompositePart.validateScriptErrors();
                }
                catch (Exception exception) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_ERROR_IN_SCRIPT);
                    return null;
                }
                if (testCaseCompositePart.isTestCaseEmpty()) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_TITLE_INFORMATION, (String)StringConstants.HAND_INFO_MSG_NO_TEST_STEP_IN_TEST_CASE);
                    return null;
                }
                return testCaseCompositePart.getOriginalTestCase();
            }
            if (partElementId.startsWith("com.kms.katalon.composer.content.testsuite") && selectedPart.getObject() instanceof ParentTestSuiteCompositePart) {
                ParentTestSuiteCompositePart testSuiteComposite = (ParentTestSuiteCompositePart)selectedPart.getObject();
                TestSuiteEntity originalTestSuite = testSuiteComposite.getOriginalTestSuite();
                if (originalTestSuite instanceof FilteringTestSuiteEntity) {
                    return originalTestSuite;
                }
                if (originalTestSuite.getTestSuiteTestCaseLinks().isEmpty()) {
                    if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_TITLE_INFORMATION, (String)StringConstants.HAND_CONFIRM_MSG_NO_TEST_CASE_IN_TEST_SUITE)) {
                        ((TestSuiteCompositePart)testSuiteComposite).openAddTestCaseDialog();
                    }
                    return null;
                }
                return originalTestSuite;
            }
            if (partElementId.startsWith("com.kms.katalon.composer.content.testsuite") && selectedPart.getObject() instanceof TestSuiteCompositePart) {
                TestSuiteCompositePart testSuiteComposite = (TestSuiteCompositePart)selectedPart.getObject();
                if (testSuiteComposite.getOriginalTestSuite().getTestSuiteTestCaseLinks().isEmpty()) {
                    if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.HAND_TITLE_INFORMATION, (String)StringConstants.HAND_CONFIRM_MSG_NO_TEST_CASE_IN_TEST_SUITE)) {
                        testSuiteComposite.openAddTestCaseDialog();
                    }
                    return null;
                }
                return testSuiteComposite.getOriginalTestSuite();
            }
            if (partElementId.startsWith("org.eclipse.e4.ui.compatibility.editor") && "cucumber.eclipse.editor.editors.Editor".equals((editor = (CompatibilityEditor)selectedPart.getObject()).getReference().getId())) {
                FileEditorInput editorInput = (FileEditorInput)editor.getEditor().getEditorInput();
                String featureFilePath = new File(editorInput.getFile().getRawLocationURI()).getAbsolutePath();
                try {
                    return SystemFileController.getInstance().getSystemFile(featureFilePath, ProjectController.getInstance().getCurrentProject());
                }
                catch (ControllerException e) {
                    LogUtil.logError((Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    protected static boolean isAnyPartDirty() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getDirtyEditors().length == 0 && partService.getDirtyParts().isEmpty();
    }

    protected static boolean saveAllParts() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false) && partService.saveAll(false);
    }

    protected abstract IRunConfiguration getRunConfigurationForExecution(String var1) throws IOException, ExecutionException, InterruptedException;

    public void execute(LaunchMode launchMode) throws Exception {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            AbstractRunConfiguration runConfiguration = (AbstractRunConfiguration)this.getRunConfigurationForExecution(projectDir);
            if (runConfiguration == null) {
                return;
            }
            runConfiguration.setExecutionProfile(ExecutionProfileManager.getInstance().getSelectedProfile());
            this.execute(launchMode, (IRunConfiguration)runConfiguration);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void execute(LaunchMode launchMode, IRunConfiguration runConfiguration) throws Exception {
        Entity targetEntity = AbstractExecutionHandler.getExecutionTarget();
        if (targetEntity == null) {
            return;
        }
        if (targetEntity instanceof TestCaseEntity) {
            TestCaseEntity testCase = (TestCaseEntity)targetEntity;
            this.executeTestCase(testCase, launchMode, runConfiguration);
            eventBroker.post("EXECUTE/EXECUTE_TEST_CASE", null);
        } else if (targetEntity instanceof TestSuiteEntity) {
            TestSuiteEntity testSuite = (TestSuiteEntity)targetEntity;
            this.executeTestSuite(testSuite, launchMode, runConfiguration);
            eventBroker.post("EXECUTE/EXECUTE_TEST_SUITE", null);
        } else if (targetEntity instanceof SystemFileEntity) {
            SystemFileEntity feature = (SystemFileEntity)targetEntity;
            this.executeFeatureFile(feature, launchMode, runConfiguration);
        }
    }

    public void executeFeatureFile(final SystemFileEntity feature, final LaunchMode launchMode, final IRunConfiguration runConfig) throws Exception {
        Job job = new Job(ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_JOB_LAUNCHING_FEATURE_FILE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_JOB_LAUNCHING_FEATURE_FILE, 3);
                    FeatureFileExecutedEntity testSuiteExecutedEntity = new FeatureFileExecutedEntity(feature);
                    monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
                    AbstractExecutionHandler.openConsoleLog();
                    AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                    monitor.worked(1);
                    monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
                    runConfig.build((FileEntity)feature, (IExecutedEntity)testSuiteExecutedEntity);
                    AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                    monitor.worked(1);
                    monitor.subTask(ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_JOB_LAUNCHING_FEATURE_FILE);
                    LauncherManager launcherManager = LauncherManager.getInstance();
                    IDELauncher launcher = new IDELauncher(launcherManager, runConfig, launchMode);
                    launcherManager.addLauncher((ILauncher)launcher);
                    monitor.worked(1);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (JobCancelException jobCancelException) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    sync.syncExec(() -> MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerExecutionMessageConstants.AbstractExecutionHandler_HAND_MSG_UNABLE_TO_EXECUTE_FEATURE_FILE, (String)e.getMessage()));
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void executeTestCase(TestCaseEntity testCase, LaunchMode launchMode, IRunConfiguration runConfig) throws Exception {
        if (testCase == null) {
            return;
        }
        ExecuteTestCaseJob job = new ExecuteTestCaseJob(StringConstants.HAND_JOB_LAUNCHING_TEST_CASE, runConfig, testCase, launchMode, sync);
        job.setUser(true);
        job.schedule();
    }

    public void executeTestSuite(final TestSuiteEntity testSuite, final LaunchMode launchMode, final IRunConfiguration runConfig) throws Exception {
        if (testSuite == null) {
            return;
        }
        final Job job = new Job(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE, 5);
                    monitor.subTask(StringConstants.HAND_JOB_VALIDATING_TEST_SUITE);
                    TestSuiteExecutedEntity testSuiteExecutedEntity = new TestSuiteExecutedEntity(testSuite);
                    monitor.subTask("Preparing test cases...");
                    testSuiteExecutedEntity.prepareTestCases();
                    int totalTestCases = testSuiteExecutedEntity.getTotalTestCases();
                    if (totalTestCases > 0) {
                        monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
                        AbstractExecutionHandler.openConsoleLog();
                        AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                        monitor.worked(1);
                        monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
                        runConfig.build((FileEntity)testSuite, (IExecutedEntity)testSuiteExecutedEntity);
                        AbstractExecutionHandler.this.validateJobProgressMonitor(monitor);
                        monitor.worked(1);
                        monitor.subTask(StringConstants.HAND_JOB_LAUNCHING_TEST_SUITE);
                        LauncherManager launcherManager = LauncherManager.getInstance();
                        IDELauncher launcher = new IDELauncher(launcherManager, runConfig, launchMode);
                        launcherManager.addLauncher((ILauncher)launcher);
                        AbstractExecutionHandler.this.trackTestSuiteExecution(launchMode, runConfig, testSuiteExecutedEntity.getEmailSettings().getEmailConfig().isSendEmailTestFailedOnly());
                        monitor.worked(1);
                        monitor.done();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.WARN_TITLE, (String)StringConstants.HAND_WARN_MSG_NO_TEST_CASE_SELECTED);
                        }
                    });
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (JobCancelException jobCancelException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                catch (ExtensionRequiredException e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getMessage());
                    return status;
                }
                catch (PlatformException e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getDetailMessage(), (Throwable)e);
                    return status;
                }
                catch (Exception e) {
                    Status status = new Status(2, FrameworkUtil.getBundle(AbstractExecutionHandler.class).getSymbolicName(), e.getMessage(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (event.getResult() != null && event.getResult().matches(2)) {
                    sync.asyncExec(() -> {
                        if (event.getResult().getException() == null) {
                            MessageDialog.openInformation(null, (String)StringConstants.WARN_TITLE, (String)event.getResult().getMessage());
                        } else {
                            MultiStatusErrorDialog.showErrorDialog((String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_SUITE, (String)event.getResult().getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)event.getResult().getException()));
                        }
                    });
                }
                job.removeJobChangeListener((IJobChangeListener)this);
            }
        });
    }

    private void trackTestSuiteExecution(LaunchMode launchMode, IRunConfiguration runConfig, boolean testFailedOnly) {
        Trackings.trackExecuteTestSuiteInGuiMode((String)launchMode.toString(), (String)runConfig.getName());
    }

    public static void openConsoleLog() {
        IPreferenceStore debugUIPreferences = DebugUIPlugin.getDefault().getPreferenceStore();
        debugUIPreferences.setValue("DEBUG.consoleOpenOnErr", false);
        debugUIPreferences.setValue("DEBUG.consoleOpenOnOut", false);
        debugUIPreferences.setValue("org.eclipse.debug.ui.auto_remove_old_launches", false);
        sync.syncExec(new Runnable(){

            @Override
            public void run() {
                ToolControlImpl toolControl;
                MPart consoleLogPart;
                List psList = modelService.findElements((MUIElement)application, null, MPerspectiveStack.class, null);
                MPartStack consolePartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.console", ((MPerspectiveStack)psList.get(0)).getSelectedElement());
                consolePartStack.getTags().remove("Minimized");
                consolePartStack.setVisible(true);
                if (!consolePartStack.isToBeRendered()) {
                    consolePartStack.setToBeRendered(true);
                }
                if ((consoleLogPart = (MPart)modelService.find("com.kms.katalon.partstack.console.log", (MUIElement)consolePartStack)) != null && consolePartStack.getSelectedElement() != consoleLogPart) {
                    consolePartStack.setSelectedElement((MUIElement)consoleLogPart);
                }
                MPartStack rightPartStack = (MPartStack)modelService.find("com.kms.katalon.partstack.outline", (MUIElement)application);
                MPart jobViewerPart = (MPart)modelService.find("com.kms.katalon.composer.execution.part.job", (MUIElement)rightPartStack);
                if (rightPartStack.getSelectedElement() != jobViewerPart) {
                    rightPartStack.setSelectedElement((MUIElement)jobViewerPart);
                }
                if ((toolControl = (ToolControlImpl)modelService.find("com.kms.katalon.partstack.outline(com.kms.katalon.composer.window.main).(com.kms.katalon.composer.perspective.keyword)", (MUIElement)application)).getObject() != null) {
                    TrimStack trimStack = (TrimStack)toolControl.getObject();
                    trimStack.showStack(true);
                }
            }
        });
    }

    public UISynchronize getSync() {
        return sync;
    }

    void validateJobProgressMonitor(IProgressMonitor monitor) throws JobCancelException {
        if (monitor.isCanceled()) {
            throw new JobCancelException();
        }
    }
}

