/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.dialog;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.execution.collection.collector.TestExecutionGroupCollector;
import com.kms.katalon.composer.execution.collection.dialog.ExecutionProfileSelectionDialog;
import com.kms.katalon.composer.execution.collection.dialog.RunConfigurationSelectionDialog;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionEntryItem;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionGroup;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionItem;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.dialog.TestSuiteSelectionDialog;
import com.kms.katalon.composer.explorer.providers.EntityLabelProvider;
import com.kms.katalon.composer.explorer.providers.EntityProvider;
import com.kms.katalon.composer.explorer.providers.EntityViewerFilter;
import com.kms.katalon.composer.resources.util.ImageUtil;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.ConsoleOptionBuilder;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenerateCommandDialog
extends AbstractDialog {
    private static final String KATALON_EXECUTABLE_LINUX = "./katalon --args";
    private static final String KATALON_EXECUTABLE_WIN32 = "katalon";
    private static final String KATALON_EXECUTABLE_MACOS = "./Katalon\\ Studio.app/Contents/MacOS/katalon --args";
    private static final int GENERATE_PROPERTY_ID = 22;
    private static final int GENERATE_COMMAND_ID = 23;
    private Text txtTestSuite;
    private Text txtRetry;
    private Text txtStatusDelay;
    private Button btnBrowseTestSuite;
    private Button chkDisplayConsoleLog;
    private Button chkKeepConsoleLog;
    private Button chkRetryFailedTestCase;
    private ProjectEntity project;
    private static final String ZERO = "0";
    private static final String DEFAULT_RETRY_TIME = Integer.toString(0);
    private static final String defaultStatusDelay = Integer.toString(15);
    private static final String defaultPropertyFileName = "console.properties";
    private static final String ARG_RUN_MODE = "runMode";
    private static final String ARG_PROJECT_PATH = "projectPath";
    private static final String ARG_OSGI_CONSOLE_LOG = "consoleLog";
    private static final String ARG_OSGI_NO_EXIT = "noExit";
    private static final String ARG_STATUS_DELAY = "statusDelay";
    private static final String ARG_TEST_SUITE_PATH = "testSuitePath";
    private static final String ARG_TEST_SUITE_COLLECTION_PATH = "testSuiteCollectionPath";
    private static final String ARG_RETRY = "retry";
    private static final String ARG_RETRY_FAILED_TEST_CASES = "retryFailedTestCases";
    private Group grpPlatform;
    private Composite main;
    private CLabel lblRunConfiguration;
    private CLabel lblConfigurationData;
    private Button btnChangeRunConfigurationData;
    private Button btnChangeConfiguration;
    private TestExecutionEntryItem testExecutionItem;
    private RunConfigurationDescription runConfigDescription;
    private Composite configurationDataComposite;
    private Composite configurationComposite;
    private CLabel lblProfileName;
    private Button btnChangeProfile;

    public GenerateCommandDialog(Shell parentShell, ProjectEntity project) {
        super(parentShell);
        this.setDialogTitle(com.kms.katalon.composer.execution.constants.StringConstants.DIA_TITLE_GENERATE_COMMAND_FOR_CONSOLE);
        this.project = project;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected int getShellStyle() {
        return 0x8860 | GenerateCommandDialog.getDefaultOrientation() | 0x10;
    }

    protected Control createDialogContainer(Composite parent) {
        this.main = new Composite(parent, 0);
        GridLayout glMain = new GridLayout();
        glMain.marginHeight = 0;
        glMain.marginWidth = 0;
        this.main.setLayout((Layout)glMain);
        this.createTestSuitePart(this.main);
        this.createPlatformPart(this.main);
        this.createOptionsPart(this.main);
        return this.main;
    }

    private void createTestSuitePart(Composite parent) {
        Composite testsuiteContainer = new Composite(parent, 0);
        testsuiteContainer.setLayout((Layout)new GridLayout(3, false));
        testsuiteContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTestSuite = new Label(testsuiteContainer, 0);
        lblTestSuite.setText(com.kms.katalon.composer.execution.constants.StringConstants.TEST_SUITE);
        this.txtTestSuite = new Text(testsuiteContainer, 2056);
        this.txtTestSuite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnBrowseTestSuite = new Button(testsuiteContainer, 0x800000);
        this.btnBrowseTestSuite.setText(com.kms.katalon.composer.execution.constants.StringConstants.BROWSE);
    }

    private void createPlatformPart(Composite parent) {
        Composite platformContainer = new Composite(parent, 0);
        GridLayout glPlatformContainer = new GridLayout(1, false);
        glPlatformContainer.marginHeight = 0;
        platformContainer.setLayout((Layout)glPlatformContainer);
        platformContainer.setLayoutData((Object)new GridData(768));
        this.grpPlatform = new Group(platformContainer, 0);
        this.grpPlatform.setLayout((Layout)new GridLayout(1, false));
        this.grpPlatform.setLayoutData((Object)new GridData(768));
        this.grpPlatform.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_GRP_EXECUTED_PLATFORM);
        this.createConfigurationComposite();
        this.createConfigurationDataComposite();
        this.createExecutionProfileComposite();
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject.getType() == ProjectType.WEBSERVICE) {
            ((GridData)this.configurationComposite.getLayoutData()).exclude = true;
            this.configurationComposite.setVisible(false);
            ((GridData)this.configurationDataComposite.getLayoutData()).exclude = true;
            this.configurationDataComposite.setVisible(false);
        }
    }

    private void createExecutionProfileComposite() {
        Composite executionComposite = new Composite((Composite)this.grpPlatform, 0);
        executionComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdExecutionComposite = new GridLayout(2, false);
        gdExecutionComposite.marginWidth = 0;
        gdExecutionComposite.marginHeight = 0;
        executionComposite.setLayout((Layout)gdExecutionComposite);
        Label lblRunWith = new Label(executionComposite, 0);
        lblRunWith.setLayoutData((Object)new GridData(36));
        lblRunWith.setText(ComposerExecutionMessageConstants.DIA_LBL_PROFILE);
        Composite profileDetailsComposite = new Composite(executionComposite, 0);
        profileDetailsComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfiguration = new GridLayout(2, false);
        gdConfiguration.marginWidth = 0;
        gdConfiguration.marginHeight = 0;
        profileDetailsComposite.setLayout((Layout)gdConfiguration);
        this.lblProfileName = new CLabel(profileDetailsComposite, 0);
        this.lblProfileName.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.btnChangeProfile = new Button(profileDetailsComposite, 0x800000);
        this.btnChangeProfile.setImage(ImageConstants.IMG_16_EDIT);
        this.btnChangeProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnChangeProfile.setText(com.kms.katalon.composer.execution.constants.StringConstants.EDIT);
    }

    private void createConfigurationComposite() {
        this.configurationComposite = new Composite((Composite)this.grpPlatform, 0);
        this.configurationComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfigurationData = new GridLayout(2, false);
        gdConfigurationData.marginWidth = 0;
        gdConfigurationData.marginHeight = 0;
        this.configurationComposite.setLayout((Layout)gdConfigurationData);
        Label lblRunWith = new Label(this.configurationComposite, 0);
        lblRunWith.setLayoutData((Object)new GridData(36));
        lblRunWith.setText(ComposerExecutionMessageConstants.DIA_LBL_RUN_WITH);
        Composite configurationDetailsComposite = new Composite(this.configurationComposite, 0);
        configurationDetailsComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfiguration = new GridLayout(2, false);
        gdConfiguration.marginWidth = 0;
        gdConfiguration.marginHeight = 0;
        configurationDetailsComposite.setLayout((Layout)gdConfiguration);
        this.lblRunConfiguration = new CLabel(configurationDetailsComposite, 0);
        this.lblRunConfiguration.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.lblRunConfiguration.setText(ComposerExecutionMessageConstants.DIA_TITLE_RUN_CONFIG_SELECTION);
        this.btnChangeConfiguration = new Button(configurationDetailsComposite, 0x800000);
        this.btnChangeConfiguration.setImage(ImageConstants.IMG_16_EDIT);
        this.btnChangeConfiguration.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnChangeConfiguration.setText(com.kms.katalon.composer.execution.constants.StringConstants.EDIT);
    }

    private void createConfigurationDataComposite() {
        this.configurationDataComposite = new Composite((Composite)this.grpPlatform, 0);
        this.configurationDataComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfigurationData = new GridLayout(2, false);
        gdConfigurationData.marginWidth = 0;
        gdConfigurationData.marginHeight = 0;
        this.configurationDataComposite.setLayout((Layout)gdConfigurationData);
        Label lblRunConfiguration = new Label(this.configurationDataComposite, 0);
        lblRunConfiguration.setLayoutData((Object)new GridData(36));
        lblRunConfiguration.setText(ComposerExecutionMessageConstants.DIA_LBL_RUN_CONFIGURATION);
        Composite configurationDataDetails = new Composite(this.configurationDataComposite, 0);
        configurationDataDetails.setLayoutData((Object)new GridData(768));
        GridLayout gdConfigurationDataDetails = new GridLayout(2, false);
        gdConfigurationDataDetails.marginWidth = 0;
        gdConfigurationDataDetails.marginHeight = 0;
        configurationDataDetails.setLayout((Layout)gdConfigurationDataDetails);
        this.lblConfigurationData = new CLabel(configurationDataDetails, 0);
        this.lblConfigurationData.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.lblConfigurationData.setText(ComposerExecutionMessageConstants.DIA_MSG_CONFIGURATION_IS_REQUIRED);
        this.btnChangeRunConfigurationData = new Button(configurationDataDetails, 0x800000);
        this.btnChangeRunConfigurationData.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnChangeRunConfigurationData.setImage(ImageConstants.IMG_16_EDIT);
        this.btnChangeRunConfigurationData.setText(com.kms.katalon.composer.execution.constants.StringConstants.EDIT);
    }

    private void createOptionsPart(Composite parent) {
        Composite optionsContainer = new Composite(parent, 0);
        optionsContainer.setLayout((Layout)new GridLayout());
        optionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpOptionsContainer = new Group(optionsContainer, 0);
        grpOptionsContainer.setLayout((Layout)new GridLayout(3, false));
        grpOptionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpOptionsContainer.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_GRP_OTHER_OPTIONS);
        this.chkDisplayConsoleLog = new Button((Composite)grpOptionsContainer, 32);
        this.chkDisplayConsoleLog.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.chkDisplayConsoleLog.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_CHK_DISPLAY_CONSOLE_LOG);
        this.chkKeepConsoleLog = new Button((Composite)grpOptionsContainer, 32);
        this.chkKeepConsoleLog.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.chkKeepConsoleLog.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_CHK_KEEP_CONSOLE_LOG);
        Composite compRetry = new Composite((Composite)grpOptionsContainer, 0);
        GridLayout glRetry = new GridLayout(4, false);
        glRetry.marginWidth = 0;
        glRetry.marginHeight = 0;
        compRetry.setLayout((Layout)glRetry);
        compRetry.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        Label lblRetry = new Label(compRetry, 0);
        lblRetry.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblRetry.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_LBL_RETRY_TEST_SUITE);
        lblRetry.setToolTipText(StringConstants.PA_LBL_TOOLTIP_RETRY);
        this.txtRetry = new Text(compRetry, 0x1000800);
        GridData gdTxtRetry = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtRetry.widthHint = 30;
        this.txtRetry.setLayoutData((Object)gdTxtRetry);
        this.txtRetry.setTextLimit(3);
        this.txtRetry.setToolTipText(StringConstants.PA_LBL_TOOLTIP_RETRY);
        Label lblRetry1 = new Label(compRetry, 0);
        lblRetry1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblRetry1.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_LBL_RETRY_TIMES);
        this.chkRetryFailedTestCase = new Button(compRetry, 32);
        this.chkRetryFailedTestCase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkRetryFailedTestCase.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_CHK_FOR_FAILED_TEST_CASES);
        this.chkRetryFailedTestCase.setToolTipText(StringConstants.PA_LBL_TOOLTIP_TEST_CASE_ONLY);
        Label lblUpdateStatusTiming = new Label((Composite)grpOptionsContainer, 0);
        lblUpdateStatusTiming.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_LBL_UPDATE_EXECUTION_STATUS);
        this.txtStatusDelay = new Text((Composite)grpOptionsContainer, 0x1000800);
        GridData gdTxtUpdateStatusTiming = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtUpdateStatusTiming.widthHint = 30;
        this.txtStatusDelay.setLayoutData((Object)gdTxtUpdateStatusTiming);
        this.txtStatusDelay.setTextLimit(5);
        Label lblSeconds = new Label((Composite)grpOptionsContainer, 0);
        lblSeconds.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_LBL_SECONDS);
        Composite pluginOptionsComposite = new Composite((Composite)grpOptionsContainer, 0);
        pluginOptionsComposite.setLayout((Layout)new GridLayout(2, false));
        pluginOptionsComposite.setLayoutData((Object)new GridData(16384, 128, true, false, 3, 1));
        Label lblKStoreApiKeyUsage = new Label(pluginOptionsComposite, 0);
        ControlUtils.setFontStyle((Control)lblKStoreApiKeyUsage, (int)3, (int)-1);
        lblKStoreApiKeyUsage.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_LBL_KSTORE_API_KEY_USAGE);
        new HelpComposite(pluginOptionsComposite, DocumentationMessageConstants.KSTORE_API_KEYS_USAGE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 22, com.kms.katalon.composer.execution.constants.StringConstants.DIA_BTN_GEN_PROPERTY_FILE, false);
        this.createButton(parent, 23, com.kms.katalon.composer.execution.constants.StringConstants.DIA_BTN_GEN_COMMAND, true);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected boolean hasDocumentation() {
        return true;
    }

    protected String getDocumentationUrl() {
        return DocumentationMessageConstants.DIALOG_GENERATE_COMMAND;
    }

    protected void setInput() {
        this.txtRetry.setText(DEFAULT_RETRY_TIME);
        this.chkRetryFailedTestCase.setSelection(false);
        this.txtStatusDelay.setText(defaultStatusDelay);
        this.enableRetryFailedTestCase();
        this.loadLastWorkingData();
        this.updatePlatformLayout();
    }

    private void loadLastWorkingData() {
        try {
            ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
            if (!prefs.isDefault("generateCommand.displayConsoleLog")) {
                this.chkDisplayConsoleLog.setSelection(prefs.getBoolean("generateCommand.displayConsoleLog"));
            }
            if (!prefs.isDefault("generateCommand.noCloseConsoleLog")) {
                this.chkKeepConsoleLog.setSelection(prefs.getBoolean("generateCommand.noCloseConsoleLog"));
            }
            if (!prefs.isDefault("generateCommand.updateStatusTimeInterval")) {
                this.txtStatusDelay.setText(String.valueOf(prefs.getInt("generateCommand.updateStatusTimeInterval")));
            }
            if (!prefs.isDefault("generateCommand.retry")) {
                this.txtRetry.setText(String.valueOf(prefs.getInt("generateCommand.retry")));
                this.enableRetryFailedTestCase();
            }
            if (!prefs.isDefault("generateCommand.retry.forFailedTestCases")) {
                this.chkRetryFailedTestCase.setSelection(prefs.getBoolean("generateCommand.retry.forFailedTestCases"));
            }
            if (!prefs.isDefault("generateCommand.suiteId")) {
                String prefSuiteId = prefs.getString("generateCommand.suiteId");
                this.changeSuiteArtifact(this.getSelectedTestSuite(prefSuiteId));
            }
            this.onRunConfigurationChanged(this.getStoredConfigurationDescription());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private FileEntity getSelectedTestSuite(String prefSuiteId) throws Exception {
        if (this.isTestSuite(prefSuiteId)) {
            return TestSuiteController.getInstance().getTestSuiteByDisplayId(prefSuiteId, this.project);
        }
        return TestSuiteCollectionController.getInstance().getTestSuiteCollection(prefSuiteId);
    }

    private void enableRetryFailedTestCase() {
        String retry = this.txtRetry.getText();
        this.chkRetryFailedTestCase.setEnabled(!ZERO.equals(retry) && !retry.isEmpty());
    }

    protected void registerControlModifyListeners() {
        this.btnBrowseTestSuite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    TestSuiteSelectionDialog dialog = new TestSuiteSelectionDialog(GenerateCommandDialog.this.getShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(new EntityProvider()));
                    dialog.setInput(TreeEntityUtil.getChildren(null, (FolderEntity)FolderController.getInstance().getTestSuiteRoot(GenerateCommandDialog.this.project)));
                    if (dialog.open() != 0) {
                        return;
                    }
                    Object result = dialog.getFirstResult();
                    if (result == null) {
                        return;
                    }
                    ITreeEntity tsTreeEntity = (ITreeEntity)result;
                    FileEntity fileEntity = (FileEntity)tsTreeEntity.getObject();
                    GenerateCommandDialog.this.changeSuiteArtifact(fileEntity);
                    GenerateCommandDialog.this.onRunConfigurationChanged(GenerateCommandDialog.this.runConfigDescription);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        VerifyListener verifyNumberListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!StringUtils.isNumeric((CharSequence)e.text)) {
                    e.doit = false;
                }
            }
        };
        this.txtRetry.addVerifyListener(verifyNumberListener);
        this.txtRetry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateCommandDialog.this.enableRetryFailedTestCase();
            }
        });
        this.txtRetry.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GenerateCommandDialog.this.correctNumberInput(GenerateCommandDialog.this.txtRetry, DEFAULT_RETRY_TIME);
            }

            public void focusGained(FocusEvent e) {
                GenerateCommandDialog.this.txtRetry.selectAll();
            }
        });
        this.txtStatusDelay.addVerifyListener(verifyNumberListener);
        this.txtStatusDelay.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GenerateCommandDialog.this.correctNumberInput(GenerateCommandDialog.this.txtStatusDelay, defaultStatusDelay);
            }

            public void focusGained(FocusEvent e) {
                GenerateCommandDialog.this.txtStatusDelay.selectAll();
            }
        });
        this.btnChangeConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunConfigurationSelectionDialog dialog = new RunConfigurationSelectionDialog(GenerateCommandDialog.this.getParentShell(), GenerateCommandDialog.this.runConfigDescription);
                if (dialog.open() != 0) {
                    return;
                }
                GenerateCommandDialog.this.onRunConfigurationChanged(dialog.getSelectedConfiguration());
            }
        });
        this.btnChangeRunConfigurationData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenerateCommandDialog.this.runConfigDescription == null) {
                    return;
                }
                Map<String, String> newValue = GenerateCommandDialog.this.testExecutionItem.changeRunConfigurationData(GenerateCommandDialog.this.getShell(), GenerateCommandDialog.this.runConfigDescription.getRunConfigurationData());
                GenerateCommandDialog.this.runConfigDescription.setRunConfigurationData(newValue);
                GenerateCommandDialog.this.onRunConfigurationDataChanged();
            }
        });
        this.btnChangeProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    List profiles = GlobalVariableController.getInstance().getAllGlobalVariableCollections(ProjectController.getInstance().getCurrentProject());
                    ExecutionProfileEntity selectedProfile = profiles.stream().filter(p -> p.getName().equals(GenerateCommandDialog.this.runConfigDescription.getProfileName())).findFirst().orElse(null);
                    ExecutionProfileSelectionDialog dialog = new ExecutionProfileSelectionDialog(GenerateCommandDialog.this.getParentShell(), profiles, selectedProfile);
                    if (dialog.open() != 0) {
                        return;
                    }
                    GenerateCommandDialog.this.runConfigDescription.setProfileName(dialog.getSelectedProfile().getName());
                    GenerateCommandDialog.this.updateExecutionProfileLabel();
                }
                catch (ControllerException ex) {
                    MultiStatusErrorDialog.showErrorDialog((String)ComposerExecutionMessageConstants.PA_MSG_UNABLE_TO_SELECT_EXECUTION_PROFILES, (String)ex.getMessage(), (String)ExceptionsUtil.getMessageForThrowable((Throwable)ex));
                }
            }
        });
    }

    private void onRunConfigurationDataChanged() {
        try {
            this.updateRunConfigurationDataLabel();
        }
        finally {
            this.setGenerateCommandButtonStates();
        }
    }

    private void setGenerateCommandButtonStates() {
        boolean isValidInput = this.isValidInput();
        this.getButton(23).setEnabled(isValidInput);
        this.getButton(22).setEnabled(isValidInput);
    }

    private void onRunConfigurationChanged(RunConfigurationDescription configurationDescription) {
        try {
            this.testExecutionItem = this.getSelectedExecutionItem(configurationDescription);
            if (this.testExecutionItem != null && !this.testExecutionItem.shouldBeDisplayed(this.project)) {
                this.testExecutionItem = null;
            }
            if (this.testExecutionItem == null) {
                this.runConfigDescription = TestExecutionGroupCollector.getInstance().getDefaultConfiguration(ProjectController.getInstance().getCurrentProject());
                this.testExecutionItem = this.getSelectedExecutionItem(this.runConfigDescription);
            } else {
                this.runConfigDescription = configurationDescription;
            }
            this.updateRunConfigurationLabel();
            this.updateRunConfigurationDataLabel();
            this.updateExecutionProfileLabel();
            this.updateConfigurationDataCompositeLayout();
        }
        finally {
            this.setGenerateCommandButtonStates();
        }
    }

    private void updateExecutionProfileLabel() {
        this.lblProfileName.setImage(ImageConstants.IMG_16_PROFILE);
        this.lblProfileName.setText(this.runConfigDescription.getProfileName());
        this.lblProfileName.getParent().layout();
    }

    private void resetLabel(CLabel label, String defautText) {
        label.setImage(null);
        label.setText(defautText);
    }

    private void layoutShell() {
        Shell shell = this.getShell();
        shell.setRedraw(false);
        shell.setSize(shell.getBounds().width, shell.computeSize((int)-1, (int)-1).y);
        shell.setRedraw(true);
        shell.layout(true);
    }

    private void updateControlLayout(Composite composite, boolean visible) {
        GridData gdConfigurationData = (GridData)composite.getLayoutData();
        gdConfigurationData.exclude = !visible;
        composite.setVisible(visible);
        composite.getParent().pack();
        this.main.layout(true, true);
        this.layoutShell();
    }

    private void updatePlatformLayout() {
        this.updateControlLayout((Composite)this.grpPlatform, this.isTestSuite(this.txtTestSuite.getText()));
        this.updateConfigurationDataCompositeLayout();
    }

    private void updateConfigurationDataCompositeLayout() {
        this.updateControlLayout(this.configurationDataComposite, this.testExecutionItem != null && this.testExecutionItem.requiresExtraConfiguration() && this.testExecutionItem.shouldBeDisplayed(this.project));
    }

    private void updateRunConfigurationLabel() {
        if (this.testExecutionItem == null) {
            return;
        }
        this.lblRunConfiguration.setText(this.testExecutionItem.getName());
        try {
            String imageUrlAsString = this.testExecutionItem.getImageUrlAsString();
            if (StringUtils.isNotEmpty((CharSequence)imageUrlAsString)) {
                this.lblRunConfiguration.setImage(ImageUtil.loadImage((String)imageUrlAsString));
            } else {
                this.lblRunConfiguration.setImage(null);
            }
        }
        catch (MalformedURLException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.configurationComposite.layout(true, true);
    }

    private void updateRunConfigurationDataLabel() {
        if (this.testExecutionItem == null) {
            return;
        }
        if (this.runConfigDescription == null) {
            this.resetLabel(this.lblConfigurationData, ComposerExecutionMessageConstants.DIA_MSG_CONFIGURATION_IS_REQUIRED);
        }
        String text = (String)StringUtils.defaultIfEmpty((CharSequence)this.testExecutionItem.displayRunConfigurationData(this.runConfigDescription.getRunConfigurationData()), (CharSequence)ComposerExecutionMessageConstants.DIA_MSG_CONFIGURATION_IS_REQUIRED);
        this.lblConfigurationData.setText(text);
        this.configurationDataComposite.layout(true, true);
    }

    private TestExecutionEntryItem getSelectedExecutionItem(RunConfigurationDescription runConfigurationDescription) {
        if (runConfigurationDescription == null) {
            return null;
        }
        String runConfigurationId = runConfigurationDescription.getRunConfigurationId();
        TestExecutionGroup group = TestExecutionGroupCollector.getInstance().getGroup(runConfigurationDescription.getGroupName());
        if (group == null) {
            this.resetLabel(this.lblRunConfiguration, ComposerExecutionMessageConstants.DIA_TITLE_RUN_CONFIG_SELECTION);
            return null;
        }
        Optional<TestExecutionItem> executionItemOpt = group.getItem(runConfigurationId);
        if (!executionItemOpt.isPresent()) {
            this.resetLabel(this.lblRunConfiguration, ComposerExecutionMessageConstants.DIA_TITLE_RUN_CONFIG_SELECTION);
            return null;
        }
        return (TestExecutionEntryItem)executionItemOpt.get();
    }

    private void correctNumberInput(Text txtFieldNumber, String defaultValue) {
        String textNumber = txtFieldNumber.getText();
        if (StringUtils.isBlank((CharSequence)textNumber)) {
            txtFieldNumber.setText(defaultValue);
            return;
        }
        if (textNumber.length() > 1 && textNumber.startsWith(ZERO)) {
            txtFieldNumber.setText(Integer.valueOf(textNumber).toString());
        }
    }

    private String projectLocation() {
        return this.project.getFolderLocation();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                this.close();
                break;
            }
            case 22: {
                this.generatePropertyPressed();
                break;
            }
            case 23: {
                this.generateCommandPressed();
            }
        }
    }

    private void generatePropertyPressed() {
        try {
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFilterNames(new String[]{"Property Files (*.properties)"});
            dialog.setFilterExtensions(new String[]{"*.properties"});
            dialog.setFilterPath(this.projectLocation());
            dialog.setFileName(defaultPropertyFileName);
            String result = dialog.open();
            if (result == null) {
                return;
            }
            this.savePropertyFile(result);
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)com.kms.katalon.composer.execution.constants.StringConstants.WARN_TITLE, (String)e.getMessage());
        }
    }

    private void generateCommandPressed() {
        try {
            GeneratedCommandDialog generatedCommandDialog = new GeneratedCommandDialog(this.getShell(), this.generateCommand());
            generatedCommandDialog.open();
            Trackings.trackGenerateCmd();
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)com.kms.katalon.composer.execution.constants.StringConstants.WARN_TITLE, (String)e.getMessage());
        }
    }

    private void savePropertyFile(String fileLocation) throws Exception {
        if (StringUtils.isBlank((CharSequence)fileLocation)) {
            throw new Exception(com.kms.katalon.composer.execution.constants.StringConstants.DIA_MSG_PLS_SPECIFY_FILE_LOCATION);
        }
        try {
            ExecutionUtil.savePropertiesFile(this.getUserConsoleAgrsMap(GenerateCommandMode.PROPERTIES_FILE), (String)fileLocation);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String generateCommand() throws ExecutionException {
        Map<String, String> consoleAgrsMap = this.getUserConsoleAgrsMap(GenerateCommandMode.CONSOLE_COMMAND);
        StringBuilder commandBuilder = new StringBuilder();
        switch (Platform.getOS()) {
            case "macosx": {
                commandBuilder.append(KATALON_EXECUTABLE_MACOS);
                break;
            }
            case "win32": {
                commandBuilder.append(KATALON_EXECUTABLE_WIN32);
                break;
            }
            default: {
                commandBuilder.append(KATALON_EXECUTABLE_LINUX);
            }
        }
        commandBuilder.append(" -noSplash ");
        for (String key : consoleAgrsMap.keySet()) {
            commandBuilder.append(" ");
            commandBuilder.append(this.wrapArgName(key));
            String value = consoleAgrsMap.get(key);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            commandBuilder.append("=");
            commandBuilder.append(value);
        }
        return commandBuilder.toString();
    }

    private Map<String, String> getUserConsoleAgrsMap(GenerateCommandMode generateCommandMode) throws ExecutionException {
        String entityId;
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (generateCommandMode == GenerateCommandMode.CONSOLE_COMMAND) {
            args.put(ARG_RUN_MODE, "console");
            if (this.chkDisplayConsoleLog.getSelection()) {
                args.put(ARG_OSGI_CONSOLE_LOG, com.kms.katalon.composer.execution.constants.StringConstants.EMPTY);
            }
            if (this.chkKeepConsoleLog.getSelection()) {
                args.put(ARG_OSGI_NO_EXIT, com.kms.katalon.composer.execution.constants.StringConstants.EMPTY);
            }
        }
        args.put(ARG_PROJECT_PATH, this.getArgumentValueToSave(this.project.getLocation(), generateCommandMode));
        if (!StringUtils.equals((CharSequence)this.txtStatusDelay.getText(), (CharSequence)defaultStatusDelay)) {
            args.put(ARG_STATUS_DELAY, this.txtStatusDelay.getText());
        }
        String numOfRetry = this.txtRetry.getText();
        args.put(ARG_RETRY, numOfRetry);
        if (!StringUtils.equals((CharSequence)numOfRetry, (CharSequence)ZERO) && this.chkRetryFailedTestCase.isEnabled()) {
            args.put(ARG_RETRY_FAILED_TEST_CASES, Boolean.toString(this.chkRetryFailedTestCase.getSelection()));
        }
        if (this.isTestSuite(entityId = this.txtTestSuite.getText())) {
            args.put(ARG_TEST_SUITE_PATH, this.getArgumentValueToSave(entityId, generateCommandMode));
            for (Map.Entry entry : ConsoleOptionBuilder.argsMap((RunConfigurationDescription)this.runConfigDescription).entrySet()) {
                args.put((String)entry.getKey(), this.getArgumentValueToSave((String)entry.getValue(), generateCommandMode));
            }
        } else {
            args.put(ARG_TEST_SUITE_COLLECTION_PATH, this.getArgumentValueToSave(entityId, generateCommandMode));
            return args;
        }
        return args;
    }

    private boolean isTestSuite(String id) {
        try {
            return TestSuiteController.getInstance().getTestSuiteByDisplayId(id, ProjectController.getInstance().getCurrentProject()) != null;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    private String wrapArgName(String name) {
        return "-" + name;
    }

    private String getArgumentValueToSave(String value, GenerateCommandMode generateCommandMode) {
        if (generateCommandMode == GenerateCommandMode.PROPERTIES_FILE) {
            return value;
        }
        return this.wrapArgumentValue(value);
    }

    private String wrapArgumentValue(String value) {
        return "\"" + value + "\"";
    }

    private boolean isValidInput() {
        String entityId = this.txtTestSuite.getText();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return false;
        }
        if (!this.isTestSuite(entityId)) {
            return true;
        }
        if (this.runConfigDescription == null || this.testExecutionItem == null || this.runConfigDescription.getRunConfigurationId().isEmpty()) {
            return false;
        }
        if (!this.testExecutionItem.requiresExtraConfiguration()) {
            return true;
        }
        Map runConfigurationData = this.runConfigDescription.getRunConfigurationData();
        return runConfigurationData != null && !runConfigurationData.isEmpty();
    }

    private void changeSuiteArtifact(FileEntity testSuite) {
        if (testSuite == null) {
            return;
        }
        this.txtTestSuite.setText(testSuite.getIdForDisplay());
        boolean isTestSuite = false;
        if (testSuite instanceof TestSuiteEntity) {
            TestSuiteEntity testSuiteEntity = (TestSuiteEntity)testSuite;
            this.txtRetry.setText(Integer.toString(testSuiteEntity.getNumberOfRerun()));
            this.chkRetryFailedTestCase.setSelection(testSuiteEntity.isRerunFailedTestCasesOnly());
            isTestSuite = true;
        }
        ControlUtils.recursiveSetEnabled((Control)this.grpPlatform, (boolean)isTestSuite);
        this.updatePlatformLayout();
    }

    private static ScopedPreferenceStore getPreference() {
        return PreferenceStoreManager.getPreferenceStore(GenerateCommandDialog.class);
    }

    private void saveUserInput() {
        ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
        prefs.setValue("generateCommand.suiteId", this.txtTestSuite.getText());
        prefs.setValue("generateCommand.displayConsoleLog", this.chkDisplayConsoleLog.getSelection());
        prefs.setValue("generateCommand.noCloseConsoleLog", this.chkKeepConsoleLog.getSelection());
        prefs.setValue("generateCommand.retry", this.txtRetry.getText());
        prefs.setValue("generateCommand.retry.forFailedTestCases", this.chkRetryFailedTestCase.getSelection());
        prefs.setValue("generateCommand.updateStatusTimeInterval", this.txtStatusDelay.getText());
        prefs.setValue("generateCommand.runConfigurationDescription", this.runConfigDescription != null ? JsonUtil.toJson((Object)this.runConfigDescription) : "");
        try {
            prefs.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private RunConfigurationDescription getStoredConfigurationDescription() {
        ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
        String runConfigAsJson = prefs.getString("generateCommand.runConfigurationDescription");
        if (StringUtils.isEmpty((CharSequence)runConfigAsJson)) {
            return null;
        }
        return (RunConfigurationDescription)JsonUtil.fromJson((String)runConfigAsJson, RunConfigurationDescription.class);
    }

    public boolean close() {
        this.saveUserInput();
        return super.close();
    }

    private static enum GenerateCommandMode {
        CONSOLE_COMMAND,
        PROPERTIES_FILE;

    }

    private class GeneratedCommandDialog
    extends Dialog {
        private static final int COPY_TO_CLIPBOARD_ID = 24;
        private String command;
        private Text txtCommand;

        public GeneratedCommandDialog(Shell parentShell, String command) {
            super(parentShell);
            this.command = command;
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = (Composite)super.createDialogArea(parent);
            GridLayout glMain = (GridLayout)main.getLayout();
            glMain.numColumns = 1;
            Label message = new Label(main, 0);
            message.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            message.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_LBL_GENERATED_COMMAND_MESSAGE);
            this.txtCommand = new Text(main, 2632);
            this.txtCommand.setLayoutData((Object)new GridData(4, 4, true, true));
            this.txtCommand.setText(this.getCommand());
            return main;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 24, com.kms.katalon.composer.execution.constants.StringConstants.DIA_BTN_COPY_TO_CLIPBOARD, true);
            this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 12: {
                    this.close();
                    break;
                }
                case 24: {
                    this.txtCommand.selectAll();
                    this.txtCommand.copy();
                }
            }
        }

        protected Point getInitialSize() {
            return new Point(500, 300);
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(com.kms.katalon.composer.execution.constants.StringConstants.DIA_TITLE_GENERATED_COMMAND);
            super.configureShell(newShell);
        }

        public String getCommand() {
            if (this.command == null) {
                return com.kms.katalon.composer.execution.constants.StringConstants.EMPTY;
            }
            return this.command;
        }
    }
}

