/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.dialog;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.collector.DriverConnectorEditorCollector;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.execution.collector.DriverConnectorCollector;
import com.kms.katalon.execution.configuration.CustomRunConfiguration;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.contributor.IDriverConnectorContributor;
import com.kms.katalon.execution.exception.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DriverConnectorListBuilderDialog
extends Dialog {
    private List<IDriverConnector> driverConnectorList;
    private IDriverConnectorContributor[] driverConnectorContributonList;
    private TableViewer tableViewer;
    private ToolItem tltmAddProperty;
    private ToolItem tltmRemoveProperty;
    private ToolItem tltmClearProperty;
    private File settingFolder;

    public DriverConnectorListBuilderDialog(Shell parentShell, List<IDriverConnector> driverConnectorList, CustomRunConfiguration customRunConfig) {
        super(parentShell);
        this.driverConnectorList = driverConnectorList;
        this.driverConnectorContributonList = DriverConnectorCollector.getInstance().getAllBuiltinDriverConnectorContributors();
        this.settingFolder = customRunConfig.getConfigFolder();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Composite formComposite = new Composite(container, 0);
        formComposite.setLayout((Layout)new GridLayout(1, false));
        formComposite.setLayoutData((Object)new GridData(1808));
        Composite toolbarComposite = new Composite(formComposite, 0);
        toolbarComposite.setLayout((Layout)new FillLayout(256));
        toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        this.tltmAddProperty = new ToolItem(toolBar, 0);
        this.tltmAddProperty.setText(StringConstants.SETT_TOOLITEM_ADD);
        this.tltmAddProperty.setImage(ImageConstants.IMG_16_ADD);
        this.tltmRemoveProperty = new ToolItem(toolBar, 0);
        this.tltmRemoveProperty.setText(StringConstants.SETT_TOOLITEM_REMOVE);
        this.tltmRemoveProperty.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmClearProperty = new ToolItem(toolBar, 0);
        this.tltmClearProperty.setText(StringConstants.SETT_TOOLITEM_CLEAR);
        this.tltmClearProperty.setImage(ImageConstants.IMG_16_CLEAR);
        this.addToolItemListeners();
        Composite composite = new Composite(formComposite, 0);
        GridLayout glComposite = new GridLayout(1, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        composite.setLayout((Layout)glComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(tableComposite, 67586);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_DRIVER_PREFERENCE_NAME, 100, 30, new EditingSupport((ColumnViewer)this.tableViewer){
            List<String> driverConnectorNames;
            {
                this.driverConnectorNames = new ArrayList<String>();
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof IDriverConnector && value instanceof Integer && this.driverConnectorNames != null && (Integer)value >= 0 && (Integer)value <= this.driverConnectorNames.size()) {
                    try {
                        IDriverConnector existingDriverConnector = (IDriverConnector)element;
                        IDriverConnector newDriverConnector = null;
                        String newDriverConnectorName = this.driverConnectorNames.get((Integer)value);
                        IDriverConnectorContributor[] iDriverConnectorContributorArray = DriverConnectorListBuilderDialog.this.driverConnectorContributonList;
                        int n = iDriverConnectorContributorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDriverConnectorContributor driverConnectorContributor = iDriverConnectorContributorArray[n2];
                            IDriverConnector[] iDriverConnectorArray = driverConnectorContributor.getDriverConnector(DriverConnectorListBuilderDialog.this.settingFolder.getAbsolutePath());
                            int n3 = iDriverConnectorArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IDriverConnector driverConnector = iDriverConnectorArray[n4];
                                if (driverConnector.getDriverType().toString().equals(newDriverConnectorName)) {
                                    newDriverConnector = driverConnector;
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                        int index = DriverConnectorListBuilderDialog.this.driverConnectorList.indexOf(existingDriverConnector);
                        if (index >= 0 && index < DriverConnectorListBuilderDialog.this.driverConnectorList.size() && newDriverConnector != null) {
                            DriverConnectorListBuilderDialog.this.driverConnectorList.set(index, newDriverConnector);
                            DriverConnectorListBuilderDialog.this.tableViewer.refresh();
                        }
                    }
                    catch (IOException e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof IDriverConnector) {
                    IDriverConnector existingDriverConnector = (IDriverConnector)element;
                    int i = 0;
                    while (i < this.driverConnectorNames.size()) {
                        if (this.driverConnectorNames.get(i).equals(existingDriverConnector.getDriverType().toString())) {
                            return i;
                        }
                        ++i;
                    }
                }
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                this.driverConnectorNames.clear();
                try {
                    if (element instanceof IDriverConnector) {
                        IDriverConnector selectedDriverConnector = (IDriverConnector)element;
                        IDriverConnectorContributor[] iDriverConnectorContributorArray = DriverConnectorListBuilderDialog.this.driverConnectorContributonList;
                        int n = iDriverConnectorContributorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDriverConnectorContributor driverConnectorContributor = iDriverConnectorContributorArray[n2];
                            boolean isExists = false;
                            for (IDriverConnector existingDriverConnector : DriverConnectorListBuilderDialog.this.driverConnectorList) {
                                if (selectedDriverConnector.getDriverType() == existingDriverConnector.getDriverType()) continue;
                                IDriverConnector[] iDriverConnectorArray = driverConnectorContributor.getDriverConnector(DriverConnectorListBuilderDialog.this.settingFolder.getAbsolutePath());
                                int n3 = iDriverConnectorArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IDriverConnector driverConnector = iDriverConnectorArray[n4];
                                    if (existingDriverConnector.getDriverType() == driverConnector.getDriverType()) {
                                        isExists = true;
                                    }
                                    ++n4;
                                }
                            }
                            if (!isExists) {
                                IDriverConnector[] iDriverConnectorArray = driverConnectorContributor.getDriverConnector(DriverConnectorListBuilderDialog.this.settingFolder.getAbsolutePath());
                                int n5 = iDriverConnectorArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IDriverConnector driverConnector = iDriverConnectorArray[n6];
                                    this.driverConnectorNames.add(driverConnector.getDriverType().toString());
                                    ++n6;
                                }
                            }
                            ++n2;
                        }
                        return new ComboBoxCellEditor((Composite)DriverConnectorListBuilderDialog.this.tableViewer.getTable(), this.driverConnectorNames.toArray(new String[this.driverConnectorNames.size()]));
                    }
                }
                catch (IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof IDriverConnector;
            }
        }, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDriverConnector) {
                    return ((IDriverConnector)element).getDriverType().toString();
                }
                return "";
            }
        });
        this.addTableColumn(this.tableViewer, tableColumnLayout, StringConstants.SETT_COL_PREFERENCE, 100, 70, new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                try {
                    return DriverConnectorEditorCollector.getInstance().getDriverConnector(element.getClass(), (Composite)DriverConnectorListBuilderDialog.this.tableViewer.getTable());
                }
                catch (ExecutionException | IOException e) {
                    LoggerSingleton.logError((Throwable)e);
                    return null;
                }
            }

            protected boolean canEdit(Object element) {
                return element instanceof IDriverConnector;
            }

            protected Object getValue(Object element) {
                if (element instanceof IDriverConnector) {
                    return (IDriverConnector)element;
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                int index;
                if (element instanceof IDriverConnector && value instanceof IDriverConnector && (index = DriverConnectorListBuilderDialog.this.driverConnectorList.indexOf(element)) >= 0 && index < DriverConnectorListBuilderDialog.this.driverConnectorList.size()) {
                    DriverConnectorListBuilderDialog.this.driverConnectorList.set(index, (IDriverConnector)value);
                    DriverConnectorListBuilderDialog.this.tableViewer.refresh();
                }
            }
        }, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDriverConnector) {
                    return ((IDriverConnector)element).toString();
                }
                return "";
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.driverConnectorList);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIA_DRIVER_LIST_CONNECTOR_BUILDER);
    }

    private void addTableColumn(TableViewer parent, TableColumnLayout tableColumnLayout, String headerText, int width, int weight, EditingSupport editingSupport, CellLabelProvider labelProvider) {
        TableViewerColumn tableColumn = new TableViewerColumn(parent, 0);
        tableColumn.getColumn().setWidth(width);
        tableColumn.getColumn().setMoveable(true);
        tableColumn.getColumn().setText(headerText);
        tableColumn.setLabelProvider(labelProvider);
        tableColumn.setEditingSupport(editingSupport);
        tableColumnLayout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, tableColumn.getColumn().getWidth()));
    }

    public List<IDriverConnector> getDriverConnectorList() {
        return this.driverConnectorList;
    }

    private void addToolItemListeners() {
        this.tltmAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DriverConnectorListBuilderDialog.this.driverConnectorContributonList.length > 0) {
                    try {
                        IDriverConnectorContributor[] iDriverConnectorContributorArray = DriverConnectorListBuilderDialog.this.driverConnectorContributonList;
                        int n = iDriverConnectorContributorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDriverConnector[] newDriverConnectorList;
                            IDriverConnectorContributor driverConnectorContributor = iDriverConnectorContributorArray[n2];
                            boolean isExists = false;
                            for (IDriverConnector existingDriverConnector : DriverConnectorListBuilderDialog.this.driverConnectorList) {
                                IDriverConnector[] iDriverConnectorArray = driverConnectorContributor.getDriverConnector(DriverConnectorListBuilderDialog.this.settingFolder.getAbsolutePath());
                                int n3 = iDriverConnectorArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IDriverConnector driverConnector = iDriverConnectorArray[n4];
                                    if (existingDriverConnector.getDriverType() == driverConnector.getDriverType()) {
                                        isExists = true;
                                    }
                                    ++n4;
                                }
                            }
                            if (!isExists && (newDriverConnectorList = driverConnectorContributor.getDriverConnector(DriverConnectorListBuilderDialog.this.settingFolder.getAbsolutePath())).length > 0) {
                                DriverConnectorListBuilderDialog.this.driverConnectorList.add(newDriverConnectorList[0]);
                                DriverConnectorListBuilderDialog.this.tableViewer.refresh();
                                return;
                            }
                            ++n2;
                        }
                    }
                    catch (IOException exception) {
                        LoggerSingleton.logError((Throwable)exception);
                    }
                }
            }
        });
        this.tltmRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DriverConnectorListBuilderDialog.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object selectedObject : selection.toList()) {
                        if (!(selectedObject instanceof IDriverConnector)) continue;
                        IDriverConnector selectedDriverConnector = (IDriverConnector)selectedObject;
                        DriverConnectorListBuilderDialog.this.driverConnectorList.remove(selectedDriverConnector);
                    }
                    DriverConnectorListBuilderDialog.this.tableViewer.refresh();
                }
            }
        });
        this.tltmClearProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverConnectorListBuilderDialog.this.driverConnectorList.clear();
                DriverConnectorListBuilderDialog.this.tableViewer.refresh();
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }
}

