/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.debug;

import com.kms.katalon.composer.execution.util.TestCaseEditorUtil;
import com.kms.katalon.execution.logging.LogExceptionFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.launch.Decoration;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.debug.internal.ui.views.launch.StandardDecoration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CustomSourceLookupFacility
implements IPageListener,
IPartListener2,
IPropertyChangeListener,
IDebugEventSetListener {
    private static CustomSourceLookupFacility fgDefault;
    private Map<IWorkbenchPage, IEditorPart> fEditorsByPage;
    private static LRU fLookupResults;
    private IInstructionPointerPresentation fPresentation = (IInstructionPointerPresentation)DebugUITools.newDebugModelPresentation();
    private boolean fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.reuse_editor");

    static {
        fLookupResults = new LRU(10);
    }

    public static CustomSourceLookupFacility getDefault() {
        if (fgDefault == null) {
            fgDefault = new CustomSourceLookupFacility();
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.dispose();
        }
    }

    private CustomSourceLookupFacility() {
        this.fEditorsByPage = new HashMap<IWorkbenchPage, IEditorPart>();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        IStackFrame frame = null;
        int i = 0;
        while (i < events.length) {
            final DebugEvent event = events[i];
            switch (event.getKind()) {
                case 1: 
                case 8: {
                    if (event.isEvaluation()) break;
                    UIJob uijob = new UIJob("clear source selection"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            CustomSourceLookupFacility.this.clearSourceSelection(event.getSource());
                            return Status.OK_STATUS;
                        }
                    };
                    uijob.setSystem(true);
                    uijob.schedule();
                    break;
                }
                case 16: {
                    if (!(event.getSource() instanceof IStackFrame) || event.getDetail() != 512) break;
                    frame = (IStackFrame)event.getSource();
                    fLookupResults.remove(new ArtifactWithLocator(frame, frame.getLaunch().getSourceLocator()));
                    break;
                }
            }
            ++i;
        }
    }

    private boolean isNotSourceNotFoundEditor(String editorId) {
        return !"org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor".equals(editorId) && !"org.eclipse.debug.ui.NoSourceFoundEditor".equals(editorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomSourceLookupResult lookup(Object artifact, ISourceLocator locator, boolean force) {
        CustomSourceLookupResult result = null;
        LRU lRU = fLookupResults;
        synchronized (lRU) {
            ISourceLocator localLocator;
            String editorId;
            ArtifactWithLocator key = new ArtifactWithLocator(artifact, locator);
            if (!force && (result = (CustomSourceLookupResult)((Object)fLookupResults.get(key))) != null && (editorId = result.getEditorId()) != null && this.isNotSourceNotFoundEditor(editorId)) {
                return result;
            }
            result = new CustomSourceLookupResult(artifact, null, null, null);
            IDebugElement debugElement = null;
            if (artifact instanceof IDebugElement) {
                debugElement = (IDebugElement)artifact;
            }
            if ((localLocator = locator) == null) {
                ILaunch launch = null;
                if (debugElement != null) {
                    launch = debugElement.getLaunch();
                }
                if (launch != null) {
                    localLocator = launch.getSourceLocator();
                }
            }
            if (localLocator != null) {
                String editorId2 = null;
                CommonSourceNotFoundEditorInput editorInput = null;
                Object sourceElement = null;
                if (localLocator instanceof ISourceLookupDirector) {
                    ISourceLookupDirector director = (ISourceLookupDirector)localLocator;
                    sourceElement = director.getSourceElement(artifact);
                } else if (artifact instanceof IStackFrame) {
                    sourceElement = localLocator.getSourceElement((IStackFrame)artifact);
                }
                if (sourceElement == null) {
                    if (localLocator instanceof AbstractSourceLookupDirector) {
                        editorInput = new CommonSourceNotFoundEditorInput(artifact);
                        editorId2 = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
                    } else if (artifact instanceof IStackFrame) {
                        IStackFrame frame = (IStackFrame)artifact;
                        editorInput = new SourceNotFoundEditorInput(frame);
                        editorId2 = "org.eclipse.debug.ui.NoSourceFoundEditor";
                    }
                } else {
                    ISourcePresentation presentation = null;
                    if (localLocator instanceof ISourcePresentation) {
                        presentation = (ISourcePresentation)localLocator;
                    } else if (debugElement != null) {
                        presentation = this.getPresentation(debugElement.getModelIdentifier());
                    }
                    if (presentation != null) {
                        editorInput = presentation.getEditorInput(sourceElement);
                    }
                    if (editorInput != null && presentation != null) {
                        editorId2 = presentation.getEditorId((IEditorInput)editorInput, sourceElement);
                    }
                }
                result.setEditorInput((IEditorInput)editorInput);
                result.setEditorId(editorId2);
                result.setSourceElement(sourceElement);
                fLookupResults.put((Object)key, result);
            }
        }
        return result;
    }

    protected IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)DebugUIPlugin.getModelPresentation()).getPresentation(id);
    }

    protected IDebugEditorPresentation getEditorPresentation() {
        return (DelegatingModelPresentation)DebugUIPlugin.getModelPresentation();
    }

    public void display(ISourceLookupResult result, IWorkbenchPage page) {
        IEditorPart editor = this.openEditor(result, page);
        if (editor == null) {
            return;
        }
        IStackFrame frame = null;
        if (result.getArtifact() instanceof IStackFrame) {
            frame = (IStackFrame)result.getArtifact();
        }
        if (frame != null) {
            IDebugEditorPresentation editorPresentation = this.getEditorPresentation();
            if (editorPresentation.addAnnotations(editor, frame)) {
                StandardDecoration decoration = new StandardDecoration(editorPresentation, editor, frame.getThread());
                DecorationManager.addDecoration((Decoration)decoration);
            } else {
                ITextEditor textEditor = null;
                textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                if (textEditor != null) {
                    this.positionEditor(textEditor, frame);
                    InstructionPointerManager.getDefault().removeAnnotations(textEditor);
                    Annotation annotation = this.fPresentation.getInstructionPointerAnnotation((IEditorPart)textEditor, frame);
                    if (annotation != null) {
                        InstructionPointerManager.getDefault().addAnnotation(textEditor, frame, annotation);
                    }
                }
            }
        }
    }

    private IEditorPart openEditor(ISourceLookupResult result, IWorkbenchPage page) {
        IFile file;
        String fileName;
        IEditorPart editor = null;
        IEditorInput input = result.getEditorInput();
        if (input instanceof FileEditorInput && LogExceptionFilter.isTestCaseScript((String)(fileName = FilenameUtils.getBaseName((String)(file = ((FileEditorInput)input).getFile()).getName())))) {
            try {
                return TestCaseEditorUtil.getTestCaseEditorByScriptName(fileName);
            }
            catch (Exception exception) {}
        }
        String id = result.getEditorId();
        if (input == null || id == null) {
            return null;
        }
        if (this.fReuseEditor) {
            IEditorReference[] references = page.findEditors(input, id, 3);
            if (references.length > 0) {
                IEditorPart refEditor;
                editor = refEditor = references[0].getEditor(false);
                page.bringToTop((IWorkbenchPart)editor);
            }
            if (editor == null) {
                IEditorPart editorForPage = this.getEditor(page);
                if (editorForPage == null || editorForPage.isDirty() || page.isEditorPinned(editorForPage)) {
                    editorForPage = editor = this.openEditor(page, input, id);
                } else if (editorForPage instanceof IReusableEditor && editorForPage.getSite().getId().equals(id)) {
                    page.reuseEditor((IReusableEditor)editorForPage, input);
                    editor = editorForPage;
                    if (!page.isPartVisible((IWorkbenchPart)editor)) {
                        page.bringToTop((IWorkbenchPart)editor);
                    }
                } else {
                    editor = this.openEditor(page, input, id);
                    page.closeEditor(editorForPage, false);
                    editorForPage = editor;
                }
                this.setEditor(page, editorForPage);
            }
        } else {
            editor = this.openEditor(page, input, id);
        }
        return editor;
    }

    private void positionEditor(ITextEditor editor, IStackFrame frame) {
        try {
            IRegion region;
            int charStart = frame.getCharStart();
            if (charStart >= 0) {
                editor.selectAndReveal(charStart, 0);
                return;
            }
            int lineNumber = frame.getLineNumber();
            if ((region = this.getLineInformation(editor, --lineNumber)) != null) {
                editor.selectAndReveal(region.getOffset(), 0);
            }
        }
        catch (DebugException debugException) {}
    }

    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    private IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!page.getWorkbenchWindow().getWorkbench().isClosing()) {
                    try {
                        editor[0] = page.openEditor(input, id, false, 3);
                    }
                    catch (PartInitException e) {
                        DebugUIPlugin.errorDialog((Shell)DebugUIPlugin.getShell(), (String)DebugUIViewsMessages.LaunchView_Error_1, (String)DebugUIViewsMessages.LaunchView_Exception_occurred_opening_editor_for_debugger__2, (Throwable)e);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return editor[0];
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        this.fEditorsByPage.remove(page);
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener2)this);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPage page = partRef.getPage();
        IEditorPart editor = this.getEditor(page);
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part.equals(editor)) {
            this.fEditorsByPage.remove(page);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("org.eclipse.debug.ui.reuse_editor")) {
            this.fReuseEditor = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.reuse_editor");
        }
    }

    protected IEditorPart getEditor(IWorkbenchPage page) {
        return this.fEditorsByPage.get(page);
    }

    protected void setEditor(IWorkbenchPage page, IEditorPart editorPart) {
        if (editorPart == null) {
            this.fEditorsByPage.remove(page);
        } else {
            this.fEditorsByPage.put(page, editorPart);
        }
        page.addPartListener((IPartListener2)this);
        page.getWorkbenchWindow().addPageListener((IPageListener)this);
    }

    protected void dispose() {
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fEditorsByPage.clear();
        this.fPresentation.dispose();
        fLookupResults.clear();
    }

    public synchronized void displaySource(Object context, IWorkbenchPage page, boolean force) {
        IStackFrame frame = (IStackFrame)context;
        SourceLookupJob slj = new SourceLookupJob(frame, frame.getLaunch().getSourceLocator(), page, force);
        Job.getJobManager().cancel((Object)slj);
        slj.schedule();
    }

    private void clearSourceSelection(Object source) {
        if (source instanceof IThread) {
            IThread thread = (IThread)source;
            DecorationManager.removeDecorations((IThread)thread);
            InstructionPointerManager.getDefault().removeAnnotations(thread);
        } else if (source instanceof IDebugTarget) {
            IDebugTarget target = (IDebugTarget)source;
            DecorationManager.removeDecorations((IDebugTarget)target);
            InstructionPointerManager.getDefault().removeAnnotations(target);
        }
    }

    private class ArtifactWithLocator {
        public final Object artifact;
        public final ISourceLocator locator;

        public ArtifactWithLocator(Object artifact, ISourceLocator locator) {
            this.artifact = artifact;
            this.locator = locator;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
            result = 31 * result + (this.locator == null ? 0 : this.locator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArtifactWithLocator other = (ArtifactWithLocator)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.artifact == null ? other.artifact != null : !this.artifact.equals(other.artifact)) {
                return false;
            }
            return !(this.locator == null ? other.locator != null : !this.locator.equals(other.locator));
        }

        private CustomSourceLookupFacility getOuterType() {
            return CustomSourceLookupFacility.this;
        }
    }

    public class CustomSourceLookupResult
    extends SourceLookupResult {
        public CustomSourceLookupResult(Object artifact, Object sourceElement, String editorId, IEditorInput editorInput) {
            super(artifact, sourceElement, editorId, editorInput);
        }

        protected void setEditorId(String id) {
            super.setEditorId(id);
        }

        protected void setEditorInput(IEditorInput input) {
            super.setEditorInput(input);
        }

        protected void setSourceElement(Object element) {
            super.setSourceElement(element);
        }
    }

    static class LRU
    extends HashMap<Object, CustomSourceLookupResult> {
        private static final long serialVersionUID = 1L;
        ArrayList<Object> fEntryStack = null;
        int fSize;

        LRU(int size) {
            this.fSize = size;
            this.fEntryStack = new ArrayList();
        }

        @Override
        public CustomSourceLookupResult put(Object key, CustomSourceLookupResult value) {
            this.shuffle(key);
            return super.put(key, value);
        }

        @Override
        public CustomSourceLookupResult remove(Object key) {
            CustomSourceLookupResult oldResult = (CustomSourceLookupResult)((Object)super.remove(key));
            this.fEntryStack.remove((Object)oldResult);
            return oldResult;
        }

        void shuffle(Object key) {
            int index = this.fEntryStack.indexOf(key);
            if (index < 0) {
                if (this.fEntryStack.size() >= this.fSize) {
                    this.remove(this.fEntryStack.get(this.fEntryStack.size() - 1));
                }
            } else {
                this.fEntryStack.remove(index);
            }
            this.fEntryStack.add(0, key);
        }
    }

    class SourceDisplayJob
    extends UIJob {
        private ISourceLookupResult fResult;
        private IWorkbenchPage fPage;

        public SourceDisplayJob(ISourceLookupResult result, IWorkbenchPage page) {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.fResult = result;
            this.fPage = page;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled() && this.fResult != null) {
                Object artifact;
                CustomSourceLookupFacility.this.display(this.fResult, this.fPage);
                if (monitor.isCanceled() && (artifact = this.fResult.getArtifact()) instanceof IStackFrame) {
                    CustomSourceLookupFacility.this.clearSourceSelection(((IStackFrame)artifact).getThread());
                }
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof SourceDisplayJob) {
                SourceDisplayJob sdj = (SourceDisplayJob)((Object)family);
                return sdj.fPage.equals(this.fPage);
            }
            return false;
        }
    }

    class SourceLookupJob
    extends Job {
        private IStackFrame fTarget;
        private ISourceLocator fLocator;
        private IWorkbenchPage fPage;
        private boolean fForce;

        public SourceLookupJob(IStackFrame frame, ISourceLocator locator, IWorkbenchPage page, boolean force) {
            super("Debug Source Lookup");
            this.fForce = false;
            this.setPriority(10);
            this.setSystem(true);
            this.fTarget = frame;
            this.fLocator = locator;
            this.fPage = page;
            this.fForce = force;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled() && !this.fTarget.isTerminated()) {
                CustomSourceLookupResult result = CustomSourceLookupFacility.this.lookup(this.fTarget, this.fLocator, this.fForce);
                if (!monitor.isCanceled() && !this.fTarget.isTerminated() && this.fPage != null) {
                    new SourceDisplayJob((ISourceLookupResult)result, this.fPage).schedule();
                }
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof SourceLookupJob) {
                SourceLookupJob slj = (SourceLookupJob)((Object)family);
                return slj.fPage.equals(this.fPage);
            }
            return false;
        }
    }
}

