/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.collection.collector;

import com.kms.katalon.composer.execution.collection.provider.CustomTestExecutionGroup;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionConfigurationProvider;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionGroup;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionItem;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TestExecutionGroupCollector {
    private static TestExecutionGroupCollector instance;
    private Map<String, TestExecutionGroup> testExecutionGroupCollector = new HashMap<String, TestExecutionGroup>();

    private TestExecutionGroupCollector() {
        CustomTestExecutionGroup customExecutionGroup = new CustomTestExecutionGroup();
        this.testExecutionGroupCollector.put(customExecutionGroup.getName(), customExecutionGroup);
    }

    public static TestExecutionGroupCollector getInstance() {
        if (instance == null) {
            instance = new TestExecutionGroupCollector();
        }
        return instance;
    }

    public void addGroup(TestExecutionGroup groupTestRunExecution) {
        this.testExecutionGroupCollector.put(groupTestRunExecution.getName(), groupTestRunExecution);
    }

    private List<TestExecutionGroup> getUnsortedGroups() {
        ArrayList<TestExecutionGroup> groups = new ArrayList<TestExecutionGroup>();
        for (Map.Entry<String, TestExecutionGroup> entry : this.testExecutionGroupCollector.entrySet()) {
            groups.add(entry.getValue());
        }
        return groups;
    }

    public List<TestExecutionGroup> getSortedGroups() {
        List<TestExecutionGroup> groups = this.getUnsortedGroups();
        Collections.sort(groups, new Comparator<TestExecutionGroup>(){

            @Override
            public int compare(TestExecutionGroup group1, TestExecutionGroup group2) {
                return group1.preferredOrder() - group2.preferredOrder();
            }
        });
        return groups;
    }

    public TestExecutionGroup[] getGroupAsArray() {
        List<TestExecutionGroup> sortedGroups = this.getSortedGroups();
        return sortedGroups.toArray(new TestExecutionGroup[sortedGroups.size()]);
    }

    public TestExecutionConfigurationProvider getExecutionProvider(RunConfigurationDescription configuration) {
        TestExecutionGroup group = this.testExecutionGroupCollector.get(configuration.getGroupName());
        if (group == null) {
            return null;
        }
        TestExecutionItem[] testExecutionItemArray = group.getChildren();
        int n = testExecutionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestExecutionItem child = testExecutionItemArray[n2];
            if (child instanceof TestExecutionConfigurationProvider && StringUtils.equals((CharSequence)configuration.getRunConfigurationId(), (CharSequence)child.getName())) {
                return (TestExecutionConfigurationProvider)child;
            }
            ++n2;
        }
        return null;
    }

    public TestExecutionGroup getGroup(String groupName) {
        return this.testExecutionGroupCollector.get(groupName);
    }

    public RunConfigurationDescription getDefaultConfiguration(ProjectEntity project) {
        for (TestExecutionGroup group : this.getUnsortedGroups()) {
            if (!group.shouldBeDisplayed(project)) continue;
            TestExecutionItem[] testExecutionItemArray = group.getChildren();
            int n = testExecutionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestExecutionItem item = testExecutionItemArray[n2];
                if (item instanceof TestExecutionConfigurationProvider) {
                    TestExecutionConfigurationProvider executionProvider = (TestExecutionConfigurationProvider)item;
                    return executionProvider.toConfigurationEntity(null);
                }
                ++n2;
            }
        }
        return null;
    }
}

