/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.addons;

import com.kms.katalon.composer.components.impl.control.PartListenerAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.debug.CustomSourceLookupService;
import com.kms.katalon.composer.execution.debug.handler.ToggleBreakpointHandler;
import com.kms.katalon.composer.execution.handlers.EvaluateDriverConnectorEditorContributionsHandler;
import com.kms.katalon.composer.execution.jobs.ExecuteTestCaseJob;
import com.kms.katalon.composer.execution.menu.CustomExecutionMenuContribution;
import com.kms.katalon.composer.execution.menu.ExecutionHandledMenuItem;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.model.ExecuteFromTestStepEntity;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.collector.ConsoleOptionCollector;
import com.kms.katalon.execution.configuration.ExistingRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.internal.ui.commands.actions.StepIntoCommandHandler;
import org.eclipse.debug.internal.ui.commands.actions.StepOverCommandHandler;
import org.eclipse.debug.internal.ui.commands.actions.StepReturnCommandHandler;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestExecutionAddon
implements EventHandler {
    private static final String TOGGLE_BREAKPOINT_COMMAND = "org.eclipse.debug.ui.commands.ToggleBreakpoint";
    private static final String STEP_RETURN_COMMAND = "org.eclipse.debug.ui.commands.StepReturn";
    private static final String STEP_OVER_COMMAND = "org.eclipse.debug.ui.commands.StepOver";
    private static final String STEP_INTO_COMMAND = "org.eclipse.debug.ui.commands.StepInto";
    @Inject
    private IEclipseContext context;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private UISynchronize sync;
    @Inject
    private EPartService partService;

    @PostConstruct
    public void initHandlers(IEventBroker eventBroker) {
        ContextInjectionFactory.make(EvaluateDriverConnectorEditorContributionsHandler.class, (IEclipseContext)this.context);
        eventBroker.subscribe("WORKSPACE/CREATED", (EventHandler)this);
        eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.initCustomRunConfigurationSubMenu("com.kms.katalon.composer.execution.handledtoolitem.run", "com.kms.katalon.composer.execution.run.custom");
        this.initCustomRunConfigurationSubMenu("com.kms.katalon.composer.execution.handledtoolitem.debug", "com.kms.katalon.composer.execution.debug.custom");
        this.startSessionServer();
        eventBroker.subscribe("EXECUTE/FROM_TEST_STEP", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof ExecuteFromTestStepEntity)) {
                    return;
                }
                if (TestExecutionAddon.this.partService.saveAll(true) && TestExecutionAddon.this.partService.getDirtyParts().isEmpty()) {
                    TestExecutionAddon.this.executeTestCaseFromTestStep((ExecuteFromTestStepEntity)object);
                }
            }
        });
    }

    private void initCustomRunConfigurationSubMenu(String parentToolItemId, String elementId) {
        MToolItem parentToolItem = (MToolItem)this.modelService.find(parentToolItemId, (MUIElement)this.application);
        MMenu menu = parentToolItem.getMenu();
        MMenu subMenu = MMenuFactory.INSTANCE.createMenu();
        subMenu.setLabel(StringConstants.CUSTOM_RUN_MENU_LABEL);
        subMenu.setElementId(elementId);
        MDynamicMenuContribution dynamicMenuContributor = MMenuFactory.INSTANCE.createDynamicMenuContribution();
        dynamicMenuContributor.setElementId("com.kms.katalon.composer.execution.run.custom.contributor");
        dynamicMenuContributor.setContributionURI("bundleclass://com.kms.katalon.composer.execution/" + CustomExecutionMenuContribution.class.getName());
        subMenu.getChildren().add(dynamicMenuContributor);
        menu.getChildren().add(MMenuFactory.INSTANCE.createMenuSeparator());
        menu.getChildren().add(subMenu);
    }

    public void handleEvent(Event event) {
        if ("WORKSPACE/CREATED".equals(event.getTopic())) {
            this.activeDefaultIconForExecution();
            this.activeDebugHandlers();
            this.registerDebugImages();
            this.registerPartListeners();
            this.activeSourceLookupService();
        } else if ("PROJECT/OPENED".equals(event.getTopic())) {
            this.writeDefaultConsolePropertyFile();
        }
    }

    private void activeSourceLookupService() {
        AdapterManager adapterManager = AdapterManager.getDefault();
        adapterManager.registerAdapters(new IAdapterFactory(){

            public Class<?>[] getAdapterList() {
                return new Class[]{ISourceDisplay.class};
            }

            public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
                return (T)((Object)new CustomSourceLookupService(PlatformUI.getWorkbench().getActiveWorkbenchWindow()));
            }
        }, JDIStackFrame.class);
    }

    private void registerPartListeners() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        activeWorkbenchWindow.getPartService().addPartListener((IPartListener2)new PartListenerAdapter(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if ("org.eclipse.debug.ui.DebugView".equals(partRef.getId())) {
                    TestExecutionAddon.this.registerDebugImages();
                }
            }
        });
    }

    private void registerDebugImages() {
        this.modelService.find("org.eclipse.debug.ui.DebugView", (MUIElement)this.application).getTransientData().put("e4_override_icon_image_key", ImageManager.getImage((String)"debug_perspective_16.png"));
    }

    private void writeDefaultConsolePropertyFile() {
        try {
            ConsoleOptionCollector.getInstance().writeDefaultPropertyFile(ProjectController.getInstance().getCurrentProject());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void activeDefaultIconForExecution() {
        this.wrapExecutionMenuItemsProcessor("com.kms.katalon.composer.execution.handledtoolitem.run");
        this.wrapExecutionMenuItemsProcessor("com.kms.katalon.composer.execution.handledtoolitem.debug");
    }

    private void activeDebugHandlers() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        if (handlerService == null) {
            return;
        }
        handlerService.activateHandler(STEP_INTO_COMMAND, (IHandler)new StepIntoCommandHandler());
        handlerService.activateHandler(STEP_OVER_COMMAND, (IHandler)new StepOverCommandHandler());
        handlerService.activateHandler(STEP_RETURN_COMMAND, (IHandler)new StepReturnCommandHandler());
        handlerService.activateHandler(TOGGLE_BREAKPOINT_COMMAND, (IHandler)new ToggleBreakpointHandler());
    }

    private void wrapExecutionMenuItemsProcessor(String menuItemId) {
        MToolItem runToolItem = (MToolItem)this.modelService.find(menuItemId, (MUIElement)this.application);
        if (runToolItem == null) {
            return;
        }
        MMenu menu = runToolItem.getMenu();
        if (menu == null) {
            return;
        }
        this.convertChildrenToExecutionHandledElements(menu.getChildren());
    }

    private void convertChildrenToExecutionHandledElements(List<MMenuElement> originalElements) {
        List<MMenuElement> menuItems = this.newElements(originalElements);
        originalElements.clear();
        originalElements.addAll(menuItems);
    }

    private List<MMenuElement> newElements(List<MMenuElement> originalElements) {
        if (originalElements == null) {
            return Collections.emptyList();
        }
        ArrayList<MMenuElement> menuItems = new ArrayList<MMenuElement>();
        Iterator<MMenuElement> iterator = originalElements.iterator();
        while (iterator.hasNext()) {
            MMenuElement item;
            Object wrappedItem = item = iterator.next();
            if (item instanceof MHandledMenuItem) {
                wrappedItem = new ExecutionHandledMenuItem((MHandledMenuItem)item);
            }
            if (item instanceof MMenu) {
                this.convertChildrenToExecutionHandledElements(((MMenu)item).getChildren());
            }
            menuItems.add((MMenuElement)wrappedItem);
        }
        return menuItems;
    }

    private void startSessionServer() {
        new Thread((Runnable)ExecutionSessionSocketServer.getInstance()).start();
    }

    private void executeTestCaseFromTestStep(ExecuteFromTestStepEntity executeFromTestStepEntity) {
        if (executeFromTestStepEntity == null || executeFromTestStepEntity.getTestCase() == null) {
            return;
        }
        try {
            ExistingRunConfiguration runConfiguration;
            ExistingRunConfiguration existingRunConfiguration = runConfiguration = new ExistingRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation());
            existingRunConfiguration.setSessionId(executeFromTestStepEntity.getSessionId());
            existingRunConfiguration.setRemoteUrl(executeFromTestStepEntity.getRemoteServerUrl());
            existingRunConfiguration.setDriverName(executeFromTestStepEntity.getDriverTypeName());
            ((DefaultExecutionSetting)existingRunConfiguration.getExecutionSetting()).setRawScript(executeFromTestStepEntity.getRawScript());
            ExecuteTestCaseJob job = new ExecuteTestCaseJob(StringConstants.HAND_JOB_LAUNCHING_TEST_CASE, (IRunConfiguration)existingRunConfiguration, executeFromTestStepEntity.getTestCase(), LaunchMode.RUN, this.sync);
            job.setUser(true);
            job.schedule();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

